/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup;

import java.util.ArrayList;
import org.apache.wicket.Application;
import org.apache.wicket.Page;
import org.apache.wicket.markup.AbstractMarkupParser;
import org.apache.wicket.markup.ContainerInfo;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupResourceStream;
import org.apache.wicket.markup.html.form.AutoLabelTagHandler;
import org.apache.wicket.markup.parser.IMarkupFilter;
import org.apache.wicket.markup.parser.IXmlPullParser;
import org.apache.wicket.markup.parser.filter.EnclosureHandler;
import org.apache.wicket.markup.parser.filter.HeadForceTagIdHandler;
import org.apache.wicket.markup.parser.filter.HtmlHandler;
import org.apache.wicket.markup.parser.filter.HtmlHeaderSectionHandler;
import org.apache.wicket.markup.parser.filter.InlineEnclosureHandler;
import org.apache.wicket.markup.parser.filter.OpenCloseTagExpander;
import org.apache.wicket.markup.parser.filter.RelativePathPrefixHandler;
import org.apache.wicket.markup.parser.filter.StyleAndScriptIdentifier;
import org.apache.wicket.markup.parser.filter.WicketContainerTagHandler;
import org.apache.wicket.markup.parser.filter.WicketLinkTagHandler;
import org.apache.wicket.markup.parser.filter.WicketMessageTagHandler;
import org.apache.wicket.markup.parser.filter.WicketNamespaceHandler;
import org.apache.wicket.markup.parser.filter.WicketRemoveTagHandler;
import org.apache.wicket.markup.parser.filter.WicketTagIdentifier;
import org.apache.wicket.util.lang.Objects;

public class MarkupParser
extends AbstractMarkupParser {
    public static final String WICKET = "wicket";

    public MarkupParser(MarkupResourceStream resource) {
        super(resource);
    }

    public MarkupParser(String markup) {
        super(markup);
    }

    public MarkupParser(IXmlPullParser xmlParser, MarkupResourceStream resource) {
        super(xmlParser, resource);
    }

    public MarkupFilterList getMarkupFilters() {
        return (MarkupFilterList)super.getMarkupFilters();
    }

    public final boolean add(IMarkupFilter filter) {
        return this.getMarkupFilters().add(filter);
    }

    public final boolean add(IMarkupFilter filter, Class<? extends IMarkupFilter> beforeFilter) {
        return this.getMarkupFilters().add(filter, beforeFilter);
    }

    protected IMarkupFilter onAppendMarkupFilter(IMarkupFilter filter) {
        return filter;
    }

    protected MarkupFilterList initializeMarkupFilters(Markup markup) {
        ContainerInfo containerInfo;
        MarkupFilterList filters = new MarkupFilterList();
        MarkupResourceStream markupResourceStream = markup.getMarkupResourceStream();
        filters.add(new WicketTagIdentifier(markupResourceStream));
        filters.add(new HtmlHandler());
        filters.add(new WicketRemoveTagHandler(markupResourceStream));
        filters.add(new WicketLinkTagHandler(markupResourceStream));
        filters.add(new AutoLabelTagHandler(markupResourceStream));
        filters.add(new WicketNamespaceHandler(markupResourceStream));
        filters.add(new WicketMessageTagHandler(markupResourceStream));
        if (markupResourceStream != null && markupResourceStream.getResource() != null && (containerInfo = markupResourceStream.getContainerInfo()) != null) {
            if (Page.class.isAssignableFrom(containerInfo.getContainerClass())) {
                filters.add(new HtmlHeaderSectionHandler(markup));
            }
            filters.add(new HeadForceTagIdHandler(containerInfo.getContainerClass()));
        }
        filters.add(new OpenCloseTagExpander());
        filters.add(new RelativePathPrefixHandler(markupResourceStream));
        filters.add(new EnclosureHandler(markupResourceStream));
        filters.add(new InlineEnclosureHandler(markupResourceStream));
        filters.add(new StyleAndScriptIdentifier(), StyleAndScriptIdentifier.class);
        filters.add(new WicketContainerTagHandler(markupResourceStream, Application.get().usesDevelopmentConfig()));
        return filters;
    }

    public class MarkupFilterList
    extends ArrayList<IMarkupFilter> {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean add(IMarkupFilter filter) {
            return this.add(filter, RelativePathPrefixHandler.class);
        }

        public boolean add(IMarkupFilter filter, Class<? extends IMarkupFilter> beforeFilter) {
            if ((filter = this.onAdd(filter)) == null) {
                return false;
            }
            int index = this.firstIndexOfClass(beforeFilter);
            if (index < 0) {
                return super.add(filter);
            }
            super.add(index, filter);
            return true;
        }

        private int firstIndexOfClass(Class<? extends IMarkupFilter> filterClass) {
            int result = -1;
            if (filterClass != null) {
                int size = this.size();
                for (int index = 0; index < size; ++index) {
                    Class<?> currentFilterClass = ((IMarkupFilter)this.get(index)).getClass();
                    if (!Objects.equal(filterClass, currentFilterClass)) continue;
                    result = index;
                    break;
                }
            }
            return result;
        }

        protected IMarkupFilter onAdd(IMarkupFilter filter) {
            return MarkupParser.this.onAppendMarkupFilter(filter);
        }
    }
}

