/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.watch;

import java.time.Duration;
import java.time.Instant;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.listener.ChangeListenerSet;
import org.apache.wicket.util.listener.IChangeListener;
import org.apache.wicket.util.thread.ICode;
import org.apache.wicket.util.thread.Task;
import org.apache.wicket.util.watch.IModifiable;
import org.apache.wicket.util.watch.IModificationWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModificationWatcher
implements IModificationWatcher {
    private static final Logger log = LoggerFactory.getLogger(ModificationWatcher.class);
    private final ConcurrentHashMap<IModifiable, Entry> modifiableToEntry = Generics.newConcurrentHashMap();
    private Task task;

    public ModificationWatcher() {
    }

    public ModificationWatcher(Duration pollFrequency) {
        this.start(pollFrequency);
    }

    @Override
    public final boolean add(IModifiable modifiable, IChangeListener<IModifiable> listener) {
        Entry entry = this.modifiableToEntry.get(modifiable);
        if (entry == null) {
            Instant lastModifiedTime = modifiable.lastModifiedTime();
            if (lastModifiedTime != null) {
                Entry newEntry = new Entry();
                newEntry.modifiable = modifiable;
                newEntry.lastModifiedTime = lastModifiedTime;
                newEntry.listeners.add((IModifiable)((Object)listener));
                this.modifiableToEntry.putIfAbsent(modifiable, newEntry);
            } else {
                log.info("Cannot track modifications to resource '{}'", (Object)modifiable);
            }
            return true;
        }
        return !entry.listeners.add((IModifiable)((Object)listener));
    }

    @Override
    public IModifiable remove(IModifiable modifiable) {
        Entry entry = this.modifiableToEntry.remove(modifiable);
        if (entry != null) {
            return entry.modifiable;
        }
        return null;
    }

    @Override
    public void start(Duration pollFrequency) {
        this.task = new Task("ModificationWatcher");
        this.task.run(pollFrequency, new ICode(){

            @Override
            public void run(Logger log) {
                ModificationWatcher.this.checkModified();
            }
        });
    }

    protected void checkModified() {
        for (Entry entry : this.modifiableToEntry.values()) {
            Instant modifiableLastModified = entry.modifiable.lastModifiedTime();
            if (modifiableLastModified == null || !modifiableLastModified.isAfter(entry.lastModifiedTime)) continue;
            entry.listeners.notifyListeners(entry.modifiable);
            entry.lastModifiedTime = modifiableLastModified;
        }
    }

    @Override
    public void destroy() {
        if (this.task != null) {
            this.task.interrupt();
        }
    }

    @Override
    public final Set<IModifiable> getEntries() {
        return this.modifiableToEntry.keySet();
    }

    protected static final class Entry {
        public Instant lastModifiedTime;
        public final ChangeListenerSet<IModifiable> listeners = new ChangeListenerSet();
        public IModifiable modifiable;

        protected Entry() {
        }
    }
}

