/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.file;

import java.io.IOException;
import org.apache.wicket.util.file.File;
import org.apache.wicket.util.file.Folder;
import org.apache.wicket.util.file.IResourceFinder;
import org.apache.wicket.util.resource.FileResourceStream;
import org.apache.wicket.util.resource.IResourceStream;

public class Path
implements IResourceFinder {
    private final Folder folder;

    public Path(String folder) {
        this(new Folder(folder));
    }

    public Path(Folder folder) {
        if (!folder.exists()) {
            throw new IllegalArgumentException("Folder " + String.valueOf(folder) + " does not exist");
        }
        this.folder = folder;
    }

    @Override
    public IResourceStream find(Class<?> clazz, String pathname) {
        File file = new File(this.folder, pathname);
        if (file.exists()) {
            return new FileResourceStream(file);
        }
        return null;
    }

    public String toString() {
        try {
            return "[Path: folder = " + this.folder.getCanonicalPath() + "]";
        }
        catch (IOException e) {
            return "[Path: exception while inspecting folder]";
        }
    }
}

