/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.spring.injection.annot;

import jakarta.servlet.ServletContext;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.IBehaviorInstantiationListener;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.application.IComponentInstantiationListener;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.injection.IFieldValueFactory;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.spring.ISpringContextLocator;
import org.apache.wicket.spring.injection.annot.AnnotProxyFieldValueFactory;
import org.apache.wicket.util.lang.Args;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringComponentInjector
extends Injector
implements IComponentInstantiationListener,
IBehaviorInstantiationListener {
    private final IFieldValueFactory fieldValueFactory;
    private static MetaDataKey<ApplicationContext> CONTEXT_KEY = new MetaDataKey<ApplicationContext>(){
        private static final long serialVersionUID = 1L;
    };

    public SpringComponentInjector(WebApplication webapp) {
        this(webapp, SpringComponentInjector.getDefaultContext(webapp));
    }

    public SpringComponentInjector(WebApplication webapp, ApplicationContext ctx) {
        this(webapp, ctx, true);
    }

    public SpringComponentInjector(WebApplication webapp, ApplicationContext ctx, boolean wrapInProxies) {
        Args.notNull((Object)webapp, (String)"webapp");
        Args.notNull((Object)ctx, (String)"ctx");
        webapp.setMetaData(CONTEXT_KEY, (Object)ctx);
        this.fieldValueFactory = new AnnotProxyFieldValueFactory(new ContextLocator(), wrapInProxies);
        webapp.getBehaviorInstantiationListeners().add((Object)this);
        this.bind((Application)webapp);
    }

    public void inject(Object object) {
        this.inject(object, this.fieldValueFactory);
    }

    public void onInstantiation(Component component) {
        this.inject(component);
    }

    public void onInstantiation(Behavior behavior) {
        this.inject(behavior);
    }

    private static ApplicationContext getDefaultContext(WebApplication webapp) {
        ApplicationContext context = (ApplicationContext)webapp.getMetaData(CONTEXT_KEY);
        if (context == null) {
            context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)webapp.getServletContext());
        }
        return context;
    }

    public static void setDefaultContext(WebApplication webapp, ApplicationContext context) {
        Args.notNull((Object)context, (String)"context");
        if (webapp.getMetaData(CONTEXT_KEY) == null) {
            webapp.setMetaData(CONTEXT_KEY, (Object)context);
        }
    }

    private static class ContextLocator
    implements ISpringContextLocator {
        private transient ApplicationContext context;
        private static final long serialVersionUID = 1L;

        private ContextLocator() {
        }

        @Override
        public ApplicationContext getSpringContext() {
            if (this.context == null) {
                this.context = (ApplicationContext)Application.get().getMetaData(CONTEXT_KEY);
            }
            return this.context;
        }
    }
}

