/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator;

import io.grpc.BindableService;
import io.grpc.ServerInterceptor;
import org.apache.uniffle.common.config.RssBaseConf;
import org.apache.uniffle.common.rpc.GrpcServer;
import org.apache.uniffle.common.rpc.ServerInterface;
import org.apache.uniffle.common.rpc.ServerType;
import org.apache.uniffle.coordinator.CoordinatorConf;
import org.apache.uniffle.coordinator.CoordinatorGrpcService;
import org.apache.uniffle.coordinator.CoordinatorServer;

public class CoordinatorFactory {
    private final CoordinatorServer coordinatorServer;
    private final CoordinatorConf conf;

    public CoordinatorFactory(CoordinatorServer coordinatorServer) {
        this.coordinatorServer = coordinatorServer;
        this.conf = coordinatorServer.getCoordinatorConf();
    }

    public ServerInterface getServer() {
        ServerType type = (ServerType)this.conf.get(CoordinatorConf.RPC_SERVER_TYPE);
        if (type == ServerType.GRPC || type == ServerType.GRPC_NETTY) {
            return GrpcServer.Builder.newBuilder().conf((RssBaseConf)this.conf).grpcMetrics(this.coordinatorServer.getGrpcMetrics()).addService((BindableService)new CoordinatorGrpcService(this.coordinatorServer), new ServerInterceptor[0]).build();
        }
        throw new UnsupportedOperationException("Unsupported server type " + type);
    }
}

