/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.actions.sessionvalidator;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.Turbine;
import org.apache.turbine.annotation.TurbineConfiguration;
import org.apache.turbine.modules.actions.sessionvalidator.SessionValidator;
import org.apache.turbine.om.security.User;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.util.RunData;

public class DefaultSessionValidator
extends SessionValidator {
    private static Logger log = LogManager.getLogger(DefaultSessionValidator.class);
    @TurbineConfiguration(value="login.message")
    private String loginMessage;
    @TurbineConfiguration(value="screen.login")
    private String screenLogin;
    @TurbineConfiguration(value="login.message.noscreen")
    private String loginMessageNoScreen;

    @Override
    public void doPerform(PipelineData pipelineData) throws Exception {
        RunData data = pipelineData.getRunData();
        data.populate();
        if (data.getUser() == null) {
            log.debug("Creating an anonymous user object!");
            Object anonymousUser = this.security.getAnonymousUser();
            data.setUser(anonymousUser);
            data.save();
        }
        if (!data.getUser().hasLoggedIn()) {
            if (StringUtils.isEmpty((CharSequence)data.getMessage())) {
                data.setMessage(this.loginMessage);
            }
            data.setScreen(this.screenLogin);
            data.setAction(null);
        }
        if (!data.hasScreen()) {
            data.setMessage(this.loginMessageNoScreen);
            data.setScreen(this.screenHomepage);
        }
        this.handleFormCounterToken(data, true);
        pipelineData.get(Turbine.class).put(User.class, data.getUser());
    }
}

