/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.model.basic;

import org.apache.fulcrum.security.acl.AccessControlList;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.ACLFactory;
import org.apache.fulcrum.security.model.basic.BasicAccessControlListImpl;
import org.apache.fulcrum.security.model.basic.entity.BasicUser;
import org.apache.fulcrum.security.spi.AbstractManager;
import org.apache.fulcrum.security.util.GroupSet;
import org.apache.fulcrum.security.util.UnknownEntityException;

public class BasicACLFactory
extends AbstractManager
implements ACLFactory {
    private BasicAccessControlListImpl getAclInstance(GroupSet groupSet) throws UnknownEntityException {
        BasicAccessControlListImpl accessControlList;
        try {
            accessControlList = new BasicAccessControlListImpl(groupSet);
        }
        catch (Exception e) {
            throw new UnknownEntityException("Failed to instantiate an ACL implementation object", e);
        }
        return accessControlList;
    }

    @Override
    public <T extends AccessControlList> T getAccessControlList(User user) {
        GroupSet groupSet = ((BasicUser)user).getGroups();
        try {
            BasicAccessControlListImpl aclInstance = this.getAclInstance(groupSet);
            return (T)aclInstance;
        }
        catch (UnknownEntityException uue) {
            throw new RuntimeException(uue.getMessage(), uue);
        }
    }
}

