/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.mimetype.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;

public class MimeTypeMapper {
    private HashMap<String, String> mimeTypeExtensions = new HashMap();
    protected HashMap<String, String> extensionMimeTypes = new HashMap();

    public MimeTypeMapper() {
    }

    public MimeTypeMapper(InputStream input) throws IOException {
        this.parse(new BufferedReader(new InputStreamReader(input, "ISO-8859-1")));
    }

    public MimeTypeMapper(File file) throws IOException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));){
            this.parse(in);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public MimeTypeMapper(String path) throws IOException {
        this(new File(path));
    }

    public void setContentType(String spec) {
        try {
            this.parse(new BufferedReader(new StringReader(spec)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized String getContentType(String ext) {
        if (StringUtils.isNotEmpty((CharSequence)ext) && this.mimeTypeExtensions.containsKey(ext.toLowerCase())) {
            return this.mimeTypeExtensions.get(ext.toLowerCase());
        }
        return null;
    }

    public String getExtension(String type) {
        return this.extensionMimeTypes.get(type);
    }

    protected synchronized void parse(BufferedReader reader) throws IOException {
        String next;
        int count = 0;
        String str = null;
        HashMap mimeTypes = (HashMap)this.extensionMimeTypes.clone();
        HashMap extensions = (HashMap)this.mimeTypeExtensions.clone();
        while ((next = reader.readLine()) != null) {
            int l = (str = str == null ? next : str + next).length();
            if (l == 0) {
                str = null;
                continue;
            }
            if (str.charAt(l - 1) != '\\') {
                count += this.parseMimeTypeExtension(str, mimeTypes, extensions);
                str = null;
                continue;
            }
            str = str.substring(0, l - 1);
        }
        if (str != null) {
            count += this.parseMimeTypeExtension(str, mimeTypes, extensions);
        }
        if (count > 0) {
            this.extensionMimeTypes = mimeTypes;
            this.mimeTypeExtensions = extensions;
        }
    }

    protected int parseMimeTypeExtension(String spec, Map<String, String> mimeTypes, Map<String, String> extensions) {
        int count = 0;
        if ((spec = spec.trim()).length() > 0 && spec.charAt(0) != '#') {
            StringTokenizer tokens = new StringTokenizer(spec);
            String type = tokens.nextToken();
            while (tokens.hasMoreTokens()) {
                String ext = tokens.nextToken();
                if (ext.length() == 0) continue;
                extensions.put(ext, type);
                if (count++ != 0) continue;
                mimeTypes.put(type, ext);
            }
        }
        return count;
    }
}

