/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.validator;

import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.validator.Constraint;
import org.apache.fulcrum.intake.validator.DefaultValidator;
import org.apache.fulcrum.intake.validator.InvalidMaskException;
import org.apache.fulcrum.intake.validator.ValidationException;

public abstract class NumberValidator<T extends Number>
extends DefaultValidator<T> {
    String minValueMessage = null;
    String maxValueMessage = null;
    String invalidNumberMessage = null;
    private T minValue = null;
    private T maxValue = null;

    @Override
    public void init(Map<String, ? extends Constraint> paramMap) throws InvalidMaskException {
        String param;
        super.init(paramMap);
        Constraint constraint = paramMap.get("invalidNumber");
        if (constraint != null) {
            this.invalidNumberMessage = constraint.getMessage();
        }
        if ((constraint = paramMap.get("minValue")) != null) {
            param = constraint.getValue();
            try {
                this.minValue = this.parseNumber(param, Locale.US);
            }
            catch (NumberFormatException e) {
                throw new InvalidMaskException("Could not parse minimum value " + param, e);
            }
            this.minValueMessage = constraint.getMessage();
        }
        if ((constraint = paramMap.get("maxValue")) != null) {
            param = constraint.getValue();
            try {
                this.maxValue = this.parseNumber(param, Locale.US);
            }
            catch (NumberFormatException e) {
                throw new InvalidMaskException("Could not parse minimum value " + param, e);
            }
            this.maxValueMessage = constraint.getMessage();
        }
    }

    protected abstract T parseNumber(String var1, Locale var2) throws NumberFormatException;

    protected Number parseIntoNumber(String stringValue, Locale locale) throws NumberFormatException {
        NumberFormat nf = NumberFormat.getInstance(locale);
        try {
            ParsePosition pos = new ParsePosition(0);
            Number number = nf.parse(stringValue, pos);
            if (pos.getIndex() != stringValue.length()) {
                throw new ParseException("Could not parse string completely", pos.getErrorIndex());
            }
            return number;
        }
        catch (ParseException e) {
            throw new NumberFormatException(e.getMessage());
        }
    }

    @Override
    public void assertValidity(Field<T> field) throws ValidationException {
        Locale locale = field.getLocale();
        if (field.isMultiValued()) {
            String[] stringValues = (String[])field.getTestValue();
            for (int i = 0; i < stringValues.length; ++i) {
                this.assertValidity(stringValues[i], locale);
            }
        } else {
            this.assertValidity((String)field.getTestValue(), locale);
        }
    }

    public void assertValidity(String testValue, Locale locale) throws ValidationException {
        super.assertValidity(testValue);
        if (this.required || StringUtils.isNotEmpty((CharSequence)testValue)) {
            Number number = null;
            try {
                number = (Number)this.parseNumber(testValue, locale);
            }
            catch (NumberFormatException e) {
                this.errorMessage = this.invalidNumberMessage;
                throw new ValidationException(this.invalidNumberMessage);
            }
            if (this.minValue != null && number.doubleValue() < ((Number)this.minValue).doubleValue()) {
                this.errorMessage = this.minValueMessage;
                throw new ValidationException(this.minValueMessage);
            }
            if (this.maxValue != null && number.doubleValue() > ((Number)this.maxValue).doubleValue()) {
                this.errorMessage = this.maxValueMessage;
                throw new ValidationException(this.maxValueMessage);
            }
        }
    }

    public String getMinValueMessage() {
        return this.minValueMessage;
    }

    public void setMinValueMessage(String minValueMessage) {
        this.minValueMessage = minValueMessage;
    }

    public String getMaxValueMessage() {
        return this.maxValueMessage;
    }

    public void setMaxValueMessage(String maxValueMessage) {
        this.maxValueMessage = maxValueMessage;
    }

    public String getInvalidNumberMessage() {
        return this.invalidNumberMessage;
    }

    public void setInvalidNumberMessage(String invalidNumberMessage) {
        this.invalidNumberMessage = invalidNumberMessage;
    }

    public T getMinValue() {
        return this.minValue;
    }

    public void setMinValue(T minValue) {
        this.minValue = minValue;
    }

    public T getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(T maxValue) {
        this.maxValue = maxValue;
    }
}

