/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.File;
import java.io.IOException;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.NumberSequence;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.persist.Crypto;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.DataFileDefrag;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.ScriptRunner;
import org.hsqldb.scriptio.ScriptReaderBase;
import org.hsqldb.scriptio.ScriptReaderDecode;
import org.hsqldb.scriptio.ScriptReaderText;
import org.hsqldb.scriptio.ScriptWriterBase;
import org.hsqldb.scriptio.ScriptWriterEncode;
import org.hsqldb.scriptio.ScriptWriterText;

public class Log {
    private HsqlDatabaseProperties properties;
    private String baseFileName;
    private Database database;
    private FileAccess fa;
    ScriptWriterBase dbLogWriter;
    private String scriptFileName;
    private String dataFileName;
    private String backupFileName;
    private String logFileName;
    private boolean filesReadOnly;
    private long maxLogSize;
    private int writeDelay;
    private DataFileCache cache;
    private boolean isModified;

    Log(Database database) {
        this.database = database;
        this.fa = database.logger.getFileAccess();
        this.baseFileName = database.getPath();
        this.properties = database.getProperties();
    }

    void initParams() {
        this.maxLogSize = (long)this.database.logger.getLogSize() * 1024L * 1024L;
        this.writeDelay = this.database.logger.getWriteDelay();
        this.filesReadOnly = this.database.isFilesReadOnly();
        this.scriptFileName = this.baseFileName + ".script";
        this.dataFileName = this.baseFileName + ".data";
        this.backupFileName = this.baseFileName + ".backup";
        this.logFileName = this.baseFileName + ".log";
    }

    void open() {
        this.initParams();
        int n = this.properties.getDBModified();
        switch (n) {
            case 4: {
                break;
            }
            case 1: {
                this.database.logger.logInfoEvent("open start - state modified");
                this.deleteNewAndOldFiles();
                this.deleteOldTempFiles();
                this.processScript();
                this.processLog();
                this.checkpoint();
                break;
            }
            case 3: {
                this.renameNewDataFile();
            }
            case 2: {
                this.database.logger.logInfoEvent("open start - state new files");
                this.deleteBackupFile();
                this.renameNewScriptFile();
                this.properties.setDBModified(0);
            }
            case 0: {
                this.database.logger.logInfoEvent("open start - state not modified");
                this.deleteLogFile();
                this.processScript();
                if (this.filesReadOnly || !this.isAnyCacheModified()) break;
                this.properties.setDBModified(1);
                this.checkpoint();
            }
        }
        if (!this.filesReadOnly) {
            this.openLog();
        }
    }

    void close(boolean bl) {
        boolean bl2;
        this.database.logger.setFilesTimestamp(this.database.txManager.getSystemChangeNumber());
        this.closeLog();
        this.deleteOldFiles();
        this.deleteOldTempFiles();
        this.deleteTempFileDirectory();
        this.writeScript(bl);
        this.database.logger.textTableManager.closeAllTextCaches(bl);
        if (this.cache != null) {
            this.cache.close();
        }
        this.properties.setProperty("hsqldb.script_format", this.database.logger.propScriptFormat);
        this.properties.setDBModified(2);
        this.deleteLogFile();
        if (this.cache != null) {
            if (bl) {
                this.cache.deleteDataFile();
                if (this.fa.isStreamElement(this.dataFileName)) {
                    this.database.logger.logInfoEvent("delete .data file failed ");
                }
            }
            this.deleteBackupFile();
            if (this.fa.isStreamElement(this.cache.backupFileName)) {
                this.database.logger.logInfoEvent("delete .backup file failed ");
            }
        }
        if (this.fa.isStreamElement(this.logFileName)) {
            this.database.logger.logInfoEvent("delete .log file failed ");
        }
        if (bl2 = this.renameNewScriptFile()) {
            this.properties.setDBModified(0);
        }
    }

    void closeImmediately() {
        if (this.cache != null) {
            this.cache.release();
        }
        this.database.logger.textTableManager.closeAllTextCaches(false);
        this.database.logger.setFilesTimestamp(this.database.txManager.getSystemChangeNumber());
        this.closeLog();
    }

    boolean isAnyCacheModified() {
        if (this.cache != null && this.cache.isModified()) {
            return true;
        }
        return this.database.logger.textTableManager.isAnyTextCacheModified();
    }

    private boolean checkpoint() {
        if (this.filesReadOnly) {
            return true;
        }
        boolean bl = this.checkpointClose();
        boolean bl2 = this.checkpointReopen();
        if (!bl) {
            this.database.logger.logSevereEvent("checkpoint failed - see previous error", null);
        }
        return bl2;
    }

    void checkpoint(Session session, boolean bl) {
        if (this.filesReadOnly) {
            return;
        }
        if (this.cache == null) {
            bl = false;
        } else if (this.forceDefrag()) {
            bl = true;
        }
        if (bl) {
            this.defrag(session);
        } else {
            this.checkpoint();
        }
    }

    boolean checkpointClose() {
        if (this.filesReadOnly) {
            return true;
        }
        this.database.logger.setFilesTimestamp(this.database.txManager.getSystemChangeNumber());
        this.database.logger.logInfoEvent("checkpointClose start");
        this.synchLog();
        this.database.lobManager.synch();
        this.database.logger.logInfoEvent("checkpointClose synched");
        this.deleteOldFiles();
        try {
            this.writeScript(false);
            this.database.logger.logInfoEvent("checkpointClose script done");
            if (this.cache != null) {
                this.cache.reset();
            }
            this.properties.setProperty("hsqldb.script_format", this.database.logger.propScriptFormat);
            this.properties.setDBModified(2);
            if (this.cache != null) {
                this.deleteBackupFile();
            }
        }
        catch (Throwable throwable) {
            this.deleteNewScriptFile();
            this.database.logger.logSevereEvent("checkpoint failed - recovered", throwable);
            return false;
        }
        this.closeLog();
        this.deleteLogFile();
        this.renameNewScriptFile();
        try {
            this.properties.setDBModified(0);
        }
        catch (Throwable throwable) {
            this.database.logger.logSevereEvent("logger.checkpointClose properties file save failed", throwable);
        }
        this.database.logger.logInfoEvent("checkpointClose end");
        return true;
    }

    boolean checkpointReopen() {
        if (this.filesReadOnly) {
            return true;
        }
        this.database.sessionManager.resetLoggedSchemas();
        try {
            if (this.cache != null) {
                this.cache.reopen();
            }
            if (this.dbLogWriter != null) {
                this.openLog();
            }
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    public boolean defrag(Session session) {
        this.database.logger.logInfoEvent("defrag start");
        try {
            if (this.filesReadOnly) {
                return true;
            }
            this.database.logger.setFilesTimestamp(this.database.txManager.getSystemChangeNumber());
            this.database.logger.logInfoEvent("checkpointClose start");
            this.synchLog();
            this.database.lobManager.synch();
            this.database.logger.logInfoEvent("checkpointClose synched");
            this.deleteOldFiles();
            DataFileDefrag dataFileDefrag = this.cache.defrag(session);
            this.database.schemaManager.setTempIndexRoots(dataFileDefrag.getIndexRoots());
            try {
                this.writeScript(false);
                this.cache.close();
                this.cache.clear();
                this.database.logger.logInfoEvent("checkpointClose script done");
            }
            finally {
                this.database.schemaManager.setTempIndexRoots(null);
            }
            this.database.getProperties().setProperty("hsqldb.script_format", this.database.logger.propScriptFormat);
            this.database.getProperties().setDBModified(3);
            this.closeLog();
            this.deleteLogFile();
            this.deleteBackupFile();
            this.renameNewDataFile();
            this.renameNewScriptFile();
            this.database.getProperties().setDBModified(0);
            this.cache.open(false);
            if (this.dbLogWriter != null) {
                this.openLog();
            }
            this.database.persistentStoreCollection.setNewTableSpaces();
            this.database.schemaManager.setIndexRoots(dataFileDefrag.getIndexRoots());
            this.database.sessionManager.resetLoggedSchemas();
        }
        catch (HsqlException hsqlException) {
            throw hsqlException;
        }
        catch (Throwable throwable) {
            this.database.logger.logSevereEvent("defrag failure", throwable);
            throw Error.error(466, throwable);
        }
        this.database.logger.logInfoEvent("defrag end");
        return true;
    }

    boolean forceDefrag() {
        long l;
        if (this.database.logger.propDataFileDefragLimit == 0) {
            return false;
        }
        long l2 = (long)this.database.logger.propDataFileSpace * 1024L * 1024L * 2L;
        long l3 = this.cache.getFileFreePos();
        long l4 = (long)this.database.logger.propDataFileDefragLimit * l3 / 100L;
        if (l2 > l4) {
            l4 = l2;
        }
        return (l = this.cache.getLostBlockSize()) > l4;
    }

    boolean hasCache() {
        return this.cache != null;
    }

    DataFileCache getCache() {
        if (this.cache == null) {
            this.cache = new DataFileCache(this.database, this.baseFileName);
            this.cache.open(this.filesReadOnly);
        }
        return this.cache;
    }

    void setLogSize(int n) {
        this.maxLogSize = (long)n * 1024L * 1024L;
    }

    int getWriteDelay() {
        return this.writeDelay;
    }

    void setWriteDelay(int n) {
        this.writeDelay = n;
        if (this.dbLogWriter != null && this.dbLogWriter.getWriteDelay() != n) {
            this.dbLogWriter.forceSync();
            this.dbLogWriter.stop();
            this.dbLogWriter.setWriteDelay(n);
            this.dbLogWriter.start();
        }
    }

    void writeOtherStatement(Session session, String string) {
        this.dbLogWriter.writeOtherStatement(session, string);
        if (this.maxLogSize > 0L && this.dbLogWriter.size() > this.maxLogSize) {
            this.database.logger.setCheckpointRequired();
        }
        this.setModified();
    }

    void writeInsertStatement(Session session, Row row, Table table) {
        this.dbLogWriter.writeInsertStatement(session, row, table);
    }

    void writeDeleteStatement(Session session, Table table, Object[] objectArray) {
        this.dbLogWriter.writeDeleteStatement(session, table, objectArray);
    }

    void writeSequenceStatement(Session session, NumberSequence numberSequence) {
        this.dbLogWriter.writeSequenceStatement(session, numberSequence);
        this.setModified();
    }

    void writeCommitStatement(Session session) {
        this.dbLogWriter.writeCommitStatement(session);
        if (this.maxLogSize > 0L && this.dbLogWriter.size() > this.maxLogSize) {
            this.database.logger.setCheckpointRequired();
        }
        this.setModified();
    }

    private void setModified() {
        if (!this.isModified) {
            this.database.databaseProperties.setDBModified(1);
            this.isModified = true;
        }
    }

    void synchLog() {
        if (this.dbLogWriter != null) {
            this.dbLogWriter.forceSync();
        }
    }

    void openLog() {
        if (this.filesReadOnly) {
            return;
        }
        this.setDataChangeLog();
        this.isModified = false;
    }

    void closeLog() {
        if (this.dbLogWriter != null) {
            this.database.logger.logDetailEvent("log close size: " + this.dbLogWriter.size());
            this.dbLogWriter.close();
        }
    }

    void setDataChangeLog() {
        Crypto crypto = this.database.logger.getCrypto();
        try {
            this.dbLogWriter = crypto == null ? new ScriptWriterText(this.database, this.logFileName, false, false, false) : new ScriptWriterEncode(this.database, this.logFileName, crypto);
            this.dbLogWriter.setWriteDelay(this.writeDelay);
            this.dbLogWriter.start();
        }
        catch (Throwable throwable) {
            throw Error.error(throwable, 452, this.getLogFileName());
        }
    }

    void writeScript(boolean bl) {
        ScriptWriterText scriptWriterText;
        this.deleteNewScriptFile();
        Crypto crypto = this.database.logger.getCrypto();
        if (crypto == null) {
            boolean bl2 = this.database.logger.propScriptFormat == 3;
            scriptWriterText = new ScriptWriterText(this.database, this.scriptFileName + ".new", bl, bl2);
        } else {
            scriptWriterText = new ScriptWriterEncode(this.database, this.scriptFileName + ".new", bl, crypto);
        }
        scriptWriterText.writeAll();
        scriptWriterText.close();
        scriptWriterText = null;
    }

    private void processScript() {
        ScriptReaderBase scriptReaderBase = null;
        try {
            Crypto crypto = this.database.logger.getCrypto();
            if (crypto == null) {
                boolean bl = this.database.logger.propScriptFormat == 3;
                scriptReaderBase = new ScriptReaderText(this.database, this.scriptFileName, bl);
            } else {
                scriptReaderBase = new ScriptReaderDecode(this.database, this.scriptFileName, crypto, false);
            }
            Session session = this.database.sessionManager.getSysSessionForScript(this.database);
            scriptReaderBase.readAll(session);
            scriptReaderBase.close();
        }
        catch (Throwable throwable) {
            if (scriptReaderBase != null) {
                scriptReaderBase.close();
                if (this.cache != null) {
                    this.cache.release();
                }
                this.database.logger.textTableManager.closeAllTextCaches(false);
            }
            this.database.logger.logWarningEvent("Script processing failure", throwable);
            if (throwable instanceof HsqlException) {
                throw (HsqlException)throwable;
            }
            if (throwable instanceof IOException) {
                throw Error.error(452, throwable);
            }
            if (throwable instanceof OutOfMemoryError) {
                throw Error.error(460, throwable);
            }
            throw Error.error(458, throwable);
        }
    }

    private void processLog() {
        if (this.fa.isStreamElement(this.logFileName)) {
            boolean bl = this.database.getURLProperties().isPropertyTrue("hsqldb.full_log_replay");
            ScriptRunner.runScript(this.database, this.logFileName, bl);
        }
    }

    String getLogFileName() {
        return this.logFileName;
    }

    static void deleteFile(FileAccess fileAccess, String string) {
        fileAccess.removeElement(string);
        if (fileAccess.isStreamElement(string)) {
            fileAccess.removeElement(string);
            if (fileAccess.isStreamElement(string)) {
                String string2 = FileUtil.newDiscardFileName(string);
                fileAccess.renameElement(string, string2);
            }
        }
    }

    boolean renameNewFile(FileAccess fileAccess, String string) {
        if (fileAccess.isStreamElement(string + ".new")) {
            Log.deleteFile(fileAccess, string);
            return fileAccess.renameElementOrCopy(string + ".new", string, this.database.logger);
        }
        return true;
    }

    void deleteNewAndOldFiles() {
        this.deleteOldFiles();
        Log.deleteFile(this.fa, this.dataFileName + ".new");
        Log.deleteFile(this.fa, this.scriptFileName + ".new");
    }

    void deleteDataFile() {
        Log.deleteFile(this.fa, this.dataFileName);
    }

    void deleteBackupFile() {
        Log.deleteFile(this.fa, this.backupFileName);
    }

    boolean renameNewDataFile() {
        return this.renameNewFile(this.fa, this.dataFileName);
    }

    boolean renameNewScriptFile() {
        return this.renameNewFile(this.fa, this.scriptFileName);
    }

    void deleteNewScriptFile() {
        Log.deleteFile(this.fa, this.scriptFileName + ".new");
    }

    void deleteLogFile() {
        Log.deleteFile(this.fa, this.logFileName);
    }

    void deleteOldFiles() {
        try {
            File file = new File(this.database.getCanonicalPath());
            File[] fileArray = file.getParentFile().listFiles();
            if (fileArray == null) {
                return;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].getName().startsWith(file.getName()) || !fileArray[i].getName().endsWith(".old")) continue;
                fileArray[i].delete();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void deleteOldTempFiles() {
        try {
            if (this.database.logger.tempDirectoryPath == null) {
                return;
            }
            File file = new File(this.database.logger.tempDirectoryPath);
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                fileArray[i].delete();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void deleteTempFileDirectory() {
        try {
            if (this.database.logger.tempDirectoryPath == null) {
                return;
            }
            File file = new File(this.database.logger.tempDirectoryPath);
            file.delete();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

