/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.security.AuthenticationException;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class HttpAuthenticationFaultHandler
extends AbstractPhaseInterceptor<Message> {
    String authenticationType = "Basic";
    String realm = "CXF service";

    public HttpAuthenticationFaultHandler() {
        super("unmarshal");
    }

    public void handleMessage(Message message) throws Fault {
    }

    public void handleFault(Message message) {
        Exception ex = (Exception)message.getContent(Exception.class);
        if (ex instanceof AuthenticationException) {
            HttpServletResponse resp = (HttpServletResponse)message.getExchange().getInMessage().get((Object)"HTTP.RESPONSE");
            resp.setStatus(401);
            resp.setHeader("WWW-Authenticate", this.authenticationType + " realm=\"" + this.realm + "\"");
            resp.setContentType("text/plain");
            try {
                resp.getOutputStream().write(ex.getMessage().getBytes());
                resp.getOutputStream().flush();
                message.getInterceptorChain().setFaultObserver(null);
                message.getInterceptorChain().abort();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }
}

