/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.schema.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import org.eclipse.persistence.internal.oxm.schema.model.Annotation;
import org.eclipse.persistence.internal.oxm.schema.model.Attribute;
import org.eclipse.persistence.internal.oxm.schema.model.AttributeGroup;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Element;
import org.eclipse.persistence.internal.oxm.schema.model.Group;
import org.eclipse.persistence.internal.oxm.schema.model.Import;
import org.eclipse.persistence.internal.oxm.schema.model.Include;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleType;
import org.eclipse.persistence.oxm.NamespaceResolver;

public class Schema {
    private String name;
    private List<Import> imports;
    private List<Include> includes;
    private String targetNamespace;
    private String defaultNamespace;
    private boolean elementFormDefault;
    private boolean attributeFormDefault;
    private Map<String, SimpleType> topLevelSimpleTypes;
    private Map<String, ComplexType> topLevelComplexTypes;
    private Map<String, Element> topLevelElements;
    private Map<String, Attribute> topLevelAttributes;
    private NamespaceResolver namespaceResolver = new NamespaceResolver();
    private Map<QName, String> attributesMap;
    private Map<String, AttributeGroup> attributeGroups;
    private Map<String, Group> groups;
    private Annotation annotation;
    private Result result;

    public Schema() {
        this.imports = new ArrayList<Import>();
        this.includes = new ArrayList<Include>();
        this.topLevelSimpleTypes = new LinkedHashMap<String, SimpleType>();
        this.topLevelComplexTypes = new LinkedHashMap<String, ComplexType>();
        this.topLevelElements = new LinkedHashMap<String, Element>();
        this.topLevelAttributes = new LinkedHashMap<String, Attribute>();
        this.attributesMap = new LinkedHashMap<QName, String>();
        this.attributeGroups = new LinkedHashMap<String, AttributeGroup>();
        this.groups = new LinkedHashMap<String, Group>();
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void setTopLevelSimpleTypes(Map<String, SimpleType> topLevelSimpleTypes) {
        this.topLevelSimpleTypes = topLevelSimpleTypes;
    }

    public Map<String, SimpleType> getTopLevelSimpleTypes() {
        return this.topLevelSimpleTypes;
    }

    public void addTopLevelSimpleTypes(SimpleType simpleType) {
        this.topLevelSimpleTypes.put(simpleType.getName(), simpleType);
    }

    public void setTopLevelComplexTypes(Map<String, ComplexType> topLevelComplexTypes) {
        this.topLevelComplexTypes = topLevelComplexTypes;
    }

    public Map<String, ComplexType> getTopLevelComplexTypes() {
        return this.topLevelComplexTypes;
    }

    public void addTopLevelComplexTypes(ComplexType complexType) {
        this.topLevelComplexTypes.put(complexType.getName(), complexType);
    }

    public void setTopLevelElements(Map<String, Element> topLevelElements) {
        this.topLevelElements = topLevelElements;
    }

    public Map<String, Element> getTopLevelElements() {
        return this.topLevelElements;
    }

    public void addTopLevelElement(Element element) {
        this.topLevelElements.put(element.getName(), element);
    }

    public void setElementFormDefault(boolean elementFormDefault) {
        this.elementFormDefault = elementFormDefault;
    }

    public boolean isElementFormDefault() {
        return this.elementFormDefault;
    }

    public void setAttributeFormDefault(boolean attributeFormDefault) {
        this.attributeFormDefault = attributeFormDefault;
    }

    public boolean isAttributeFormDefault() {
        return this.attributeFormDefault;
    }

    public void setTopLevelAttributes(Map<String, Attribute> topLevelAttributes) {
        this.topLevelAttributes = topLevelAttributes;
    }

    public Map<String, Attribute> getTopLevelAttributes() {
        return this.topLevelAttributes;
    }

    public void setNamespaceResolver(NamespaceResolver namespaceResolver) {
        this.namespaceResolver = namespaceResolver;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public void setImports(List<Import> imports) {
        this.imports = imports;
    }

    public List<Import> getImports() {
        return this.imports;
    }

    public void setIncludes(List<Include> includes) {
        this.includes = includes;
    }

    public List<Include> getIncludes() {
        return this.includes;
    }

    public void setAttributesMap(Map<QName, String> attributesMap) {
        this.attributesMap = attributesMap;
        for (Map.Entry<QName, String> nextEntry : attributesMap.entrySet()) {
            QName key = nextEntry.getKey();
            if (!key.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) continue;
            String value = nextEntry.getValue();
            String prefix = key.getLocalPart();
            int index = prefix.indexOf(58);
            if (index > -1) {
                prefix = prefix.substring(index + 1, prefix.length());
            }
            this.namespaceResolver.put(prefix, value);
        }
    }

    public Map<QName, String> getAttributesMap() {
        return this.attributesMap;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setAttributeGroups(Map<String, AttributeGroup> attributeGroups) {
        this.attributeGroups = attributeGroups;
    }

    public Map<String, AttributeGroup> getAttributeGroups() {
        return this.attributeGroups;
    }

    public AttributeGroup getAttributeGroup(String uri, String localName) {
        AttributeGroup globalAttributeGroup;
        if (uri.equals(this.targetNamespace) && (globalAttributeGroup = this.getAttributeGroups().get(localName)) != null) {
            return globalAttributeGroup;
        }
        return this.getAttributeGroupFromReferencedSchemas(uri, localName);
    }

    protected AttributeGroup getAttributeGroupFromReferencedSchemas(String uri, String localName) {
        AttributeGroup globalAttributeGroup = null;
        Iterator<Include> iter = this.getIncludes().iterator();
        while (iter.hasNext() && globalAttributeGroup == null) {
            Schema includedSchema = iter.next().getSchema();
            globalAttributeGroup = includedSchema.getAttributeGroup(uri, localName);
        }
        if (globalAttributeGroup == null) {
            Iterator<Import> iter2 = this.getImports().iterator();
            while (iter2.hasNext() && globalAttributeGroup == null) {
                Schema importedSchema = iter2.next().getSchema();
                globalAttributeGroup = importedSchema.getAttributeGroup(uri, localName);
            }
        }
        return globalAttributeGroup;
    }

    public void setGroups(Map<String, Group> groups) {
        this.groups = groups;
    }

    public Map<String, Group> getGroups() {
        return this.groups;
    }

    public Group getGroup(String uri, String localName) {
        Group globalGroup;
        if (uri.equals(this.targetNamespace) && (globalGroup = this.getGroups().get(localName)) != null) {
            return globalGroup;
        }
        return this.getGroupFromReferencedSchemas(uri, localName);
    }

    protected Group getGroupFromReferencedSchemas(String uri, String localName) {
        Group globalGroup = null;
        Iterator<Include> iter = this.getIncludes().iterator();
        while (iter.hasNext() && globalGroup == null) {
            Schema includedSchema = iter.next().getSchema();
            globalGroup = includedSchema.getGroup(uri, localName);
        }
        if (globalGroup == null) {
            Iterator<Import> iter2 = this.getImports().iterator();
            while (iter2.hasNext() && globalGroup == null) {
                Schema importedSchema = iter2.next().getSchema();
                globalGroup = importedSchema.getGroup(uri, localName);
            }
        }
        return globalGroup;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public boolean hasResult() {
        return this.getResult() != null;
    }

    public boolean hasSystemId() {
        return this.getSystemId() != null;
    }

    public String getSystemId() {
        if (this.hasResult()) {
            return this.getResult().getSystemId();
        }
        return null;
    }
}

