/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.dataobject;

import io.smallrye.openapi.api.constants.JacksonConstants;
import io.smallrye.openapi.api.constants.KotlinConstants;
import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectLogging;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.JandexUtil;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public class BeanValidationScanner {
    static final Set<DotName> CONSTRAINTS = new HashSet<DotName>();
    private static final String VALUE = "value";
    private static final String INCLUSIVE = "inclusive";
    static final BigDecimal NEGATIVE_ONE = BigDecimal.ZERO.subtract(BigDecimal.ONE);
    static final DotName BV_JAVAX = DotName.createComponentized(null, (String)"javax");
    static final DotName BV_JAKARTA = DotName.createComponentized(null, (String)"jakarta");
    static final DotName BV_JAVAX_BASE = DotName.createComponentized((DotName)BV_JAVAX, (String)"validation");
    static final DotName BV_JAKARTA_BASE = DotName.createComponentized((DotName)BV_JAKARTA, (String)"validation");
    static final DotName BV_JAVAX_GROUPS = DotName.createComponentized((DotName)BV_JAVAX_BASE, (String)"groups");
    static final DotName BV_JAKARTA_GROUPS = DotName.createComponentized((DotName)BV_JAKARTA_BASE, (String)"groups");
    static final DotName BV_JAVAX_DEFAULT_GROUP = DotName.createComponentized((DotName)BV_JAVAX_GROUPS, (String)"Default");
    static final DotName BV_JAKARTA_DEFAULT_GROUP = DotName.createComponentized((DotName)BV_JAKARTA_GROUPS, (String)"Default");
    static final DotName BV_JAVAX_CONTRAINTS = DotName.createComponentized((DotName)BV_JAVAX_BASE, (String)"constraints");
    static final DotName BV_JAKARTA_CONTRAINTS = DotName.createComponentized((DotName)BV_JAKARTA_BASE, (String)"constraints");
    static final List<DotName> BV_DECIMAL_MAX = Arrays.asList(BeanValidationScanner.createConstraintName(BV_JAVAX_CONTRAINTS, "DecimalMax"), BeanValidationScanner.createConstraintName(BV_JAKARTA_CONTRAINTS, "DecimalMax"));
    static final List<DotName> BV_DECIMAL_MIN = Arrays.asList(BeanValidationScanner.createConstraintName(BV_JAVAX_CONTRAINTS, "DecimalMin"), BeanValidationScanner.createConstraintName(BV_JAKARTA_CONTRAINTS, "DecimalMin"));
    static final List<DotName> BV_DIGITS = Arrays.asList(BeanValidationScanner.createConstraintName(BV_JAVAX_CONTRAINTS, "Digits"), BeanValidationScanner.createConstraintName(BV_JAKARTA_CONTRAINTS, "Digits"));
    static final List<DotName> BV_MAX = Arrays.asList(BeanValidationScanner.createConstraintName(BV_JAVAX_CONTRAINTS, "Max"), BeanValidationScanner.createConstraintName(BV_JAKARTA_CONTRAINTS, "Max"));
    static final List<DotName> BV_MIN = Arrays.asList(BeanValidationScanner.createConstraintName(BV_JAVAX_CONTRAINTS, "Min"), BeanValidationScanner.createConstraintName(BV_JAKARTA_CONTRAINTS, "Min"));
    static final List<DotName> BV_NEGATIVE = Arrays.asList(BeanValidationScanner.createConstraintName(BV_JAVAX_CONTRAINTS, "Negative"), BeanValidationScanner.createConstraintName(BV_JAKARTA_CONTRAINTS, "Negative"));
    static final List<DotName> BV_NEGATIVE_OR_ZERO = Arrays.asList(BeanValidationScanner.createConstraintName(BV_JAVAX_CONTRAINTS, "NegativeOrZero"), BeanValidationScanner.createConstraintName(BV_JAKARTA_CONTRAINTS, "NegativeOrZero"));
    static final List<DotName> BV_NOT_BLANK = Arrays.asList(BeanValidationScanner.createConstraintName(BV_JAVAX_CONTRAINTS, "NotBlank"), BeanValidationScanner.createConstraintName(BV_JAKARTA_CONTRAINTS, "NotBlank"));
    static final List<DotName> BV_NOT_EMPTY = Arrays.asList(BeanValidationScanner.createConstraintName(BV_JAVAX_CONTRAINTS, "NotEmpty"), BeanValidationScanner.createConstraintName(BV_JAKARTA_CONTRAINTS, "NotEmpty"));
    static final List<DotName> BV_NOT_NULL = Arrays.asList(BeanValidationScanner.createConstraintName(BV_JAVAX_CONTRAINTS, "NotNull"), BeanValidationScanner.createConstraintName(BV_JAKARTA_CONTRAINTS, "NotNull"));
    static final List<DotName> BV_PATTERN = Arrays.asList(BeanValidationScanner.createConstraintName(BV_JAVAX_CONTRAINTS, "Pattern"), BeanValidationScanner.createConstraintName(BV_JAKARTA_CONTRAINTS, "Pattern"));
    static final List<DotName> BV_POSITIVE = Arrays.asList(BeanValidationScanner.createConstraintName(BV_JAVAX_CONTRAINTS, "Positive"), BeanValidationScanner.createConstraintName(BV_JAKARTA_CONTRAINTS, "Positive"));
    static final List<DotName> BV_POSITIVE_OR_ZERO = Arrays.asList(BeanValidationScanner.createConstraintName(BV_JAVAX_CONTRAINTS, "PositiveOrZero"), BeanValidationScanner.createConstraintName(BV_JAKARTA_CONTRAINTS, "PositiveOrZero"));
    static final List<DotName> BV_SIZE = Arrays.asList(BeanValidationScanner.createConstraintName(BV_JAVAX_CONTRAINTS, "Size"), BeanValidationScanner.createConstraintName(BV_JAKARTA_CONTRAINTS, "Size"));
    static final DotName JACKSON_JSONPROPERTY = BeanValidationScanner.createConstraintName(JacksonConstants.JSON_PROPERTY);
    static final DotName KOTLIN_NULLABLE = BeanValidationScanner.createConstraintName(KotlinConstants.JETBRAINS_NULLABLE);
    static final DotName KOTLIN_NOT_NULL = BeanValidationScanner.createConstraintName(KotlinConstants.JETBRAINS_NOT_NULL);
    private final AnnotationScannerContext context;

    static DotName createConstraintName(DotName packageName, String className) {
        return BeanValidationScanner.createConstraintName(DotName.createComponentized((DotName)packageName, (String)className));
    }

    static DotName createConstraintName(DotName constraintName) {
        CONSTRAINTS.add(constraintName);
        return constraintName;
    }

    public BeanValidationScanner(AnnotationScannerContext context) {
        this.context = context;
    }

    public boolean hasConstraints(AnnotationTarget target) {
        return this.context.annotations().hasAnnotation(target, CONSTRAINTS);
    }

    public void applyConstraints(AnnotationTarget target, Schema schema, String propertyKey, RequirementHandler handler) {
        Schema.SchemaType schemaType = schema.getType();
        if (schemaType == null || schema.getRef() != null) {
            return;
        }
        switch (schemaType) {
            case ARRAY: {
                this.applyArrayConstraints(target, schema, propertyKey, handler);
                break;
            }
            case BOOLEAN: {
                this.applyBooleanConstraints(target, schema, propertyKey, handler);
                break;
            }
            case INTEGER: {
                this.applyNumberConstraints(target, schema, propertyKey, handler);
                break;
            }
            case NUMBER: {
                this.applyNumberConstraints(target, schema, propertyKey, handler);
                break;
            }
            case OBJECT: {
                this.applyObjectConstraints(target, schema, propertyKey, handler);
                break;
            }
            case STRING: {
                this.applyStringConstraints(target, schema, propertyKey, handler);
            }
        }
    }

    private void applyStringConstraints(AnnotationTarget target, Schema schema, String propertyKey, RequirementHandler handler) {
        this.decimalMax(target, schema);
        this.decimalMin(target, schema);
        this.pattern(target, schema);
        this.digits(target, schema);
        this.notBlank(target, schema, propertyKey, handler);
        this.notNull(target, propertyKey, handler);
        this.notNullKotlin(target, propertyKey, handler);
        this.nullableKotlin(target, schema);
        this.requiredJackson(target, propertyKey, handler);
        this.sizeString(target, schema);
        this.notEmptyString(target, schema, propertyKey, handler);
    }

    private void applyObjectConstraints(AnnotationTarget target, Schema schema, String propertyKey, RequirementHandler handler) {
        this.notNull(target, propertyKey, handler);
        this.notNullKotlin(target, propertyKey, handler);
        this.nullableKotlin(target, schema);
        this.requiredJackson(target, propertyKey, handler);
        this.sizeObject(target, schema);
        this.notEmptyObject(target, schema, propertyKey, handler);
    }

    private void applyArrayConstraints(AnnotationTarget target, Schema schema, String propertyKey, RequirementHandler handler) {
        this.notNull(target, propertyKey, handler);
        this.notNullKotlin(target, propertyKey, handler);
        this.nullableKotlin(target, schema);
        this.requiredJackson(target, propertyKey, handler);
        this.sizeArray(target, schema);
        this.notEmptyArray(target, schema, propertyKey, handler);
    }

    private void applyNumberConstraints(AnnotationTarget target, Schema schema, String propertyKey, RequirementHandler handler) {
        this.decimalMax(target, schema);
        this.decimalMin(target, schema);
        this.digits(target, schema);
        this.max(target, schema);
        this.min(target, schema);
        this.negative(target, schema);
        this.negativeOrZero(target, schema);
        this.notNull(target, propertyKey, handler);
        this.notNullKotlin(target, propertyKey, handler);
        this.nullableKotlin(target, schema);
        this.requiredJackson(target, propertyKey, handler);
        this.positive(target, schema);
        this.positiveOrZero(target, schema);
    }

    private void applyBooleanConstraints(AnnotationTarget target, Schema schema, String propertyKey, RequirementHandler handler) {
        this.notNull(target, propertyKey, handler);
        this.notNullKotlin(target, propertyKey, handler);
        this.nullableKotlin(target, schema);
        this.requiredJackson(target, propertyKey, handler);
    }

    void decimalMax(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_DECIMAL_MAX);
        if (constraint != null && schema.getMaximum() == null) {
            String decimalValue = (String)this.context.annotations().value(constraint, VALUE);
            try {
                BigDecimal decimal = new BigDecimal(decimalValue);
                schema.setMaximum(decimal);
                Boolean inclusive = (Boolean)this.context.annotations().value(constraint, INCLUSIVE);
                if (schema.getExclusiveMaximum() == null && Boolean.FALSE.equals(inclusive)) {
                    schema.setExclusiveMaximum(Boolean.TRUE);
                }
            }
            catch (NumberFormatException e) {
                DataObjectLogging.logger.invalidAnnotationFormat(decimalValue);
            }
        }
    }

    void decimalMin(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_DECIMAL_MIN);
        if (constraint != null && schema.getMinimum() == null) {
            String decimalValue = (String)this.context.annotations().value(constraint, VALUE);
            try {
                BigDecimal decimal = new BigDecimal(decimalValue);
                schema.setMinimum(decimal);
                Boolean inclusive = (Boolean)this.context.annotations().value(constraint, INCLUSIVE);
                if (schema.getExclusiveMinimum() == null && Boolean.FALSE.equals(inclusive)) {
                    schema.setExclusiveMinimum(Boolean.TRUE);
                }
            }
            catch (NumberFormatException e) {
                DataObjectLogging.logger.invalidAnnotationFormat(decimalValue);
            }
        }
    }

    void digits(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_DIGITS);
        if (constraint != null && schema.getPattern() == null) {
            int integerPart = (Integer)this.context.annotations().value(constraint, "integer");
            int fractionPart = (Integer)this.context.annotations().value(constraint, "fraction");
            StringBuilder pattern = new StringBuilder(50);
            pattern.append('^');
            if (integerPart > 0) {
                pattern.append("\\d");
                if (integerPart > 1) {
                    pattern.append("{1,").append(integerPart).append('}');
                }
            }
            if (fractionPart > 0) {
                pattern.append("([.]\\d");
                if (fractionPart > 1) {
                    pattern.append("{1,").append(fractionPart).append("}");
                }
                pattern.append(")?");
            }
            pattern.append('$');
            schema.setPattern(pattern.toString());
        }
    }

    void max(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_MAX);
        if (constraint != null && schema.getMaximum() == null) {
            AnnotationValue value = constraint.value(VALUE);
            schema.setMaximum(new BigDecimal(value.asLong()));
        }
    }

    void min(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_MIN);
        if (constraint != null && schema.getMinimum() == null) {
            AnnotationValue value = constraint.value(VALUE);
            schema.setMinimum(new BigDecimal(value.asLong()));
        }
    }

    void negative(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_NEGATIVE);
        if (constraint != null && schema.getMaximum() == null) {
            Boolean exclusive = schema.getExclusiveMaximum();
            if (exclusive == null || exclusive.booleanValue()) {
                schema.setMaximum(BigDecimal.ZERO);
                schema.setExclusiveMaximum(Boolean.TRUE);
            } else {
                schema.setMaximum(NEGATIVE_ONE);
            }
        }
    }

    void negativeOrZero(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_NEGATIVE_OR_ZERO);
        if (constraint != null && schema.getMaximum() == null) {
            Boolean exclusive = schema.getExclusiveMaximum();
            if (exclusive != null && exclusive.booleanValue()) {
                schema.setMaximum(BigDecimal.ONE);
            } else {
                schema.setMaximum(BigDecimal.ZERO);
            }
        }
    }

    void notBlank(AnnotationTarget target, Schema schema, String propertyKey, RequirementHandler handler) {
        AnnotationInstance constraint = this.getConstraint(target, BV_NOT_BLANK);
        if (constraint != null) {
            if (schema.getPattern() == null) {
                schema.setPattern("\\S");
            }
            handler.setRequired(target, propertyKey);
        }
    }

    void notEmptyArray(AnnotationTarget target, Schema schema, String propertyKey, RequirementHandler handler) {
        AnnotationInstance constraint = this.getConstraint(target, BV_NOT_EMPTY);
        if (constraint != null) {
            if (schema.getMinItems() == null) {
                schema.setMinItems(Integer.valueOf(1));
            }
            handler.setRequired(target, propertyKey);
        }
    }

    void notEmptyObject(AnnotationTarget target, Schema schema, String propertyKey, RequirementHandler handler) {
        if (!this.allowsAdditionalProperties(schema)) {
            return;
        }
        AnnotationInstance constraint = this.getConstraint(target, BV_NOT_EMPTY);
        if (constraint != null) {
            if (schema.getMinProperties() == null) {
                schema.setMinProperties(Integer.valueOf(1));
            }
            handler.setRequired(target, propertyKey);
        }
    }

    void notEmptyString(AnnotationTarget target, Schema schema, String propertyKey, RequirementHandler handler) {
        AnnotationInstance constraint = this.getConstraint(target, BV_NOT_EMPTY);
        if (constraint != null) {
            if (schema.getMinLength() == null) {
                schema.setMinLength(Integer.valueOf(1));
            }
            handler.setRequired(target, propertyKey);
        }
    }

    void notNull(AnnotationTarget target, String propertyKey, RequirementHandler handler) {
        AnnotationInstance constraint = this.getConstraint(target, BV_NOT_NULL);
        if (constraint != null) {
            handler.setRequired(target, propertyKey);
        }
    }

    void notNullKotlin(AnnotationTarget target, String propertyKey, RequirementHandler handler) {
        if (this.context.annotations().hasAnnotation(target, KOTLIN_NOT_NULL)) {
            handler.setRequired(target, propertyKey);
        }
    }

    void nullableKotlin(AnnotationTarget target, Schema schema) {
        if (this.context.annotations().hasAnnotation(target, KOTLIN_NULLABLE) && schema.getNullable() == null) {
            schema.setNullable(Boolean.TRUE);
        }
    }

    void pattern(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_PATTERN);
        if (constraint != null && schema.getPattern() == null) {
            schema.setPattern((String)this.context.annotations().value(constraint, "regexp"));
        }
    }

    void positive(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_POSITIVE);
        if (constraint != null && schema.getMinimum() == null) {
            Boolean exclusive = schema.getExclusiveMinimum();
            if (exclusive == null || exclusive.booleanValue()) {
                schema.setMinimum(BigDecimal.ZERO);
                schema.setExclusiveMinimum(Boolean.TRUE);
            } else {
                schema.setMinimum(BigDecimal.ONE);
            }
        }
    }

    void positiveOrZero(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_POSITIVE_OR_ZERO);
        if (constraint != null && schema.getMinimum() == null) {
            Boolean exclusive = schema.getExclusiveMinimum();
            if (exclusive != null && exclusive.booleanValue()) {
                schema.setMinimum(NEGATIVE_ONE);
            } else {
                schema.setMinimum(BigDecimal.ZERO);
            }
        }
    }

    void requiredJackson(AnnotationTarget target, String propertyKey, RequirementHandler handler) {
        Boolean required = (Boolean)this.context.annotations().getAnnotationValue(target, JACKSON_JSONPROPERTY, "required");
        if (Boolean.TRUE.equals(required)) {
            handler.setRequired(target, propertyKey);
        }
    }

    void sizeArray(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_SIZE);
        if (constraint != null) {
            Integer min = (Integer)this.context.annotations().value(constraint, "min");
            Integer max = (Integer)this.context.annotations().value(constraint, "max");
            if (min != null && schema.getMinItems() == null) {
                schema.setMinItems(min);
            }
            if (max != null && schema.getMaxItems() == null) {
                schema.setMaxItems(max);
            }
        }
    }

    void sizeObject(AnnotationTarget target, Schema schema) {
        if (!this.allowsAdditionalProperties(schema)) {
            return;
        }
        AnnotationInstance constraint = this.getConstraint(target, BV_SIZE);
        if (constraint != null) {
            Integer min = (Integer)this.context.annotations().value(constraint, "min");
            Integer max = (Integer)this.context.annotations().value(constraint, "max");
            if (min != null && schema.getMinProperties() == null) {
                schema.setMinProperties(min);
            }
            if (max != null && schema.getMaxProperties() == null) {
                schema.setMaxProperties(max);
            }
        }
    }

    void sizeString(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_SIZE);
        if (constraint != null) {
            Integer min = (Integer)this.context.annotations().value(constraint, "min");
            Integer max = (Integer)this.context.annotations().value(constraint, "max");
            if (min != null && schema.getMinLength() == null) {
                schema.setMinLength(min);
            }
            if (max != null && schema.getMaxLength() == null) {
                schema.setMaxLength(max);
            }
        }
    }

    boolean allowsAdditionalProperties(Schema schema) {
        Boolean additionalProperties = schema.getAdditionalPropertiesBoolean();
        if (additionalProperties != null) {
            return additionalProperties;
        }
        return schema.getAdditionalPropertiesSchema() != null;
    }

    AnnotationInstance getConstraint(AnnotationTarget target, List<DotName> annotationName) {
        AnnotationInstance constraint = this.context.annotations().getAnnotation(target, annotationName);
        if (constraint != null && JandexUtil.equals(constraint.target(), target)) {
            AnnotationValue groupValue = constraint.value("groups");
            if (groupValue == null) {
                return constraint;
            }
            Type[] groups = groupValue.asClassArray();
            if (groups.length == 0) {
                return constraint;
            }
            for (Type group : groups) {
                if (!group.name().equals((Object)BV_JAVAX_DEFAULT_GROUP) && !group.name().equals((Object)BV_JAKARTA_DEFAULT_GROUP)) continue;
                return constraint;
            }
        }
        return null;
    }

    public static interface RequirementHandler {
        public void setRequired(AnnotationTarget var1, String var2);
    }
}

