/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.openejb.client.ClusterableRequest;
import org.apache.openejb.client.ProtocolMetaData;
import org.apache.openejb.client.RequestMethodCode;
import org.apache.openejb.client.RequestType;

public class JNDIRequest
implements ClusterableRequest {
    private static final long serialVersionUID = -568798775203142850L;
    private transient RequestMethodCode requestMethod;
    private transient String requestString;
    private transient String moduleId;
    private transient int serverHash;
    private transient ProtocolMetaData metaData;

    public JNDIRequest() {
    }

    public JNDIRequest(RequestMethodCode requestMethod, String requestString) {
        this.requestMethod = requestMethod;
        this.requestString = requestString;
    }

    @Override
    public void setMetaData(ProtocolMetaData metaData) {
        this.metaData = metaData;
    }

    @Override
    public RequestType getRequestType() {
        return RequestType.JNDI_REQUEST;
    }

    public RequestMethodCode getRequestMethod() {
        return this.requestMethod;
    }

    public String getRequestString() {
        return this.requestString;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public void setRequestMethod(RequestMethodCode requestMethod) {
        this.requestMethod = requestMethod;
    }

    public void setRequestString(String requestString) {
        this.requestString = requestString;
    }

    @Override
    public void setServerHash(int serverHash) {
        this.serverHash = serverHash;
    }

    @Override
    public int getServerHash() {
        return this.serverHash;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        byte code = in.readByte();
        try {
            this.requestMethod = RequestMethodCode.valueOf(code);
        }
        catch (IllegalArgumentException iae) {
            throw new IOException("Invalid request code " + code);
        }
        this.requestString = in.readUTF();
        this.moduleId = (String)in.readObject();
        this.serverHash = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeByte((byte)this.requestMethod.getCode());
        out.writeUTF(this.requestString);
        out.writeObject(this.moduleId);
        out.writeInt(this.serverHash);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append((Object)this.requestMethod);
        sb.append(this.moduleId != null ? this.moduleId : "").append(":");
        sb.append(this.requestString);
        return sb.toString();
    }
}

