/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.action;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractConditionalProfileAction
extends AbstractProfileAction {
    @Nonnull
    private Predicate<ProfileRequestContext> activationCondition = PredicateSupport.alwaysTrue();

    @Nonnull
    public Predicate<ProfileRequestContext> getActivationCondition() {
        return this.activationCondition;
    }

    public void setActivationCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.checkSetterPreconditions();
        this.activationCondition = (Predicate)Constraint.isNotNull(condition, (String)"Predicate cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (this.activationCondition.test(profileRequestContext)) {
            return super.doPreExecute(profileRequestContext);
        }
        LoggerFactory.getLogger(AbstractConditionalProfileAction.class).debug("{} Activation condition for action returned false", (Object)this.getLogPrefix());
        return false;
    }
}

