/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.bval.util.Validate;

public class CollectionSet<E>
implements Set<E> {
    private final Collection<E> wrapped;

    public CollectionSet(Collection<? extends E> wrapped) {
        this.wrapped = Collections.unmodifiableCollection(Validate.notNull(wrapped));
        Validate.isTrue(wrapped.stream().distinct().count() == (long)wrapped.size(), "Collection values are not distinct", new Object[0]);
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.wrapped.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.wrapped.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.wrapped.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.wrapped.toArray(a);
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.wrapped.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

