/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.util;

import java.util.function.IntUnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bval.util.Validate;

public class LookBehindRegexHolder {
    public static final int DEFAULT_INITIAL_MAXIMUM_LENGTH = 256;
    public static final int DEFAULT_EXPANSION_BLOCK_SIZE = 128;
    private final String regex;
    private final int expansionBlockSize;
    private final IntUnaryOperator computeInjectedRepetition;
    private volatile int maximumLength;
    private Pattern pattern;

    public LookBehindRegexHolder(String regex, IntUnaryOperator computeInjectedRepetition) {
        this(regex, 256, 128, computeInjectedRepetition);
    }

    public LookBehindRegexHolder(String regex, int initialMaximumLength, int expansionBlockSize, IntUnaryOperator computeInjectedRepetition) {
        Validate.isTrue(regex != null && !regex.trim().isEmpty(), "empty regex", new Object[0]);
        Validate.isTrue(initialMaximumLength > 0, "invalid initial maximum length %d", initialMaximumLength);
        Validate.isTrue(expansionBlockSize > 0, "Invalid expansion block size %d", expansionBlockSize);
        Validate.notNull(computeInjectedRepetition, "missing %s to compute injected repetition", IntUnaryOperator.class.getSimpleName());
        this.regex = regex;
        this.expansionBlockSize = expansionBlockSize;
        this.computeInjectedRepetition = computeInjectedRepetition;
        this.accommodate(initialMaximumLength);
    }

    public Matcher matcher(CharSequence s) {
        if (s.length() > this.maximumLength) {
            this.accommodate(s.length());
        }
        return this.pattern.matcher(s);
    }

    int getMaximumLength() {
        return this.maximumLength;
    }

    String getPattern() {
        return this.pattern.pattern();
    }

    private synchronized void accommodate(int maximumLength) {
        if (this.maximumLength < maximumLength) {
            if (this.maximumLength == 0) {
                this.maximumLength = maximumLength;
            } else {
                int difference = maximumLength - this.maximumLength;
                int addBlocks = difference / this.expansionBlockSize + 1;
                this.maximumLength += addBlocks * this.expansionBlockSize;
            }
            this.pattern = Pattern.compile(String.format(this.regex, this.computeInjectedRepetition.applyAsInt(this.maximumLength)));
        }
    }
}

