/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.trust.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.trust.TrustedCredentialTrustEngine;
import org.opensaml.security.trust.impl.ExplicitKeyTrustEvaluator;
import org.slf4j.Logger;

public class ExplicitKeyTrustEngine
implements TrustedCredentialTrustEngine<Credential> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ExplicitKeyTrustEngine.class);
    @Nonnull
    private final CredentialResolver credentialResolver;
    @Nonnull
    private final ExplicitKeyTrustEvaluator trustEvaluator;

    public ExplicitKeyTrustEngine(@Nonnull @ParameterName(name="resolver") CredentialResolver resolver) {
        this.credentialResolver = (CredentialResolver)Constraint.isNotNull((Object)resolver, (String)"Credential resolver cannot be null");
        this.trustEvaluator = new ExplicitKeyTrustEvaluator();
    }

    @Nonnull
    public CredentialResolver getCredentialResolver() {
        return this.credentialResolver;
    }

    public boolean validate(@Nonnull Credential untrustedCredential, @Nullable CriteriaSet trustBasisCriteria) throws SecurityException {
        this.log.debug("Attempting to validate untrusted credential");
        try {
            Iterable trustedCredentials = this.getCredentialResolver().resolve((Object)trustBasisCriteria);
            return this.trustEvaluator.validate(untrustedCredential, trustedCredentials);
        }
        catch (ResolverException e) {
            throw new SecurityException("Error resolving trusted credentials", (Exception)((Object)e));
        }
    }
}

