/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.saml.metadata.support.SAML2MetadataSupport;
import org.opensaml.saml.saml2.metadata.ArtifactResolutionService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.ManageNameIDService;
import org.opensaml.saml.saml2.metadata.NameIDFormat;
import org.opensaml.saml.saml2.metadata.SSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml.saml2.metadata.impl.RoleDescriptorImpl;

public abstract class SSODescriptorImpl
extends RoleDescriptorImpl
implements SSODescriptor {
    @Nonnull
    private final XMLObjectChildrenList<ArtifactResolutionService> artifactResolutionServices = new XMLObjectChildrenList((XMLObject)this);
    @Nonnull
    private final XMLObjectChildrenList<SingleLogoutService> singleLogoutServices = new XMLObjectChildrenList((XMLObject)this);
    @Nonnull
    private final XMLObjectChildrenList<ManageNameIDService> manageNameIDServices = new XMLObjectChildrenList((XMLObject)this);
    @Nonnull
    private final XMLObjectChildrenList<NameIDFormat> nameIDFormats = new XMLObjectChildrenList((XMLObject)this);

    protected SSODescriptorImpl(@Nullable String namespaceURI, @Nonnull String elementLocalName, @Nullable String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Nonnull
    @Live
    public List<ArtifactResolutionService> getArtifactResolutionServices() {
        return this.artifactResolutionServices;
    }

    @Nullable
    public ArtifactResolutionService getDefaultArtifactResolutionService() {
        return (ArtifactResolutionService)SAML2MetadataSupport.getDefaultIndexedEndpoint(this.artifactResolutionServices);
    }

    @Nonnull
    @Live
    public List<SingleLogoutService> getSingleLogoutServices() {
        return this.singleLogoutServices;
    }

    @Nonnull
    @Live
    public List<ManageNameIDService> getManageNameIDServices() {
        return this.manageNameIDServices;
    }

    @Nonnull
    @Live
    public List<NameIDFormat> getNameIDFormats() {
        return this.nameIDFormats;
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public List<Endpoint> getEndpoints() {
        ArrayList<Object> endpoints = new ArrayList<Object>();
        endpoints.addAll((Collection<Object>)this.artifactResolutionServices);
        endpoints.addAll((Collection<Object>)this.singleLogoutServices);
        endpoints.addAll((Collection<Object>)this.manageNameIDServices);
        return CollectionSupport.copyToList(endpoints);
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public List<Endpoint> getEndpoints(@Nonnull QName type) {
        if (type.equals(ArtifactResolutionService.DEFAULT_ELEMENT_NAME)) {
            return CollectionSupport.copyToList(this.artifactResolutionServices);
        }
        if (type.equals(SingleLogoutService.DEFAULT_ELEMENT_NAME)) {
            return CollectionSupport.copyToList(this.singleLogoutServices);
        }
        if (type.equals(ManageNameIDService.DEFAULT_ELEMENT_NAME)) {
            return CollectionSupport.copyToList(this.manageNameIDServices);
        }
        return CollectionSupport.emptyList();
    }

    @Override
    @Nullable
    @NotLive
    @Unmodifiable
    public List<XMLObject> getOrderedChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        List<XMLObject> parentChildren = super.getOrderedChildren();
        if (parentChildren != null) {
            children.addAll(parentChildren);
        }
        children.addAll((Collection<Object>)this.artifactResolutionServices);
        children.addAll((Collection<Object>)this.singleLogoutServices);
        children.addAll((Collection<Object>)this.manageNameIDServices);
        children.addAll((Collection<Object>)this.nameIDFormats);
        return CollectionSupport.copyToList(children);
    }
}

