/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.Interceptor;
import org.apache.openejb.jee.InterceptorOrder;
import org.apache.openejb.jee.NamedMethod;
import org.apache.openejb.jee.Text;
import org.apache.openejb.jee.TextMap;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="interceptor-bindingType", propOrder={"descriptions", "ejbName", "interceptorClass", "interceptorOrder", "excludeDefaultInterceptors", "excludeClassInterceptors", "method"})
public class InterceptorBinding {
    @XmlTransient
    protected TextMap description = new TextMap();
    @XmlElement(name="ejb-name", required=true)
    protected String ejbName;
    @XmlElement(name="interceptor-class", required=true)
    protected List<String> interceptorClass;
    @XmlElement(name="interceptor-order")
    protected InterceptorOrder interceptorOrder;
    @XmlElement(name="exclude-default-interceptors")
    protected boolean excludeDefaultInterceptors;
    @XmlElement(name="exclude-class-interceptors")
    protected boolean excludeClassInterceptors;
    protected NamedMethod method;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    protected String id;
    @XmlTransient
    protected String className;

    public InterceptorBinding() {
    }

    public InterceptorBinding(EnterpriseBean bean, Interceptor ... interceptors) {
        this(bean.getEjbName(), interceptors);
        this.className = bean.getEjbClass();
    }

    public InterceptorBinding(String ejbName, Interceptor ... interceptors) {
        this.ejbName = ejbName;
        List<String> interceptorClasses = this.getInterceptorClass();
        for (Interceptor interceptor : interceptors) {
            interceptorClasses.add(interceptor.getInterceptorClass());
        }
    }

    public InterceptorBinding(String ejbName, String ... interceptorClasses) {
        this.ejbName = ejbName;
        this.getInterceptorClass().addAll(Arrays.asList(interceptorClasses));
    }

    public InterceptorBinding(String ejbName) {
        this.ejbName = ejbName;
    }

    @XmlElement(name="description", required=true)
    public Text[] getDescriptions() {
        return this.description.toArray();
    }

    public void setDescriptions(Text[] text) {
        this.description.set(text);
    }

    public String getDescription() {
        return this.description.get();
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public void setEjbName(String value) {
        this.ejbName = value;
    }

    public List<String> getInterceptorClass() {
        if (this.interceptorClass == null) {
            this.interceptorClass = new ArrayList<String>();
        }
        return this.interceptorClass;
    }

    public InterceptorOrder getInterceptorOrder() {
        return this.interceptorOrder;
    }

    public InterceptorOrder setInterceptorOrder(InterceptorOrder value) {
        this.interceptorOrder = value;
        return value;
    }

    public boolean getExcludeDefaultInterceptors() {
        return this.excludeDefaultInterceptors;
    }

    public void setExcludeDefaultInterceptors(boolean value) {
        this.excludeDefaultInterceptors = value;
    }

    public boolean getExcludeClassInterceptors() {
        return this.excludeClassInterceptors;
    }

    public void setExcludeClassInterceptors(boolean value) {
        this.excludeClassInterceptors = value;
    }

    public NamedMethod getMethod() {
        return this.method;
    }

    public void setMethod(NamedMethod value) {
        this.method = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public String getClassName() {
        return this.className;
    }
}

