/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.manager;

import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.manager.DbfFactory;
import java.io.File;
import java.io.IOException;
import javax.xml.validation.Schema;
import org.xml.sax.SAXException;

public enum FacesSchema {
    FACES_11("/com/sun/faces/web-facesconfig_1_1.xsd", ""),
    FACES_12("/com/sun/faces/web-facesconfig_1_2.xsd", Schemas.FACES_1_2_XSD_FILE),
    FACES_20("/com/sun/faces/web-facesconfig_2_0.xsd", Schemas.FACES_2_0_XSD_FILE),
    FACES_21("/com/sun/faces/web-facesconfig_2_1.xsd", Schemas.FACES_2_1_XSD_FILE),
    FACES_22("/com/sun/faces/web-facesconfig_2_2.xsd", Schemas.FACES_2_2_XSD_FILE),
    FACES_23("/com/sun/faces/web-facesconfig_2_3.xsd", Schemas.FACES_2_3_XSD_FILE),
    FACES_30("/com/sun/faces/web-facesconfig_3_0.xsd", Schemas.FACES_3_0_XSD_FILE),
    FACES_40("/com/sun/faces/web-facesconfig_4_0.xsd", Schemas.FACES_4_0_XSD_FILE),
    FACELET_TAGLIB_20("/com/sun/faces/web-facelettaglibrary_2_0.xsd", Schemas.FACELET_TAGLIB_2_0_XSD_FILE),
    FACELET_TAGLIB_22("/com/sun/faces/web-facelettaglibrary_2_2.xsd", Schemas.FACELET_TAGLIB_2_2_XSD_FILE),
    FACELET_TAGLIB_23("/com/sun/faces/web-facelettaglibrary_2_3.xsd", Schemas.FACELET_TAGLIB_2_3_XSD_FILE),
    FACELET_TAGLIB_30("/com/sun/faces/web-facelettaglibrary_3_0.xsd", Schemas.FACELET_TAGLIB_3_0_XSD_FILE),
    FACELET_TAGLIB_40("/com/sun/faces/web-facelettaglibrary_4_0.xsd", Schemas.FACELET_TAGLIB_4_0_XSD_FILE);

    private String resourceName;
    private String fileName;

    private FacesSchema(String resourceName, String fileName) {
        this.resourceName = resourceName;
        this.fileName = fileName;
    }

    public static FacesSchema fromDocumentId(String documentNS, String version, String localName) {
        switch (documentNS) {
            case "https://jakarta.ee/xml/ns/jakartaee": {
                switch (version) {
                    case "4.0": {
                        if ("facelet-taglib".equals(localName)) {
                            return FACELET_TAGLIB_40;
                        }
                        return FACES_40;
                    }
                    case "3.0": {
                        if ("facelet-taglib".equals(localName)) {
                            return FACELET_TAGLIB_30;
                        }
                        return FACES_30;
                    }
                }
                throw new ConfigurationException("Unknown Schema version: " + version);
            }
            case "http://xmlns.jcp.org/xml/ns/javaee": {
                switch (version) {
                    case "2.3": {
                        if ("facelet-taglib".equals(localName)) {
                            return FACELET_TAGLIB_23;
                        }
                        return FACES_23;
                    }
                    case "2.2": {
                        if ("facelet-taglib".equals(localName)) {
                            return FACELET_TAGLIB_22;
                        }
                        return FACES_22;
                    }
                }
                throw new ConfigurationException("Unknown Schema version: " + version);
            }
            case "http://java.sun.com/xml/ns/javaee": {
                switch (version) {
                    case "2.1": {
                        if ("facelet-taglib".equals(localName)) {
                            return FACELET_TAGLIB_20;
                        }
                        return FACES_21;
                    }
                    case "2.0": {
                        if ("facelet-taglib".equals(localName)) {
                            return FACELET_TAGLIB_20;
                        }
                        return FACES_20;
                    }
                    case "1.2": {
                        return FACES_12;
                    }
                }
                throw new ConfigurationException("Unknown Schema version: " + version);
            }
            case "http://java.sun.com/JSF/Configuration": {
                return FACES_11;
            }
        }
        return null;
    }

    public Schema loadSchema() {
        try {
            return DbfFactory.loadSchema(this.resourceName, this.fileName);
        }
        catch (IOException | SAXException e) {
            throw new ConfigurationException(e);
        }
    }

    public static class Schemas {
        private static final String AS_INSTALL_ROOT = "com.sun.aas.installRoot";
        private static final String AS_SCHEMA_DIR = System.getProperty("com.sun.aas.installRoot") + File.separatorChar + "lib" + File.separatorChar + "schemas" + File.separatorChar;
        private static final String AS_DTD_DIR = System.getProperty("com.sun.aas.installRoot") + File.separatorChar + "lib" + File.separatorChar + "dtds" + File.separatorChar;
        public static final String FACES_CONFIG_1_X_DEFAULT_NS = "http://java.sun.com/JSF/Configuration";
        public static final String JAVAEE_SCHEMA_LEGACY_DEFAULT_NS = "http://java.sun.com/xml/ns/javaee";
        public static final String JAVAEE_SCHEMA_DEFAULT_NS = "http://xmlns.jcp.org/xml/ns/javaee";
        public static final String JAKARTAEE_SCHEMA_DEFAULT_NS = "https://jakarta.ee/xml/ns/jakartaee";
        public static final String FACELET_TAGLIB_2_0_XSD = "/com/sun/faces/web-facelettaglibrary_2_0.xsd";
        public static final String FACELET_TAGLIB_2_2_XSD = "/com/sun/faces/web-facelettaglibrary_2_2.xsd";
        public static final String FACELET_TAGLIB_2_3_XSD = "/com/sun/faces/web-facelettaglibrary_2_3.xsd";
        public static final String FACELET_TAGLIB_3_0_XSD = "/com/sun/faces/web-facelettaglibrary_3_0.xsd";
        public static final String FACELET_TAGLIB_4_0_XSD = "/com/sun/faces/web-facelettaglibrary_4_0.xsd";
        public static final String FACES_1_2_XSD = "/com/sun/faces/web-facesconfig_1_2.xsd";
        public static final String FACES_1_1_XSD = "/com/sun/faces/web-facesconfig_1_1.xsd";
        public static final String FACES_2_0_XSD = "/com/sun/faces/web-facesconfig_2_0.xsd";
        public static final String FACES_2_1_XSD = "/com/sun/faces/web-facesconfig_2_1.xsd";
        public static final String FACES_2_2_XSD = "/com/sun/faces/web-facesconfig_2_2.xsd";
        public static final String FACES_2_3_XSD = "/com/sun/faces/web-facesconfig_2_3.xsd";
        public static final String FACES_3_0_XSD = "/com/sun/faces/web-facesconfig_3_0.xsd";
        public static final String FACES_4_0_XSD = "/com/sun/faces/web-facesconfig_4_0.xsd";
        public static final String FACELET_TAGLIB_2_0_XSD_FILE = AS_SCHEMA_DIR + "web-facelettaglibrary_2_0.xsd";
        public static final String FACELET_TAGLIB_2_2_XSD_FILE = AS_SCHEMA_DIR + "web-facelettaglibrary_2_2.xsd";
        public static final String FACELET_TAGLIB_2_3_XSD_FILE = AS_SCHEMA_DIR + "web-facelettaglibrary_2_3.xsd";
        public static final String FACELET_TAGLIB_3_0_XSD_FILE = AS_SCHEMA_DIR + "web-facelettaglibrary_3_0.xsd";
        public static final String FACELET_TAGLIB_4_0_XSD_FILE = AS_SCHEMA_DIR + "web-facelettaglibrary_4_0.xsd";
        public static final String FACES_1_2_XSD_FILE = AS_SCHEMA_DIR + "web-facesconfig_1_2.xsd";
        public static final String FACES_2_0_XSD_FILE = AS_SCHEMA_DIR + "web-facesconfig_2_0.xsd";
        public static final String FACES_2_1_XSD_FILE = AS_SCHEMA_DIR + "web-facesconfig_2_1.xsd";
        public static final String FACES_2_2_XSD_FILE = AS_SCHEMA_DIR + "web-facesconfig_2_2.xsd";
        public static final String FACES_2_3_XSD_FILE = AS_SCHEMA_DIR + "web-facesconfig_2_3.xsd";
        public static final String FACES_3_0_XSD_FILE = AS_SCHEMA_DIR + "web-facesconfig_3_0.xsd";
        public static final String FACES_4_0_XSD_FILE = AS_SCHEMA_DIR + "web-facesconfig_4_0.xsd";
        public static final String[][] DTD_SCHEMA_INFO = new String[][]{{"web-facesconfig_1_0.dtd", "/com/sun/faces/web-facesconfig_1_0.dtd", AS_DTD_DIR + "web-facesconfig_1_0.dtd"}, {"web-facesconfig_1_1.dtd", "/com/sun/faces/web-facesconfig_1_1.dtd", AS_DTD_DIR + "web-facesconfig_1_1.dtd"}, {"web-facesconfig_2_0.xsd", "/com/sun/faces/web-facesconfig_2_0.xsd", FACES_2_0_XSD_FILE}, {"web-facesconfig_2_1.xsd", "/com/sun/faces/web-facesconfig_2_1.xsd", FACES_2_1_XSD_FILE}, {"web-facesconfig_2_2.xsd", "/com/sun/faces/web-facesconfig_2_2.xsd", FACES_2_2_XSD_FILE}, {"web-facesconfig_2_3.xsd", "/com/sun/faces/web-facesconfig_2_3.xsd", FACES_2_3_XSD_FILE}, {"web-facesconfig_3_0.xsd", "/com/sun/faces/web-facesconfig_3_0.xsd", FACES_3_0_XSD_FILE}, {"web-facesconfig_4_0.xsd", "/com/sun/faces/web-facesconfig_4_0.xsd", FACES_4_0_XSD_FILE}, {"facelet-taglib_1_0.dtd", "/com/sun/faces/facelet-taglib_1_0.dtd", null}, {"web-facelettaglibrary_2_0.xsd", "/com/sun/faces/web-facelettaglibrary_2_0.xsd", FACELET_TAGLIB_2_0_XSD_FILE}, {"web-facelettaglibrary_2_2.xsd", "/com/sun/faces/web-facelettaglibrary_2_2.xsd", FACELET_TAGLIB_2_2_XSD_FILE}, {"web-facelettaglibrary_2_3.xsd", "/com/sun/faces/web-facelettaglibrary_2_3.xsd", FACELET_TAGLIB_2_3_XSD_FILE}, {"web-facelettaglibrary_3_0.xsd", "/com/sun/faces/web-facelettaglibrary_3_0.xsd", FACELET_TAGLIB_3_0_XSD_FILE}, {"web-facelettaglibrary_4_0.xsd", "/com/sun/faces/web-facelettaglibrary_4_0.xsd", FACELET_TAGLIB_4_0_XSD_FILE}, {"web-facesconfig_1_2.xsd", "/com/sun/faces/web-facesconfig_1_2.xsd", FACES_1_2_XSD_FILE}, {"web-facesconfig_1_1.xsd", "/com/sun/faces/web-facesconfig_1_1.xsd", null}, {"javaee_5.xsd", "/com/sun/faces/javaee_5.xsd", AS_SCHEMA_DIR + "javaee_5.xsd"}, {"javaee_6.xsd", "/com/sun/faces/javaee_6.xsd", AS_SCHEMA_DIR + "javaee_6.xsd"}, {"javaee_7.xsd", "/com/sun/faces/javaee_7.xsd", AS_SCHEMA_DIR + "javaee_7.xsd"}, {"javaee_8.xsd", "/com/sun/faces/javaee_8.xsd", AS_SCHEMA_DIR + "javaee_8.xsd"}, {"jakartaee_9.xsd", "/com/sun/faces/jakartaee_9.xsd", AS_SCHEMA_DIR + "jakartaee_9.xsd"}, {"jakartaee_10.xsd", "/com/sun/faces/jakartaee_10.xsd", AS_SCHEMA_DIR + "jakartaee_10.xsd"}, {"javaee_web_services_client_1_2.xsd", "/com/sun/faces/javaee_web_services_client_1_2.xsd", AS_SCHEMA_DIR + "javaee_web_services_client_1_2.xsd"}, {"javaee_web_services_client_1_3.xsd", "/com/sun/faces/javaee_web_services_client_1_3.xsd", AS_SCHEMA_DIR + "javaee_web_services_client_1_3.xsd"}, {"javaee_web_services_client_1_4.xsd", "/com/sun/faces/javaee_web_services_client_1_4.xsd", AS_SCHEMA_DIR + "javaee_web_services_client_1_4.xsd"}, {"jakartaee_web_services_client_2_0.xsd", "/com/sun/faces/jakartaee_web_services_client_2_0.xsd", AS_SCHEMA_DIR + "jakartaee_web_services_client_2_0.xsd"}, {"xml.xsd", "/com/sun/faces/xml.xsd", AS_SCHEMA_DIR + "xml.xsd"}, {"datatypes.dtd", "/com/sun/faces/datatypes.dtd", AS_SCHEMA_DIR + "datatypes.dtd"}, {"XMLSchema.dtd", "/com/sun/faces/XMLSchema.dtd", AS_SCHEMA_DIR + "XMLSchema.dtd"}};
    }
}

