/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.features;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.jaxb.SessionEventListener;
import org.eclipse.persistence.jaxb.metadata.MetadataSource;
import org.eclipse.persistence.jpa.rs.features.FeatureResponseBuilder;
import org.eclipse.persistence.jpa.rs.features.FeatureSet;
import org.eclipse.persistence.jpa.rs.features.core.selflinks.SelfLinksResponseBuilder;
import org.eclipse.persistence.jpa.rs.features.paging.PagingResponseBuilder;
import org.eclipse.persistence.jpa.rs.util.PreLoginMappingAdapterV2;
import org.eclipse.persistence.jpa.rs.util.metadatasources.CollectionWrapperMetadataSource;
import org.eclipse.persistence.jpa.rs.util.metadatasources.DynamicXmlV2MetadataSource;
import org.eclipse.persistence.jpa.rs.util.metadatasources.ErrorResponseMetadataSource;
import org.eclipse.persistence.jpa.rs.util.metadatasources.ItemLinksMetadataSource;
import org.eclipse.persistence.jpa.rs.util.metadatasources.JavaLangMetadataSource;
import org.eclipse.persistence.jpa.rs.util.metadatasources.JavaMathMetadataSource;
import org.eclipse.persistence.jpa.rs.util.metadatasources.JavaUtilMetadataSource;
import org.eclipse.persistence.jpa.rs.util.metadatasources.LinkV2MetadataSource;
import org.eclipse.persistence.jpa.rs.util.metadatasources.ReadAllQueryResultCollectionMetadataSource;
import org.eclipse.persistence.jpa.rs.util.metadatasources.ReportQueryResultCollectionMetadataSource;
import org.eclipse.persistence.jpa.rs.util.metadatasources.ReportQueryResultListItemMetadataSource;
import org.eclipse.persistence.jpa.rs.util.metadatasources.ReportQueryResultListMetadataSource;
import org.eclipse.persistence.jpa.rs.util.metadatasources.SimpleHomogeneousListMetadataSource;
import org.eclipse.persistence.jpa.rs.util.metadatasources.SingleResultQueryListMetadataSource;
import org.eclipse.persistence.jpa.rs.util.metadatasources.SingleResultQueryResultMetadataSource;
import org.eclipse.persistence.sessions.Session;

public class FeatureSetV2
implements FeatureSet {
    @Override
    public boolean isSupported(FeatureSet.Feature feature) {
        switch (feature) {
            case NO_PAGING: 
            case PAGING: 
            case FIELDS_FILTERING: {
                return true;
            }
        }
        return false;
    }

    @Override
    public FeatureResponseBuilder getResponseBuilder(FeatureSet.Feature feature) {
        switch (feature) {
            case PAGING: {
                return new PagingResponseBuilder();
            }
        }
        return new SelfLinksResponseBuilder();
    }

    @Override
    public List<MetadataSource> getMetadataSources() {
        ArrayList<MetadataSource> metadataSources = new ArrayList<MetadataSource>();
        metadataSources.add(new ReportQueryResultListMetadataSource());
        metadataSources.add(new ReportQueryResultListItemMetadataSource());
        metadataSources.add(new SingleResultQueryListMetadataSource());
        metadataSources.add(new SimpleHomogeneousListMetadataSource());
        metadataSources.add(new ReportQueryResultCollectionMetadataSource());
        metadataSources.add(new ReadAllQueryResultCollectionMetadataSource());
        metadataSources.add(new SingleResultQueryResultMetadataSource());
        metadataSources.add(new JavaLangMetadataSource());
        metadataSources.add(new JavaMathMetadataSource());
        metadataSources.add(new JavaUtilMetadataSource());
        metadataSources.add(new ErrorResponseMetadataSource());
        metadataSources.add(new ItemLinksMetadataSource());
        metadataSources.add(new LinkV2MetadataSource());
        metadataSources.add(new CollectionWrapperMetadataSource());
        return metadataSources;
    }

    @Override
    public MetadataSource getDynamicMetadataSource(Session session, String packageName) {
        return new DynamicXmlV2MetadataSource(session, packageName);
    }

    @Override
    public SessionEventListener getSessionEventListener(Session session) {
        return new PreLoginMappingAdapterV2();
    }
}

