/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.Opcodes;

public class EclipseLinkASMClassWriter
extends ClassWriter {
    private static final Logger LOG = Logger.getLogger(EclipseLinkASMClassWriter.class.getName());
    private static final int version = EclipseLinkASMClassWriter.getLatestOPCodeVersion();

    public EclipseLinkASMClassWriter() {
        this(2);
    }

    public EclipseLinkASMClassWriter(int flags) {
        super(flags);
    }

    public final void visit(int access, String name, String signature, String superName, String[] interfaces) {
        this.visit(version, access, name, signature, superName, interfaces);
    }

    private static int getLatestOPCodeVersion() {
        String v;
        String latest;
        String oldest;
        LinkedHashMap<String, Integer> versionMap;
        block12: {
            versionMap = new LinkedHashMap<String, Integer>();
            Pattern searchPattern = Pattern.compile("^V\\d((_\\d)?|\\d*)");
            try {
                Class<Opcodes> opcodesClazz = Opcodes.class;
                for (Field f : opcodesClazz.getDeclaredFields()) {
                    if (!searchPattern.matcher(f.getName()).matches()) continue;
                    versionMap.put(f.getName().replace("V", "").replace('_', '.'), f.getInt(opcodesClazz));
                }
            }
            catch (ReflectiveOperationException | SecurityException ex) {
                LOG.log(Level.SEVERE, "Error Java versions map from Opcodes.class fields.", ex);
                throw new RuntimeException(ex);
            }
            ArrayList versions = new ArrayList(versionMap.keySet());
            oldest = (String)versions.get(0);
            latest = (String)versions.get(versions.size() - 1);
            v = oldest;
            if (System.getSecurityManager() == null) {
                v = System.getProperty("java.specification.version");
            } else {
                try {
                    v = AccessController.doPrivileged(new PrivilegedAction<String>(){

                        @Override
                        public String run() {
                            return System.getProperty("java.specification.version");
                        }
                    });
                }
                catch (Throwable t) {
                    LOG.log(Level.WARNING, "Cannot read 'java.specification.version' property.", t);
                    if (!LOG.isLoggable(Level.FINE)) break block12;
                    LOG.log(Level.FINE, "Generating bytecode for Java SE ''{0}''.", v);
                }
            }
        }
        Integer version = (Integer)versionMap.get(v);
        if (version == null) {
            if (latest.compareTo(v) < 0) {
                LOG.log(Level.WARNING, "Java SE ''{0}'' is not fully supported yet. Report this error to the EclipseLink open source project.", v);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Generating bytecode for Java SE ''{0}''.", latest);
                }
                version = (Integer)versionMap.get(latest);
            } else {
                String key = oldest;
                LOG.log(Level.WARNING, "Java SE ''{0}'' is too old.", v);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Generating bytecode for Java SE ''{0}''.", key);
                }
                version = (Integer)versionMap.get(key);
            }
        }
        return version;
    }
}

