/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.util.EventObject;
import org.eclipse.persistence.core.descriptors.CoreDescriptor;
import org.eclipse.persistence.core.descriptors.CoreDescriptorEvent;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.sessions.DataRecord;

public class DescriptorEvent
extends EventObject
implements CoreDescriptorEvent {
    protected int eventCode;
    protected DatabaseQuery query;
    protected DataRecord dataRecord;
    protected ClassDescriptor descriptor;
    protected Object originalObject;
    protected ObjectChangeSet changeSet;
    protected AbstractSession session;
    protected static String[] eventNames = new String[18];

    public DescriptorEvent(int eventCode, ObjectLevelModifyQuery query) {
        this(query.getObject());
        this.query = query;
        this.eventCode = eventCode;
        this.session = query.getSession();
        this.descriptor = query.getDescriptor();
    }

    public DescriptorEvent(Object sourceObject) {
        super(sourceObject);
    }

    public void applyAttributeValuesIntoRow(String attributeName) {
        ClassDescriptor descriptor = this.getSession().getDescriptor(this.getSource());
        DatabaseMapping mapping = descriptor.getObjectBuilder().getMappingForAttributeName(attributeName);
        if (mapping == null) {
            throw ValidationException.missingMappingForAttribute(descriptor, attributeName, this.toString());
        }
        if (this.getRecord() != null) {
            mapping.writeFromObjectIntoRow(this.getSource(), (AbstractRecord)this.getRecord(), this.getSession(), DatabaseMapping.WriteType.UNDEFINED);
        }
    }

    public ObjectChangeSet getChangeSet() {
        return this.changeSet;
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public ClassDescriptor getClassDescriptor() {
        return this.descriptor;
    }

    public int getEventCode() {
        return this.eventCode;
    }

    public Object getObject() {
        return this.getSource();
    }

    public Object getOriginalObject() {
        if (this.originalObject == null && this.getSession().isUnitOfWork() && this.getQuery() != null && this.getQuery().isObjectLevelModifyQuery()) {
            this.setOriginalObject(((UnitOfWorkImpl)this.getSession()).getOriginalVersionOfObject(this.getSource()));
        }
        return this.originalObject;
    }

    public DatabaseQuery getQuery() {
        return this.query;
    }

    public DataRecord getRecord() {
        return this.dataRecord;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public void setChangeSet(ObjectChangeSet newChangeSet) {
        this.changeSet = newChangeSet;
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void setEventCode(int eventCode) {
        this.eventCode = eventCode;
    }

    public void setOriginalObject(Object originalObject) {
        this.originalObject = originalObject;
    }

    public void setQuery(DatabaseQuery query) {
        this.query = query;
    }

    public void setRecord(DataRecord dataRecord) {
        this.dataRecord = dataRecord;
    }

    public void setSession(AbstractSession session) {
        this.session = session;
    }

    @Override
    public String toString() {
        String eventName = "UnkownEvent";
        if (this.getEventCode() >= 0 && this.getEventCode() < 18) {
            eventName = eventNames[this.getEventCode()];
        }
        return eventName + "(" + this.getSource().getClass() + ")";
    }

    public void updateAttributeWithObject(String attributeName, Object value) {
        CoreDescriptor descriptor;
        DatabaseMapping mapping = this.query.getDescriptor().getObjectBuilder().getMappingForAttributeName(attributeName);
        if (mapping == null) {
            throw DescriptorException.mappingForAttributeIsMissing(attributeName, this.getDescriptor());
        }
        Object clone = this.getObject();
        Object cloneValue = value;
        Object original = null;
        if (this.eventCode == 10 || this.eventCode == 11) {
            original = this.getOriginalObject();
        }
        Object originalValue = value;
        ObjectChangeSet eventChangeSet = this.getChangeSet();
        Object valueForChangeSet = value;
        if (this.query != null && this.query.isObjectLevelModifyQuery()) {
            clone = ((ObjectLevelModifyQuery)this.query).getObject();
            eventChangeSet = ((ObjectLevelModifyQuery)this.query).getObjectChangeSet();
        }
        if ((descriptor = this.getSession().getDescriptor((Class)value.getClass())) != null) {
            if (eventChangeSet != null) {
                valueForChangeSet = ((ClassDescriptor)descriptor).getObjectBuilder().createObjectChangeSet(value, (UnitOfWorkChangeSet)eventChangeSet.getUOWChangeSet(), this.getSession());
            }
            if (original != null) {
                originalValue = ((UnitOfWorkImpl)this.getSession()).getOriginalVersionOfObject(value);
            }
        }
        if (clone != null) {
            mapping.setRealAttributeValueInObject(clone, cloneValue);
        }
        if (original != null) {
            mapping.setRealAttributeValueInObject(original, originalValue);
        }
        if (this.getRecord() != null) {
            AbstractRecord tempRow = this.getDescriptor().getObjectBuilder().createRecord(this.getSession());
            mapping.writeFromObjectIntoRow(clone, tempRow, this.getSession(), DatabaseMapping.WriteType.UNDEFINED);
            ((AbstractRecord)this.getRecord()).mergeFrom(tempRow);
        }
        if (eventChangeSet != null && (!eventChangeSet.isNew() || this.query.getDescriptor() != null && this.query.getDescriptor().shouldUseFullChangeSetsForNewObjects())) {
            eventChangeSet.removeChange(attributeName);
            eventChangeSet.addChange(mapping.compareForChange(clone, ((UnitOfWorkImpl)this.getSession()).getBackupClone(clone, this.getDescriptor()), eventChangeSet, this.getSession()));
            eventChangeSet.setShouldRecalculateAfterUpdateEvent(false);
        }
    }

    public void updateAttributeAddObjectToCollection(String attributeName, Object mapKey, Object value) {
        Object collection;
        CoreDescriptor descriptor;
        DatabaseMapping mapping = this.query.getDescriptor().getObjectBuilder().getMappingForAttributeName(attributeName);
        if (mapping == null) {
            throw DescriptorException.mappingForAttributeIsMissing(attributeName, this.getDescriptor());
        }
        Object clone = this.getObject();
        Object cloneValue = value;
        Object original = null;
        if (this.eventCode == 10 || this.eventCode == 11) {
            original = this.getOriginalObject();
        }
        Object originalValue = value;
        ObjectChangeSet eventChangeSet = this.getChangeSet();
        Object valueForChangeSet = value;
        if (this.query != null && this.query.isObjectLevelModifyQuery()) {
            clone = ((ObjectLevelModifyQuery)this.query).getObject();
            eventChangeSet = ((ObjectLevelModifyQuery)this.query).getObjectChangeSet();
        }
        if ((descriptor = this.getSession().getDescriptor((Class)value.getClass())) != null) {
            if (eventChangeSet != null) {
                valueForChangeSet = ((ClassDescriptor)descriptor).getObjectBuilder().createObjectChangeSet(value, (UnitOfWorkChangeSet)eventChangeSet.getUOWChangeSet(), this.getSession());
            }
            if (original != null) {
                originalValue = ((UnitOfWorkImpl)this.getSession()).getOriginalVersionOfObject(value);
            }
        }
        if (clone != null) {
            collection = mapping.getRealCollectionAttributeValueFromObject(clone, this.getSession());
            mapping.getContainerPolicy().addInto(mapKey, cloneValue, collection, this.getSession());
        }
        if (original != null) {
            collection = mapping.getRealCollectionAttributeValueFromObject(original, this.getSession());
            mapping.getContainerPolicy().addInto(mapKey, originalValue, collection, this.getSession());
        }
        if (this.getRecord() != null) {
            AbstractRecord tempRow = this.getDescriptor().getObjectBuilder().createRecord(this.getSession());
            mapping.writeFromObjectIntoRow(clone, tempRow, this.getSession(), DatabaseMapping.WriteType.UNDEFINED);
            ((AbstractRecord)this.getRecord()).mergeFrom(tempRow);
        }
        if (eventChangeSet != null) {
            mapping.simpleAddToCollectionChangeRecord(mapKey, valueForChangeSet, eventChangeSet, this.getSession());
            eventChangeSet.setShouldRecalculateAfterUpdateEvent(false);
        }
    }

    public void updateAttributeRemoveObjectFromCollection(String attributeName, Object mapKey, Object value) {
        Object collection;
        CoreDescriptor descriptor;
        DatabaseMapping mapping = this.query.getDescriptor().getObjectBuilder().getMappingForAttributeName(attributeName);
        if (mapping == null) {
            throw DescriptorException.mappingForAttributeIsMissing(attributeName, this.getDescriptor());
        }
        Object clone = this.getObject();
        Object cloneValue = value;
        Object original = null;
        if (this.eventCode == 10 || this.eventCode == 11) {
            original = this.getOriginalObject();
        }
        Object originalValue = value;
        ObjectChangeSet eventChangeSet = this.getChangeSet();
        Object valueForChangeSet = value;
        if (this.query != null && this.query.isObjectLevelModifyQuery()) {
            clone = ((ObjectLevelModifyQuery)this.query).getObject();
            eventChangeSet = ((ObjectLevelModifyQuery)this.query).getObjectChangeSet();
        }
        if ((descriptor = this.getSession().getDescriptor((Class)value.getClass())) != null) {
            if (eventChangeSet != null) {
                valueForChangeSet = ((ClassDescriptor)descriptor).getObjectBuilder().createObjectChangeSet(value, (UnitOfWorkChangeSet)eventChangeSet.getUOWChangeSet(), this.getSession());
            }
            if (original != null) {
                originalValue = ((UnitOfWorkImpl)this.getSession()).getOriginalVersionOfObject(value);
            }
        }
        if (clone != null) {
            collection = mapping.getRealCollectionAttributeValueFromObject(clone, this.getSession());
            mapping.getContainerPolicy().removeFrom(mapKey, cloneValue, collection, this.getSession());
        }
        if (original != null) {
            collection = mapping.getRealCollectionAttributeValueFromObject(original, this.getSession());
            mapping.getContainerPolicy().removeFrom(mapKey, originalValue, collection, this.getSession());
        }
        if (this.getRecord() != null) {
            AbstractRecord tempRow = this.getDescriptor().getObjectBuilder().createRecord(this.getSession());
            mapping.writeFromObjectIntoRow(clone, tempRow, this.getSession(), DatabaseMapping.WriteType.UNDEFINED);
            ((AbstractRecord)this.getRecord()).mergeFrom(tempRow);
        }
        if (eventChangeSet != null) {
            mapping.simpleRemoveFromCollectionChangeRecord(mapKey, valueForChangeSet, eventChangeSet, this.getSession());
            eventChangeSet.setShouldRecalculateAfterUpdateEvent(false);
        }
    }

    static {
        DescriptorEvent.eventNames[0] = "PreWriteEvent";
        DescriptorEvent.eventNames[1] = "PostWriteEvent";
        DescriptorEvent.eventNames[2] = "PostDeleteEvent";
        DescriptorEvent.eventNames[3] = "PostDeleteEvent";
        DescriptorEvent.eventNames[4] = "PreInsertEvent";
        DescriptorEvent.eventNames[5] = "PostInsertEvent";
        DescriptorEvent.eventNames[6] = "PreUpdateEvent";
        DescriptorEvent.eventNames[7] = "PostUpdateEvent";
        DescriptorEvent.eventNames[8] = "PostBuildEvent";
        DescriptorEvent.eventNames[9] = "PostRefreshEvent";
        DescriptorEvent.eventNames[10] = "PostCloneEvent";
        DescriptorEvent.eventNames[11] = "PostMergeEvent";
        DescriptorEvent.eventNames[12] = "AboutToInsertEvent";
        DescriptorEvent.eventNames[13] = "AboutToUpdateEvent";
    }
}

