/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.messaging.logic;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProxiedRequesterContext;

public class ProxiedRequesterPredicate
implements Predicate<MessageContext> {
    @Nonnull
    private final Set<String> entityIds;

    public ProxiedRequesterPredicate(@Nonnull Collection<String> ids) {
        Constraint.isNotNull(ids, (String)"EntityID collection cannot be null");
        this.entityIds = new HashSet<String>(StringSupport.normalizeStringCollection(ids));
    }

    @Override
    public boolean test(@Nullable MessageContext input) {
        ProxiedRequesterContext ctx;
        ProxiedRequesterContext proxiedRequesterContext = ctx = input != null ? (ProxiedRequesterContext)input.getSubcontext(ProxiedRequesterContext.class) : null;
        if (ctx != null) {
            return !Collections.disjoint(this.entityIds, ctx.getRequesters());
        }
        return false;
    }
}

