/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.PathProcessor;
import org.apache.tinkerpop.gremlin.process.traversal.step.SideEffectCapable;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.TreeStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Tree;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalRing;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.function.TreeSupplier;

public final class TreeSideEffectStep<S>
extends SideEffectStep<S>
implements SideEffectCapable<Tree, Tree>,
TraversalParent,
ByModulating,
PathProcessor {
    private TraversalRing<Object, Object> traversalRing;
    private String sideEffectKey;
    private Set<String> keepLabels;

    public TreeSideEffectStep(Traversal.Admin traversal, String sideEffectKey) {
        super(traversal);
        this.sideEffectKey = sideEffectKey;
        this.traversalRing = new TraversalRing(new Traversal.Admin[0]);
        this.getTraversal().getSideEffects().registerIfAbsent(this.sideEffectKey, TreeSupplier.instance(), TreeStep.TreeBiOperator.instance());
    }

    @Override
    protected void sideEffect(Traverser.Admin<S> traverser) {
        Tree root;
        Tree depth = root = new Tree();
        Path path = traverser.path();
        for (int i = 0; i < path.size(); ++i) {
            Object object = TraversalUtil.applyNullable(path.get(i), this.traversalRing.next());
            if (!depth.containsKey(object)) {
                depth.put(object, new Tree());
            }
            depth = (Tree)depth.get(object);
        }
        this.traversalRing.reset();
        this.getTraversal().getSideEffects().add(this.sideEffectKey, root);
    }

    @Override
    protected Traverser.Admin<S> processNextStart() {
        return PathProcessor.processTraverserPathLabels(super.processNextStart(), this.keepLabels);
    }

    @Override
    public String getSideEffectKey() {
        return this.sideEffectKey;
    }

    @Override
    public void reset() {
        super.reset();
        this.traversalRing.reset();
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.sideEffectKey, this.traversalRing);
    }

    @Override
    public TreeSideEffectStep<S> clone() {
        TreeSideEffectStep clone = (TreeSideEffectStep)super.clone();
        clone.traversalRing = this.traversalRing.clone();
        return clone;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.traversalRing.getTraversals().forEach(this::integrateChild);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.sideEffectKey.hashCode() ^ this.traversalRing.hashCode();
    }

    public List<Traversal.Admin<Object, Object>> getLocalChildren() {
        return this.traversalRing.getTraversals();
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> treeTraversal) {
        this.traversalRing.addTraversal(this.integrateChild(treeTraversal));
    }

    @Override
    public void replaceLocalChild(Traversal.Admin<?, ?> oldTraversal, Traversal.Admin<?, ?> newTraversal) {
        this.traversalRing.replaceTraversal(oldTraversal, this.integrateChild(newTraversal));
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.PATH, TraverserRequirement.SIDE_EFFECTS);
    }

    @Override
    public void setKeepLabels(Set<String> keepLabels) {
        this.keepLabels = new HashSet<String>(keepLabels);
    }

    @Override
    public Set<String> getKeepLabels() {
        return this.keepLabels;
    }
}

