/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.pac4j.authentication.handler.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.apereo.cas.authentication.principal.ClientCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.BasicUserProfile;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDelegatedClientAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseDelegatedClientAuthenticationHandler.class);
    protected final SessionStore sessionStore;
    private String principalAttributeId;
    private boolean isTypedIdUsed;

    protected BaseDelegatedClientAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Integer order, SessionStore sessionStore) {
        super(name, servicesManager, principalFactory, order);
        this.sessionStore = sessionStore;
    }

    protected AuthenticationHandlerExecutionResult createResult(ClientCredential credentials, UserProfile profile, BaseClient client, Service service) throws Throwable {
        if (profile == null) {
            throw new FailedLoginException("Authentication did not produce a user profile for: " + String.valueOf(credentials));
        }
        String id = this.determinePrincipalIdFrom(profile, client);
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new FailedLoginException("No identifier found for this user profile: " + String.valueOf(profile));
        }
        credentials.setUserProfile(profile);
        credentials.setTypedIdUsed(this.isTypedIdUsed);
        Map attributes = CollectionUtils.toMultiValuedMap((Map)profile.getAttributes());
        attributes.put("clientName", CollectionUtils.wrap((Object)profile.getClientName()));
        if (profile instanceof BasicUserProfile) {
            BasicUserProfile bup = (BasicUserProfile)profile;
            attributes.putAll(CollectionUtils.toMultiValuedMap((Map)bup.getAuthenticationAttributes()));
        }
        Principal initialPrincipal = this.principalFactory.createPrincipal(id, attributes);
        Principal principal = this.finalizeAuthenticationPrincipal(initialPrincipal, client, credentials, service);
        LOGGER.debug("Constructed authenticated principal [{}] based on user profile [{}]", (Object)principal, (Object)profile);
        return this.finalizeAuthenticationHandlerResult(credentials, principal, profile, client, service);
    }

    protected Principal finalizeAuthenticationPrincipal(Principal initialPrincipal, BaseClient client, ClientCredential credentials, Service service) throws Throwable {
        return initialPrincipal;
    }

    protected AuthenticationHandlerExecutionResult finalizeAuthenticationHandlerResult(ClientCredential credentials, Principal principal, UserProfile profile, BaseClient client, Service service) throws Throwable {
        this.preFinalizeAuthenticationHandlerResult(credentials, principal, profile, client, service);
        AuthenticationHandlerExecutionResult result = this.createHandlerResult((Credential)credentials, principal, new ArrayList());
        return this.postFinalizeAuthenticationHandlerResult(result, credentials, principal, client, service);
    }

    protected AuthenticationHandlerExecutionResult postFinalizeAuthenticationHandlerResult(AuthenticationHandlerExecutionResult result, ClientCredential credentials, Principal principal, BaseClient client, Service service) {
        return result;
    }

    protected void preFinalizeAuthenticationHandlerResult(ClientCredential credentials, Principal principal, UserProfile profile, BaseClient client, Service service) throws Throwable {
    }

    protected String determinePrincipalIdFrom(UserProfile profile, BaseClient client) {
        Map properties;
        String id = profile.getId();
        Map map = properties = client != null ? client.getCustomProperties() : new HashMap(0);
        if (client != null && properties.containsKey("principalAttributeId")) {
            Object attrObject = properties.get("principalAttributeId");
            if (attrObject != null) {
                String principalAttribute = attrObject.toString();
                if (profile.containsAttribute(principalAttribute)) {
                    Optional firstAttribute = CollectionUtils.firstElement((Object)profile.getAttribute(principalAttribute));
                    if (firstAttribute.isPresent()) {
                        id = firstAttribute.get().toString();
                        id = this.typePrincipalId(id, profile);
                    }
                    LOGGER.debug("Authentication indicates usage of client principal attribute [{}] for the identifier [{}]", (Object)principalAttribute, (Object)id);
                } else {
                    LOGGER.warn("Authentication cannot find attribute [{}] to use as principal id", (Object)principalAttribute);
                }
            } else {
                LOGGER.warn("No custom principal attribute was provided by the client [{}]. Using the default id [{}]", (Object)client, (Object)id);
            }
        } else if (StringUtils.isNotBlank((CharSequence)this.principalAttributeId)) {
            if (profile.containsAttribute(this.principalAttributeId)) {
                Optional firstAttribute = CollectionUtils.firstElement((Object)profile.getAttribute(this.principalAttributeId));
                if (firstAttribute.isPresent()) {
                    id = firstAttribute.get().toString();
                    id = this.typePrincipalId(id, profile);
                }
            } else {
                LOGGER.warn("CAS cannot use [{}] as the principal attribute id, since the profile attributes do not contain the attribute. Either adjust the CAS configuration to use a different attribute, or contact the authentication provider noted by [{}] to release the expected attribute to CAS", (Object)this.principalAttributeId, (Object)profile.getAttributes());
            }
            LOGGER.debug("Authentication indicates usage of attribute [{}] for the identifier [{}]", (Object)this.principalAttributeId, (Object)id);
        } else if (this.isTypedIdUsed) {
            id = profile.getTypedId();
            LOGGER.debug("Authentication indicates usage of typed profile id [{}]", (Object)id);
        }
        LOGGER.debug("Final principal id determined based on client [{}] and user profile [{}] is [{}]", new Object[]{profile, client, id});
        return id;
    }

    private String typePrincipalId(String id, UserProfile profile) {
        return this.isTypedIdUsed ? profile.getClass().getName() + "#" + id : id;
    }

    protected void storeUserProfile(WebContext webContext, UserProfile profile) {
        ProfileManager manager = new ProfileManager(webContext, this.sessionStore);
        manager.save(true, profile, false);
    }

    @Generated
    public void setPrincipalAttributeId(String principalAttributeId) {
        this.principalAttributeId = principalAttributeId;
    }

    @Generated
    public void setTypedIdUsed(boolean isTypedIdUsed) {
        this.isTypedIdUsed = isTypedIdUsed;
    }
}

