/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.accesstoken;

import com.nimbusds.jwt.JWTClaimsSet;
import java.util.List;
import java.util.Map;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.BasicIdentifiableCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.services.RegisteredServiceCipherExecutor;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.jose4j.jwt.JwtClaims;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class OAuth20JwtBuilder
extends JwtBuilder {
    public OAuth20JwtBuilder(CipherExecutor defaultTokenCipherExecutor, ConfigurableApplicationContext applicationContext, ServicesManager servicesManager, RegisteredServiceCipherExecutor registeredServiceCipherExecutor, CasConfigurationProperties casProperties, PrincipalResolver principalResolver, ServiceFactory serviceFactory) {
        super(defaultTokenCipherExecutor, (ApplicationContext)applicationContext, servicesManager, principalResolver, registeredServiceCipherExecutor, serviceFactory, casProperties);
    }

    protected RegisteredService locateRegisteredService(String id) {
        RegisteredService service = super.locateRegisteredService(id);
        if (service == null) {
            service = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.getServicesManager(), id);
        }
        return service;
    }

    protected JWTClaimsSet finalizeClaims(JWTClaimsSet claimsSet, JwtBuilder.JwtRequest payload) throws Exception {
        JwtClaims jwtClaims = JwtClaims.parse((String)claimsSet.toString());
        if (jwtClaims.hasClaim("scope") && jwtClaims.isClaimValueStringList("scope")) {
            jwtClaims.setClaim("scope", (Object)String.join((CharSequence)" ", jwtClaims.getStringListClaimValue("scope")));
        }
        return JWTClaimsSet.parse((Map)jwtClaims.getClaimsMap());
    }

    protected Map<String, List<Object>> collectClaims(JwtBuilder.JwtRequest payload) throws Throwable {
        Map currentClaims = super.collectClaims(payload);
        if (payload.isResolveSubject() && payload.getRegisteredService().isPresent()) {
            Principal principal = this.getPrincipalResolver().resolve((Credential)new BasicIdentifiableCredential(payload.getSubject()));
            RegisteredService registeredService = (RegisteredService)payload.getRegisteredService().get();
            RegisteredServiceAttributeReleasePolicyContext context = RegisteredServiceAttributeReleasePolicyContext.builder().principal(principal).service((Service)payload.getService().orElse(null)).registeredService(registeredService).applicationContext(this.getApplicationContext()).build();
            currentClaims.putAll(registeredService.getAttributeReleasePolicy().getAttributes(context));
        }
        return currentClaims;
    }
}

