/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi.resource;

import java.util.HashMap;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.model.core.audit.AuditEngineProperties;
import org.apereo.cas.util.AopUtils;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.aspectj.lang.JoinPoint;

public class TicketAsFirstParameterResourceResolver
implements AuditResourceResolver {
    protected final AuthenticationServiceSelectionPlan serviceSelectionStrategy;
    protected final AuditEngineProperties properties;

    public String[] resolveFrom(JoinPoint joinPoint, Object object) {
        Object[] arguments;
        JoinPoint jp = AopUtils.unWrapJoinPoint((JoinPoint)joinPoint);
        if (jp != null && (arguments = jp.getArgs()) != null) {
            Object ticket = arguments[0];
            AuditTrailManager.AuditFormats auditFormat = AuditTrailManager.AuditFormats.valueOf((String)this.properties.getAuditFormat().name());
            if (arguments.length >= 2) {
                Service service = (Service)arguments[1];
                HashMap<String, String> values = new HashMap<String, String>();
                values.put("ticket", ticket.toString());
                values.put("service", this.getServiceId(service));
                return new String[]{auditFormat.serialize(values)};
            }
            return new String[]{auditFormat.serialize((Object)ticket.toString())};
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public String[] resolveFrom(JoinPoint joinPoint, Exception object) {
        return this.resolveFrom(joinPoint, (Object)object);
    }

    private String getServiceId(Service service) {
        String serviceId = (String)FunctionUtils.doUnchecked(() -> this.serviceSelectionStrategy.resolveService(service).getId());
        return DigestUtils.abbreviate((String)serviceId, (int)this.properties.getAbbreviationLength());
    }

    @Generated
    public TicketAsFirstParameterResourceResolver(AuthenticationServiceSelectionPlan serviceSelectionStrategy, AuditEngineProperties properties) {
        this.serviceSelectionStrategy = serviceSelectionStrategy;
        this.properties = properties;
    }
}

