/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.fileinput.BootstrapFileInputField;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.fileinput.FileInputConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.TogglePanel;
import org.apache.syncope.client.console.rest.SAML2IdPsRestClient;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class ImportMetadata
extends TogglePanel<Serializable> {
    private static final long serialVersionUID = 6959177759869415782L;
    @SpringBean
    protected SAML2IdPsRestClient saml2IdPsRestClient;

    public ImportMetadata(String id, final WebMarkupContainer container, final PageReference pageRef) {
        super(id, pageRef);
        Form form = new Form("metadataForm");
        this.addInnerObject(new Component[]{form});
        FileInputConfig config = new FileInputConfig().showUpload(false).showRemove(false).showPreview(false).browseClass("btn btn-success").browseIcon("<i class=\"fas fa-folder-open\"></i> &nbsp;");
        String language = SyncopeConsoleSession.get().getLocale().getLanguage();
        if (!Locale.ENGLISH.getLanguage().equals(language)) {
            config.withLocale(language);
        }
        final BootstrapFileInputField fileUpload = new BootstrapFileInputField("fileUpload", (IModel)new ListModel(new ArrayList()), config);
        form.add(new Component[]{fileUpload.setOutputMarkupId(true)});
        form.add(new Component[]{new AjaxSubmitLink("doUpload", form){
            private static final long serialVersionUID = -7978723352517770644L;

            protected void onSubmit(AjaxRequestTarget target) {
                FileUpload uploaded = fileUpload.getFileUpload();
                if (uploaded != null) {
                    try {
                        ImportMetadata.this.saml2IdPsRestClient.importIdPs(uploaded.getInputStream());
                        SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                        ImportMetadata.this.toggle(target, false);
                        target.add(new Component[]{container});
                    }
                    catch (Exception e) {
                        TogglePanel.LOG.error("While importing SAML 2.0 IdP metadata", (Throwable)e);
                        SyncopeConsoleSession.get().onException(e);
                    }
                    ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                }
            }

            protected void onError(AjaxRequestTarget target) {
                ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }});
    }
}

