/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution;

import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.StateDefinition;
import org.springframework.webflow.definition.TransitionDefinition;
import org.springframework.webflow.execution.EnterStateVetoException;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.View;

public interface FlowExecutionListener {
    default public void requestSubmitted(RequestContext context) {
    }

    default public void requestProcessed(RequestContext context) {
    }

    default public void sessionCreating(RequestContext context, FlowDefinition definition) {
    }

    default public void sessionStarting(RequestContext context, FlowSession session, MutableAttributeMap<?> input) {
    }

    default public void sessionStarted(RequestContext context, FlowSession session) {
    }

    default public void eventSignaled(RequestContext context, Event event) {
    }

    default public void transitionExecuting(RequestContext context, TransitionDefinition transition) {
    }

    default public void stateEntering(RequestContext context, StateDefinition state) throws EnterStateVetoException {
    }

    default public void stateEntered(RequestContext context, StateDefinition previousState, StateDefinition state) {
    }

    default public void viewRendering(RequestContext context, View view, StateDefinition viewState) {
    }

    default public void viewRendered(RequestContext context, View view, StateDefinition viewState) {
    }

    default public void paused(RequestContext context) {
    }

    default public void resuming(RequestContext context) {
    }

    default public void sessionEnding(RequestContext context, FlowSession session, String outcome, MutableAttributeMap<?> output) {
    }

    default public void sessionEnded(RequestContext context, FlowSession session, String outcome, AttributeMap<?> output) {
    }

    default public void exceptionThrown(RequestContext context, FlowExecutionException exception) {
    }
}

