/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.sso.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.crypto.SignatureSigningParametersProvider;
import org.pac4j.saml.profile.impl.AbstractSAML2MessageSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2WebSSOMessageSender
extends AbstractSAML2MessageSender<AuthnRequest> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SAML2WebSSOMessageSender.class);

    public SAML2WebSSOMessageSender(SignatureSigningParametersProvider signatureSigningParametersProvider, String destinationBindingType, boolean signErrorResponses, boolean isAuthnRequestSigned) {
        super(signatureSigningParametersProvider, destinationBindingType, signErrorResponses, isAuthnRequestSigned);
    }

    @Override
    protected boolean mustSignRequest(SPSSODescriptor spDescriptor, IDPSSODescriptor idpssoDescriptor) {
        boolean signOutboundContext = false;
        if (this.isRequestSigned) {
            LOGGER.debug("Requests are expected to be always signed before submission");
            signOutboundContext = true;
        } else if (spDescriptor.isAuthnRequestsSigned().booleanValue()) {
            LOGGER.debug("The service provider metadata indicates that authn requests are signed");
            signOutboundContext = true;
        } else if (idpssoDescriptor.getWantAuthnRequestsSigned().booleanValue()) {
            LOGGER.debug("The identity provider metadata indicates that authn requests may be signed");
            signOutboundContext = true;
        }
        return signOutboundContext;
    }

    @Override
    protected Endpoint getEndpoint(SAML2MessageContext context) {
        return context.getIDPSingleSignOnService(this.destinationBindingType);
    }
}

