/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.crypto;

import net.shibboleth.shared.component.ComponentInitializationException;
import org.opensaml.saml.metadata.resolver.ChainingMetadataResolver;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.metadata.resolver.impl.PredicateRoleDescriptorResolver;
import org.opensaml.saml.security.impl.MetadataCredentialResolver;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;
import org.pac4j.saml.crypto.SAML2SignatureTrustEngineProvider;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.metadata.SAML2MetadataResolver;
import org.pac4j.saml.util.SAML2Utils;

public class ExplicitSignatureTrustEngineProvider
implements SAML2SignatureTrustEngineProvider {
    private final SAML2MetadataResolver idpMetadataResolver;
    private final SAML2MetadataResolver spMetadataResolver;

    public ExplicitSignatureTrustEngineProvider(SAML2MetadataResolver idpMetadataResolver, SAML2MetadataResolver spMetadataResolver) {
        this.idpMetadataResolver = idpMetadataResolver;
        this.spMetadataResolver = spMetadataResolver;
    }

    @Override
    public SignatureTrustEngine build() {
        MetadataCredentialResolver metadataCredentialResolver = new MetadataCredentialResolver();
        ChainingMetadataResolver metadataResolver = SAML2Utils.buildChainingMetadataResolver(this.idpMetadataResolver, this.spMetadataResolver);
        PredicateRoleDescriptorResolver roleResolver = new PredicateRoleDescriptorResolver((MetadataResolver)metadataResolver);
        KeyInfoCredentialResolver keyResolver = DefaultSecurityConfigurationBootstrap.buildBasicInlineKeyInfoCredentialResolver();
        metadataCredentialResolver.setKeyInfoCredentialResolver(keyResolver);
        metadataCredentialResolver.setRoleDescriptorResolver((RoleDescriptorResolver)roleResolver);
        try {
            metadataCredentialResolver.initialize();
            roleResolver.initialize();
        }
        catch (ComponentInitializationException e) {
            throw new SAMLException(e);
        }
        return new ExplicitKeySignatureTrustEngine((CredentialResolver)metadataCredentialResolver, keyResolver);
    }
}

