/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.syncope.ext.openfga.client.ApiClient;
import org.apache.syncope.ext.openfga.client.model.Condition;
import org.apache.syncope.ext.openfga.client.model.TypeDefinition;

@JsonPropertyOrder(value={"type_definitions", "schema_version", "conditions"})
public class WriteAuthorizationModelRequest {
    public static final String JSON_PROPERTY_TYPE_DEFINITIONS = "type_definitions";
    @Nonnull
    private List<TypeDefinition> typeDefinitions = new ArrayList<TypeDefinition>();
    public static final String JSON_PROPERTY_SCHEMA_VERSION = "schema_version";
    @Nonnull
    private String schemaVersion;
    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    @Nullable
    private Map<String, Condition> conditions = new HashMap<String, Condition>();

    public WriteAuthorizationModelRequest typeDefinitions(@Nonnull List<TypeDefinition> typeDefinitions) {
        this.typeDefinitions = typeDefinitions;
        return this;
    }

    public WriteAuthorizationModelRequest addTypeDefinitionsItem(TypeDefinition typeDefinitionsItem) {
        if (this.typeDefinitions == null) {
            this.typeDefinitions = new ArrayList<TypeDefinition>();
        }
        this.typeDefinitions.add(typeDefinitionsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="type_definitions", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<TypeDefinition> getTypeDefinitions() {
        return this.typeDefinitions;
    }

    @JsonProperty(value="type_definitions", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTypeDefinitions(@Nonnull List<TypeDefinition> typeDefinitions) {
        this.typeDefinitions = typeDefinitions;
    }

    public WriteAuthorizationModelRequest schemaVersion(@Nonnull String schemaVersion) {
        this.schemaVersion = schemaVersion;
        return this;
    }

    @Nonnull
    @JsonProperty(value="schema_version", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="schema_version", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSchemaVersion(@Nonnull String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public WriteAuthorizationModelRequest conditions(@Nullable Map<String, Condition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public WriteAuthorizationModelRequest putConditionsItem(String key, Condition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new HashMap<String, Condition>();
        }
        this.conditions.put(key, conditionsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="conditions", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Condition> getConditions() {
        return this.conditions;
    }

    @JsonProperty(value="conditions", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConditions(@Nullable Map<String, Condition> conditions) {
        this.conditions = conditions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteAuthorizationModelRequest writeAuthorizationModelRequest = (WriteAuthorizationModelRequest)o;
        return Objects.equals(this.typeDefinitions, writeAuthorizationModelRequest.typeDefinitions) && Objects.equals(this.schemaVersion, writeAuthorizationModelRequest.schemaVersion) && Objects.equals(this.conditions, writeAuthorizationModelRequest.conditions);
    }

    public int hashCode() {
        return Objects.hash(this.typeDefinitions, this.schemaVersion, this.conditions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WriteAuthorizationModelRequest {\n");
        sb.append("    typeDefinitions: ").append(this.toIndentedString(this.typeDefinitions)).append("\n");
        sb.append("    schemaVersion: ").append(this.toIndentedString(this.schemaVersion)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getTypeDefinitions() != null) {
            for (int i = 0; i < this.getTypeDefinitions().size(); ++i) {
                if (this.getTypeDefinitions().get(i) == null) continue;
                joiner.add(this.getTypeDefinitions().get(i).toUrlQueryString(String.format(Locale.ROOT, "%stype_definitions%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format(Locale.ROOT, "%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getSchemaVersion() != null) {
            joiner.add(String.format(Locale.ROOT, "%sschema_version%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getSchemaVersion()))));
        }
        if (this.getConditions() != null) {
            for (String _key : this.getConditions().keySet()) {
                if (this.getConditions().get(_key) == null) continue;
                joiner.add(this.getConditions().get(_key).toUrlQueryString(String.format(Locale.ROOT, "%sconditions%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format(Locale.ROOT, "%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

