/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

// NOTE: Targeted import (as opposed to `import *`) is important here for proper tree-shaking
// eslint-disable-next-line no-restricted-imports
import {
  AlignCenterOutlined,
  AlignLeftOutlined,
  AlignRightOutlined,
  ApartmentOutlined,
  AppstoreOutlined,
  AreaChartOutlined,
  ArrowRightOutlined,
  ArrowsAltOutlined,
  BarChartOutlined,
  BellOutlined,
  BgColorsOutlined,
  BookOutlined,
  BugOutlined,
  BulbOutlined,
  CalculatorOutlined,
  CaretUpOutlined,
  CaretDownOutlined,
  CaretLeftOutlined,
  CaretRightOutlined,
  CaretRightFilled,
  CalendarOutlined,
  CheckOutlined,
  CheckCircleOutlined,
  CheckCircleFilled,
  CheckSquareOutlined,
  ClearOutlined,
  CloseOutlined,
  CloseCircleOutlined,
  ClockCircleOutlined,
  ColumnHeightOutlined,
  ColumnWidthOutlined,
  CommentOutlined,
  ConsoleSqlOutlined,
  CopyOutlined,
  DashboardOutlined,
  DatabaseOutlined,
  DeleteFilled,
  DownSquareOutlined,
  DeleteOutlined,
  DownOutlined,
  DownloadOutlined,
  EditOutlined,
  EllipsisOutlined,
  ExclamationCircleOutlined,
  ExclamationCircleFilled,
  ExpandOutlined,
  EyeOutlined,
  EyeInvisibleOutlined,
  FallOutlined,
  FieldNumberOutlined,
  FieldTimeOutlined,
  FileImageOutlined,
  FileMarkdownOutlined,
  FileOutlined,
  FileTextOutlined,
  FireOutlined,
  FormOutlined,
  FullscreenExitOutlined,
  FullscreenOutlined,
  FundProjectionScreenOutlined,
  FunctionOutlined,
  HighlightOutlined,
  InfoCircleOutlined,
  InfoCircleFilled,
  InsertRowAboveOutlined,
  InsertRowBelowOutlined,
  LineChartOutlined,
  LineOutlined,
  LinkOutlined,
  MailOutlined,
  MenuOutlined,
  MenuFoldOutlined,
  MenuUnfoldOutlined,
  MinusCircleOutlined,
  MoonOutlined,
  LoadingOutlined,
  LoginOutlined,
  MonitorOutlined,
  MoreOutlined,
  OrderedListOutlined,
  PieChartOutlined,
  PicCenterOutlined,
  PlusCircleOutlined,
  PlusOutlined,
  QuestionCircleOutlined,
  ReloadOutlined,
  RightOutlined,
  SaveOutlined,
  SearchOutlined,
  SettingOutlined,
  ShareAltOutlined,
  StarOutlined,
  StarFilled,
  StopOutlined,
  SunOutlined,
  SyncOutlined,
  TagOutlined,
  TagsOutlined,
  TableOutlined,
  LockOutlined,
  UnlockOutlined,
  UploadOutlined,
  UpOutlined,
  UserAddOutlined,
  UsergroupAddOutlined,
  UserOutlined,
  VerticalAlignBottomOutlined,
  VerticalAlignTopOutlined,
  VerticalLeftOutlined,
  VerticalRightOutlined,
  NumberOutlined,
  ThunderboltOutlined,
  FacebookOutlined,
  FilterOutlined,
  FontColorsOutlined,
  UnorderedListOutlined,
  WarningOutlined,
  SortAscendingOutlined,
  KeyOutlined,
  GithubOutlined,
  GoogleOutlined,
  DesktopOutlined,
  FormatPainterOutlined,
  ExportOutlined,
  CompressOutlined,
  HistoryOutlined,
  SlackOutlined,
} from '@ant-design/icons';
import { FC } from 'react';
import { IconType } from './types';
import { BaseIconComponent } from './BaseIcon';

// partial name matches work too
const EXCLUDED_ICONS = ['TwoTone'];

const AntdIcons = {
  AlignCenterOutlined,
  AlignLeftOutlined,
  AlignRightOutlined,
  ApartmentOutlined,
  AppstoreOutlined,
  AreaChartOutlined,
  ArrowRightOutlined,
  ArrowsAltOutlined,
  BarChartOutlined,
  BgColorsOutlined,
  BellOutlined,
  BookOutlined,
  BugOutlined,
  BulbOutlined,
  CalculatorOutlined,
  CaretUpOutlined,
  CaretDownOutlined,
  CaretLeftOutlined,
  CaretRightOutlined,
  CaretRightFilled,
  CalendarOutlined,
  CheckOutlined,
  CheckCircleOutlined,
  CheckCircleFilled,
  CheckSquareOutlined,
  ClearOutlined,
  CloseOutlined,
  CloseCircleOutlined,
  ClockCircleOutlined,
  ColumnHeightOutlined,
  ColumnWidthOutlined,
  CommentOutlined,
  ConsoleSqlOutlined,
  CopyOutlined,
  DashboardOutlined,
  DatabaseOutlined,
  DeleteFilled,
  DownSquareOutlined,
  DeleteOutlined,
  DownOutlined,
  DownloadOutlined,
  EditOutlined,
  EllipsisOutlined,
  ExclamationCircleOutlined,
  ExclamationCircleFilled,
  ExpandOutlined,
  EyeOutlined,
  EyeInvisibleOutlined,
  FacebookOutlined,
  FallOutlined,
  FieldNumberOutlined,
  FieldTimeOutlined,
  FileImageOutlined,
  FileMarkdownOutlined,
  FileOutlined,
  FileTextOutlined,
  FireOutlined,
  FormOutlined,
  FullscreenExitOutlined,
  FullscreenOutlined,
  FundProjectionScreenOutlined,
  FunctionOutlined,
  GithubOutlined,
  GoogleOutlined,
  HighlightOutlined,
  InfoCircleOutlined,
  InfoCircleFilled,
  InsertRowAboveOutlined,
  InsertRowBelowOutlined,
  LineChartOutlined,
  LineOutlined,
  LinkOutlined,
  LoadingOutlined,
  LoginOutlined,
  MailOutlined,
  MenuOutlined,
  MenuFoldOutlined,
  MenuUnfoldOutlined,
  MinusCircleOutlined,
  MonitorOutlined,
  MoonOutlined,
  MoreOutlined,
  OrderedListOutlined,
  PieChartOutlined,
  PicCenterOutlined,
  PlusCircleOutlined,
  PlusOutlined,
  ReloadOutlined,
  QuestionCircleOutlined,
  RightOutlined,
  SaveOutlined,
  SearchOutlined,
  SettingOutlined,
  ShareAltOutlined,
  SunOutlined,
  StarOutlined,
  StarFilled,
  StopOutlined,
  SyncOutlined,
  TagOutlined,
  TagsOutlined,
  TableOutlined,
  LockOutlined,
  UploadOutlined,
  UnlockOutlined,
  UpOutlined,
  UserAddOutlined,
  UsergroupAddOutlined,
  UserOutlined,
  VerticalAlignBottomOutlined,
  VerticalAlignTopOutlined,
  VerticalLeftOutlined,
  VerticalRightOutlined,
  NumberOutlined,
  ThunderboltOutlined,
  FilterOutlined,
  FontColorsOutlined,
  UnorderedListOutlined,
  WarningOutlined,
  SortAscendingOutlined,
  KeyOutlined,
  DesktopOutlined,
  FormatPainterOutlined,
  ExportOutlined,
  CompressOutlined,
  HistoryOutlined,
  SlackOutlined,
} as const;

type AntdIconNames = keyof typeof AntdIcons;

export const antdEnhancedIcons: Record<
  AntdIconNames,
  FC<IconType>
> = Object.keys(AntdIcons)
  .filter(key => !EXCLUDED_ICONS.some(excluded => key.includes(excluded)))
  .reduce(
    (acc, key) => {
      acc[key as AntdIconNames] = (props: IconType) => (
        <BaseIconComponent
          component={AntdIcons[key as AntdIconNames]}
          fileName={key}
          {...props}
        />
      );
      return acc;
    },
    {} as Record<AntdIconNames, FC<IconType>>,
  );
