/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.authentication;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Date;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.streampark.console.core.enums.AuthenticationType;
import org.apache.streampark.console.system.authentication.JWTSecret;
import org.apache.streampark.console.system.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTUtil {
    private static final Logger log = LoggerFactory.getLogger(JWTUtil.class);
    private static Long ttlOfSecond;
    private static final String ALGORITHM = "AES/GCM/NoPadding";
    private static final int GCM_TAG_LENGTH = 128;
    private static final int GCM_IV_LENGTH = 12;
    private static final String JWT_USERID = "userId";
    private static final String JWT_USERNAME = "userName";
    private static final String JWT_TYPE = "type";
    private static final String JWT_TIMESTAMP = "timestamp";
    private static byte[] jetKey;

    public static String getUserName(String token) {
        DecodedJWT jwt = JWTUtil.decode(token);
        return jwt != null ? jwt.getClaim(JWT_USERNAME).asString() : null;
    }

    public static Long getUserId(String token) {
        DecodedJWT jwt = JWTUtil.decode(token);
        return jwt != null ? jwt.getClaim(JWT_USERID).asLong() : null;
    }

    public static Long getTimestamp(String token) {
        DecodedJWT jwt = JWTUtil.decode(token);
        return jwt != null ? jwt.getClaim(JWT_TIMESTAMP).asLong() : 0L;
    }

    public static AuthenticationType getAuthType(String token) {
        DecodedJWT jwt = JWTUtil.decode(token);
        if (jwt == null) {
            return null;
        }
        int type = jwt.getClaim(JWT_TYPE).asInt();
        return AuthenticationType.of(type);
    }

    public static String sign(User user, AuthenticationType authType) throws Exception {
        long second = JWTUtil.getTTLOfSecond() * 1000L;
        Long ttl = System.currentTimeMillis() + second;
        return JWTUtil.sign(user, authType, ttl);
    }

    public static String sign(User user, AuthenticationType authType, Long expireTime) throws Exception {
        Date date = new Date(expireTime);
        Algorithm algorithm = Algorithm.HMAC256((byte[])jetKey);
        JWTCreator.Builder builder = JWT.create().withClaim(JWT_USERID, user.getUserId()).withClaim(JWT_USERNAME, user.getUsername()).withClaim(JWT_TYPE, Integer.valueOf(authType.get())).withExpiresAt(date);
        if (authType == AuthenticationType.SIGN) {
            builder.withClaim(JWT_TIMESTAMP, Long.valueOf(System.currentTimeMillis()));
        }
        String token = builder.sign(algorithm);
        return JWTUtil.encrypt(token);
    }

    public static Long getTTLOfSecond() {
        if (ttlOfSecond == null) {
            String ttl = System.getProperty("server.session.ttl", "24h").trim();
            String regexp = "^\\d+([smhd])$";
            Pattern pattern = Pattern.compile(regexp);
            if (!pattern.matcher(ttl).matches()) {
                throw new IllegalArgumentException("server.session.ttl is invalid, Time units must be [s|m|h|d], e.g: 24h, 2d... please check config.yaml ");
            }
            String unit = ttl.substring(ttl.length() - 1);
            String time = ttl.substring(0, ttl.length() - 1);
            long second = Long.parseLong(time);
            switch (unit) {
                case "m": {
                    ttlOfSecond = second * 60L;
                    return ttlOfSecond;
                }
                case "h": {
                    ttlOfSecond = second * 60L * 60L;
                    return ttlOfSecond;
                }
                case "d": {
                    ttlOfSecond = second * 24L * 60L * 60L;
                    return ttlOfSecond;
                }
            }
            ttlOfSecond = second;
            return ttlOfSecond;
        }
        return ttlOfSecond;
    }

    private static DecodedJWT decode(String token) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((byte[])jetKey);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).build();
            return verifier.verify(token);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean verify(String token) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((byte[])jetKey);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).build();
            verifier.verify(token);
            return true;
        }
        catch (Exception e) {
            log.warn("Invalid JWT: {}", (Object)e.getMessage());
            return false;
        }
    }

    public static String encrypt(String content) throws Exception {
        byte[] iv = new byte[12];
        SecureRandom.getInstanceStrong().nextBytes(iv);
        SecretKeySpec keySpec = new SecretKeySpec(jetKey, "AES");
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, (Key)keySpec, new GCMParameterSpec(128, iv));
        byte[] encrypted = cipher.doFinal(content.getBytes(StandardCharsets.UTF_8));
        ByteBuffer buffer = ByteBuffer.allocate(iv.length + encrypted.length);
        buffer.put(iv);
        buffer.put(encrypted);
        return Base64.getEncoder().encodeToString(buffer.array());
    }

    public static String decrypt(String content) throws Exception {
        byte[] data = Base64.getDecoder().decode(content);
        ByteBuffer buffer = ByteBuffer.wrap(data);
        byte[] iv = new byte[12];
        buffer.get(iv);
        byte[] encrypted = new byte[buffer.remaining()];
        buffer.get(encrypted);
        SecretKeySpec keySpec = new SecretKeySpec(jetKey, "AES");
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        GCMParameterSpec spec = new GCMParameterSpec(128, iv);
        cipher.init(2, (Key)keySpec, spec);
        return new String(cipher.doFinal(encrypted), StandardCharsets.UTF_8);
    }

    static {
        jetKey = JWTSecret.getJWTSecret();
    }
}

