/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.OptionalLong;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.KeyedStateStore;
import org.apache.flink.api.common.state.OperatorStateStore;
import org.apache.flink.runtime.state.KeyGroupStatePartitionStreamProvider;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StatePartitionStreamProvider;

public class StateInitializationContextImpl
implements StateInitializationContext {
    @Nullable
    private final Long restoredCheckpointId;
    private final OperatorStateStore operatorStateStore;
    private final KeyedStateStore keyedStateStore;
    private final Iterable<KeyGroupStatePartitionStreamProvider> rawKeyedStateInputs;
    private final Iterable<StatePartitionStreamProvider> rawOperatorStateInputs;

    public StateInitializationContextImpl(@Nullable Long restoredCheckpointId, OperatorStateStore operatorStateStore, KeyedStateStore keyedStateStore, Iterable<KeyGroupStatePartitionStreamProvider> rawKeyedStateInputs, Iterable<StatePartitionStreamProvider> rawOperatorStateInputs) {
        this.restoredCheckpointId = restoredCheckpointId;
        this.operatorStateStore = operatorStateStore;
        this.keyedStateStore = keyedStateStore;
        this.rawOperatorStateInputs = rawOperatorStateInputs;
        this.rawKeyedStateInputs = rawKeyedStateInputs;
    }

    @Override
    public boolean isRestored() {
        return this.restoredCheckpointId != null;
    }

    @Override
    public OptionalLong getRestoredCheckpointId() {
        return this.restoredCheckpointId == null ? OptionalLong.empty() : OptionalLong.of(this.restoredCheckpointId);
    }

    @Override
    public Iterable<StatePartitionStreamProvider> getRawOperatorStateInputs() {
        return this.rawOperatorStateInputs;
    }

    @Override
    public Iterable<KeyGroupStatePartitionStreamProvider> getRawKeyedStateInputs() {
        if (null == this.keyedStateStore) {
            throw new IllegalStateException("Attempt to access keyed state from non-keyed operator.");
        }
        return this.rawKeyedStateInputs;
    }

    @Override
    public OperatorStateStore getOperatorStateStore() {
        return this.operatorStateStore;
    }

    @Override
    public KeyedStateStore getKeyedStateStore() {
        return this.keyedStateStore;
    }
}

