/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.task;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.streampark.common.util.CommandUtils;
import org.apache.streampark.common.util.Utils;
import org.apache.streampark.console.base.util.GitUtils;
import org.apache.streampark.console.core.entity.Project;
import org.apache.streampark.console.core.enums.BuildState;
import org.apache.streampark.console.core.task.AbstractLogFileTask;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.StoredConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectBuildTask
extends AbstractLogFileTask {
    private static final Logger log = LoggerFactory.getLogger(ProjectBuildTask.class);
    final Project project;
    final Consumer<BuildState> stateUpdateConsumer;
    final Consumer<ch.qos.logback.classic.Logger> notifyReleaseConsumer;

    public ProjectBuildTask(String logPath, Project project, Consumer<BuildState> stateUpdateConsumer, Consumer<ch.qos.logback.classic.Logger> notifyReleaseConsumer) {
        super(logPath, true);
        this.project = project;
        this.stateUpdateConsumer = stateUpdateConsumer;
        this.notifyReleaseConsumer = notifyReleaseConsumer;
    }

    @Override
    protected void doRun() throws Throwable {
        log.info("Project {} start build", (Object)this.project.getName());
        this.fileLogger.info(this.project.getLog4BuildStart());
        boolean cloneSuccess = this.cloneSourceCode(this.project);
        if (!cloneSuccess) {
            this.fileLogger.error("[StreamPark] clone or pull error.");
            this.stateUpdateConsumer.accept(BuildState.FAILED);
            return;
        }
        boolean build = this.projectBuild(this.project);
        if (!build) {
            this.stateUpdateConsumer.accept(BuildState.FAILED);
            this.fileLogger.error("build error, project name: {} ", (Object)this.project.getName());
            return;
        }
        this.stateUpdateConsumer.accept(BuildState.SUCCESSFUL);
        this.deploy(this.project);
        this.notifyReleaseConsumer.accept(this.fileLogger);
    }

    @Override
    protected void processException(Throwable t) {
        this.stateUpdateConsumer.accept(BuildState.FAILED);
        this.fileLogger.error("Build error, project name: {}", (Object)this.project.getName(), (Object)t);
    }

    @Override
    protected void doFinally() {
    }

    private boolean cloneSourceCode(Project project) {
        try {
            project.cleanCloned();
            this.fileLogger.info("clone {}, {} starting...", (Object)project.getName(), (Object)project.getUrl());
            this.fileLogger.info(project.getLog4CloneStart());
            Git git = GitUtils.clone(project);
            StoredConfig config = git.getRepository().getConfig();
            config.setBoolean("http", project.getUrl(), "sslVerify", false);
            config.setBoolean("https", project.getUrl(), "sslVerify", false);
            config.save();
            File workTree = git.getRepository().getWorkTree();
            this.printWorkTree(workTree, "");
            String successMsg = String.format("[StreamPark] project [%s] git clone successful!\n", project.getName());
            this.fileLogger.info(successMsg);
            git.close();
            return true;
        }
        catch (Exception e) {
            this.fileLogger.error(String.format("[StreamPark] project [%s] branch [%s] git clone failure, err: %s", project.getName(), project.getBranches(), e));
            this.fileLogger.error(String.format("project %s clone error ", project.getName()), (Throwable)e);
            return false;
        }
    }

    private void printWorkTree(File workTree, String space) {
        File[] files = workTree.listFiles();
        for (File file : Objects.requireNonNull(files)) {
            if (!file.getName().startsWith(".git")) continue;
            if (file.isFile()) {
                this.fileLogger.info("{} / {}", (Object)space, (Object)file.getName());
                continue;
            }
            if (!file.isDirectory()) continue;
            this.fileLogger.info("{} / {}", (Object)space, (Object)file.getName());
            this.printWorkTree(file, space.concat("/").concat(file.getName()));
        }
    }

    private boolean projectBuild(Project project) {
        int code = CommandUtils.execute((String)project.getMavenWorkHome(), Collections.singletonList(project.getMavenArgs()), line -> this.fileLogger.info(line));
        return code == 0;
    }

    private void deploy(Project project) throws Exception {
        File path = project.getAppSource();
        ArrayList<File> apps = new ArrayList<File>();
        this.findTarOrJar(apps, path);
        if (apps.isEmpty()) {
            throw new RuntimeException("[StreamPark] can't find tar.gz or jar in " + path.getAbsolutePath());
        }
        for (File app : apps) {
            String appPath = app.getAbsolutePath();
            if (appPath.endsWith("tar.gz")) {
                File deployPath = project.getDistHome();
                if (!deployPath.exists()) {
                    deployPath.mkdirs();
                }
                if (!app.exists()) continue;
                String cmd = String.format("tar -xzvf %s -C %s", app.getAbsolutePath(), deployPath.getAbsolutePath());
                CommandUtils.execute((String)cmd);
                continue;
            }
            Utils.checkJarFile((URL)app.toURI().toURL());
            String moduleName = app.getName().replace(".jar", "");
            File distHome = project.getDistHome();
            File targetDir = new File(distHome, moduleName);
            if (!targetDir.exists()) {
                targetDir.mkdirs();
            }
            File targetJar = new File(targetDir, app.getName());
            app.renameTo(targetJar);
        }
    }

    private void findTarOrJar(List<File> list, File path) {
        for (File file : Objects.requireNonNull(path.listFiles())) {
            if (file.isDirectory() && "target".equals(file.getName())) {
                File target;
                File tar = null;
                File jar = null;
                for (File targetFile : Objects.requireNonNull(file.listFiles())) {
                    if (targetFile.getName().endsWith("tar.gz")) {
                        tar = targetFile;
                        break;
                    }
                    if (targetFile.getName().startsWith("original-") || targetFile.getName().endsWith("-sources.jar") || !targetFile.getName().endsWith(".jar")) continue;
                    if (jar == null) {
                        jar = targetFile;
                        continue;
                    }
                    if (targetFile.length() <= jar.length()) continue;
                    jar = targetFile;
                }
                File file2 = target = tar == null ? jar : tar;
                if (target == null) {
                    this.fileLogger.warn("[StreamPark] can't find tar.gz or jar in {}", (Object)file.getAbsolutePath());
                } else {
                    list.add(target);
                }
            }
            if (!file.isDirectory()) continue;
            this.findTarOrJar(list, file);
        }
    }
}

