/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.metrics;

import org.apache.flink.api.common.JobStatus;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.runtime.executiongraph.JobStatusProvider;
import org.apache.flink.util.Preconditions;

public class RestartTimeGauge
implements Gauge<Long> {
    public static final String METRIC_NAME = "restartingTime";
    private final JobStatusProvider jobStatusProvider;

    public RestartTimeGauge(JobStatusProvider jobStatusProvider) {
        this.jobStatusProvider = (JobStatusProvider)Preconditions.checkNotNull((Object)jobStatusProvider);
    }

    public Long getValue() {
        JobStatus status = this.jobStatusProvider.getState();
        long restartingTimestamp = this.jobStatusProvider.getStatusTimestamp(JobStatus.RESTARTING);
        if (restartingTimestamp <= 0L) {
            return 0L;
        }
        long switchToRunningTimestamp = this.jobStatusProvider.getStatusTimestamp(JobStatus.RUNNING);
        long lastRestartTime = switchToRunningTimestamp >= restartingTimestamp ? switchToRunningTimestamp - restartingTimestamp : (status.isTerminalState() ? this.jobStatusProvider.getStatusTimestamp(status) - restartingTimestamp : System.currentTimeMillis() - restartingTimestamp);
        return Math.max(lastRestartTime, 0L);
    }
}

