/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.IOException;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.io.BinaryOutputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.InputTypeConfigurable;
import org.apache.flink.core.memory.DataOutputView;

@PublicEvolving
public class TypeSerializerOutputFormat<T>
extends BinaryOutputFormat<T>
implements InputTypeConfigurable {
    private static final long serialVersionUID = -6653022644629315158L;
    private TypeSerializer<T> serializer;

    protected void serialize(T record, DataOutputView dataOutput) throws IOException {
        if (this.serializer == null) {
            throw new RuntimeException("TypeSerializerOutputFormat requires a type serializer to be defined.");
        }
        this.serializer.serialize(record, dataOutput);
    }

    public void setSerializer(TypeSerializer<T> serializer) {
        this.serializer = serializer;
    }

    public void setInputType(TypeInformation<?> type, ExecutionConfig executionConfig) {
        this.serializer = type.createSerializer(executionConfig);
    }
}

