/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.translators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.graph.SimpleTransformationTranslator;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.TransformationTranslator;
import org.apache.flink.streaming.api.transformations.PartitionTransformation;
import org.apache.flink.util.Preconditions;

@Internal
public class PartitionTransformationTranslator<OUT>
extends SimpleTransformationTranslator<OUT, PartitionTransformation<OUT>> {
    @Override
    protected Collection<Integer> translateForBatchInternal(PartitionTransformation<OUT> transformation, TransformationTranslator.Context context) {
        return this.translateInternal(transformation, context);
    }

    @Override
    protected Collection<Integer> translateForStreamingInternal(PartitionTransformation<OUT> transformation, TransformationTranslator.Context context) {
        return this.translateInternal(transformation, context);
    }

    private Collection<Integer> translateInternal(PartitionTransformation<OUT> transformation, TransformationTranslator.Context context) {
        Preconditions.checkNotNull(transformation);
        Preconditions.checkNotNull((Object)context);
        StreamGraph streamGraph = context.getStreamGraph();
        List<Transformation<?>> parentTransformations = transformation.getInputs();
        Preconditions.checkState((parentTransformations.size() == 1 ? 1 : 0) != 0, (Object)("Expected exactly one input transformation but found " + parentTransformations.size()));
        Transformation<?> input = parentTransformations.get(0);
        ArrayList<Integer> resultIds = new ArrayList<Integer>();
        for (Integer inputId : context.getStreamNodeIds(input)) {
            int virtualId = Transformation.getNewNodeId();
            streamGraph.addVirtualPartitionNode(inputId, virtualId, transformation.getPartitioner(), transformation.getExchangeMode());
            resultIds.add(virtualId);
        }
        return resultIds;
    }
}

