/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.org.fusesource.jansi.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;

public class OSInfo {
    private static final HashMap<String, String> archMapping = new HashMap();

    public static String getNativeLibFolderPathForCurrentOS() {
        return OSInfo.getOSName() + "/" + OSInfo.getArchName();
    }

    public static String getOSName() {
        return OSInfo.translateOSNameToFolderName(System.getProperty("os.name"));
    }

    public static boolean isAndroid() {
        return System.getProperty("java.runtime.name", "").toLowerCase().contains("android");
    }

    static String getHardwareName() {
        String string;
        Process p = Runtime.getRuntime().exec("uname -m");
        p.waitFor();
        InputStream in = p.getInputStream();
        try {
            string = OSInfo.readFully(in);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (Throwable e) {
                System.err.println("Error while running uname -m: " + e.getMessage());
                return "unknown";
            }
        }
        in.close();
        return string;
    }

    private static String readFully(InputStream in) throws IOException {
        int readLen = 0;
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        byte[] buf = new byte[32];
        while ((readLen = in.read(buf, 0, buf.length)) >= 0) {
            b.write(buf, 0, readLen);
        }
        return b.toString();
    }

    static String resolveArmArchType() {
        if (System.getProperty("os.name").contains("Linux")) {
            String armType = OSInfo.getHardwareName();
            if (armType.startsWith("armv6")) {
                return "armv6";
            }
            if (armType.startsWith("armv7")) {
                return "armv7";
            }
            if (armType.startsWith("armv5")) {
                return "arm";
            }
            if (armType.equals("aarch64")) {
                return "arm64";
            }
            String abi = System.getProperty("sun.arch.abi");
            if (abi != null && abi.startsWith("gnueabihf")) {
                return "armv7";
            }
        }
        return "arm";
    }

    public static String getArchName() {
        String osArch = System.getProperty("os.arch");
        if (OSInfo.isAndroid()) {
            return "android-arm";
        }
        if (osArch.startsWith("arm")) {
            osArch = OSInfo.resolveArmArchType();
        } else {
            String lc = osArch.toLowerCase(Locale.US);
            if (archMapping.containsKey(lc)) {
                return archMapping.get(lc);
            }
        }
        return OSInfo.translateArchNameToFolderName(osArch);
    }

    static String translateOSNameToFolderName(String osName) {
        if (osName.contains("Windows")) {
            return "Windows";
        }
        if (osName.contains("Mac") || osName.contains("Darwin")) {
            return "Mac";
        }
        if (osName.contains("Linux")) {
            return "Linux";
        }
        if (osName.contains("AIX")) {
            return "AIX";
        }
        return osName.replaceAll("\\W", "");
    }

    static String translateArchNameToFolderName(String archName) {
        return archName.replaceAll("\\W", "");
    }

    static {
        archMapping.put("x86", "x86");
        archMapping.put("i386", "x86");
        archMapping.put("i486", "x86");
        archMapping.put("i586", "x86");
        archMapping.put("i686", "x86");
        archMapping.put("pentium", "x86");
        archMapping.put("x86_64", "x86_64");
        archMapping.put("amd64", "x86_64");
        archMapping.put("em64t", "x86_64");
        archMapping.put("universal", "x86_64");
        archMapping.put("ia64", "ia64");
        archMapping.put("ia64w", "ia64");
        archMapping.put("ia64_32", "ia64_32");
        archMapping.put("ia64n", "ia64_32");
        archMapping.put("ppc", "ppc");
        archMapping.put("power", "ppc");
        archMapping.put("powerpc", "ppc");
        archMapping.put("power_pc", "ppc");
        archMapping.put("power_rs", "ppc");
        archMapping.put("ppc64", "ppc64");
        archMapping.put("power64", "ppc64");
        archMapping.put("powerpc64", "ppc64");
        archMapping.put("power_pc64", "ppc64");
        archMapping.put("power_rs64", "ppc64");
        archMapping.put("aarch64", "arm64");
    }
}

