% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{freqItems}
\alias{freqItems}
\alias{freqItems,SparkDataFrame,character-method}
\title{Finding frequent items for columns, possibly with false positives}
\usage{
\S4method{freqItems}{SparkDataFrame,character}(x, cols, support = 0.01)
}
\arguments{
\item{x}{A SparkDataFrame.}

\item{cols}{A vector column names to search frequent items in.}

\item{support}{(Optional) The minimum frequency for an item to be considered \code{frequent}.
Should be greater than 1e-4. Default support = 0.01.}
}
\value{
a local R data.frame with the frequent items in each column
}
\description{
Finding frequent items for columns, possibly with false positives.
Using the frequent element count algorithm described in
\url{https://dl.acm.org/doi/10.1145/762471.762473}, proposed by Karp, Schenker,
and Papadimitriou.
}
\note{
freqItems since 1.6.0
}
\examples{
\dontrun{
df <- read.json("/path/to/file.json")
fi = freqItems(df, c("title", "gender"))
}
}
\seealso{
Other stat functions: 
\code{\link{approxQuantile}()},
\code{\link{corr}()},
\code{\link{cov}()},
\code{\link{crosstab}()},
\code{\link{sampleBy}()}
}
\concept{stat functions}
