#
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class StorageLevel(google.protobuf.message.Message):
    """StorageLevel for persisting Datasets/Tables."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USE_DISK_FIELD_NUMBER: builtins.int
    USE_MEMORY_FIELD_NUMBER: builtins.int
    USE_OFF_HEAP_FIELD_NUMBER: builtins.int
    DESERIALIZED_FIELD_NUMBER: builtins.int
    REPLICATION_FIELD_NUMBER: builtins.int
    use_disk: builtins.bool
    """(Required) Whether the cache should use disk or not."""
    use_memory: builtins.bool
    """(Required) Whether the cache should use memory or not."""
    use_off_heap: builtins.bool
    """(Required) Whether the cache should use off-heap or not."""
    deserialized: builtins.bool
    """(Required) Whether the cached data is deserialized or not."""
    replication: builtins.int
    """(Required) The number of replicas."""
    def __init__(
        self,
        *,
        use_disk: builtins.bool = ...,
        use_memory: builtins.bool = ...,
        use_off_heap: builtins.bool = ...,
        deserialized: builtins.bool = ...,
        replication: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "deserialized",
            b"deserialized",
            "replication",
            b"replication",
            "use_disk",
            b"use_disk",
            "use_memory",
            b"use_memory",
            "use_off_heap",
            b"use_off_heap",
        ],
    ) -> None: ...

global___StorageLevel = StorageLevel

class ResourceInformation(google.protobuf.message.Message):
    """ResourceInformation to hold information about a type of Resource.
    The corresponding class is 'org.apache.spark.resource.ResourceInformation'
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    ADDRESSES_FIELD_NUMBER: builtins.int
    name: builtins.str
    """(Required) The name of the resource"""
    @property
    def addresses(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """(Required) An array of strings describing the addresses of the resource."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        addresses: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["addresses", b"addresses", "name", b"name"]
    ) -> None: ...

global___ResourceInformation = ResourceInformation

class ExecutorResourceRequest(google.protobuf.message.Message):
    """An executor resource request."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCE_NAME_FIELD_NUMBER: builtins.int
    AMOUNT_FIELD_NUMBER: builtins.int
    DISCOVERY_SCRIPT_FIELD_NUMBER: builtins.int
    VENDOR_FIELD_NUMBER: builtins.int
    resource_name: builtins.str
    """(Required) resource name."""
    amount: builtins.int
    """(Required) resource amount requesting."""
    discovery_script: builtins.str
    """Optional script used to discover the resources."""
    vendor: builtins.str
    """Optional vendor, required for some cluster managers."""
    def __init__(
        self,
        *,
        resource_name: builtins.str = ...,
        amount: builtins.int = ...,
        discovery_script: builtins.str | None = ...,
        vendor: builtins.str | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "_discovery_script",
            b"_discovery_script",
            "_vendor",
            b"_vendor",
            "discovery_script",
            b"discovery_script",
            "vendor",
            b"vendor",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "_discovery_script",
            b"_discovery_script",
            "_vendor",
            b"_vendor",
            "amount",
            b"amount",
            "discovery_script",
            b"discovery_script",
            "resource_name",
            b"resource_name",
            "vendor",
            b"vendor",
        ],
    ) -> None: ...
    @typing.overload
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_discovery_script", b"_discovery_script"]
    ) -> typing_extensions.Literal["discovery_script"] | None: ...
    @typing.overload
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_vendor", b"_vendor"]
    ) -> typing_extensions.Literal["vendor"] | None: ...

global___ExecutorResourceRequest = ExecutorResourceRequest

class TaskResourceRequest(google.protobuf.message.Message):
    """A task resource request."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCE_NAME_FIELD_NUMBER: builtins.int
    AMOUNT_FIELD_NUMBER: builtins.int
    resource_name: builtins.str
    """(Required) resource name."""
    amount: builtins.float
    """(Required) resource amount requesting as a double to support fractional
    resource requests.
    """
    def __init__(
        self,
        *,
        resource_name: builtins.str = ...,
        amount: builtins.float = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "amount", b"amount", "resource_name", b"resource_name"
        ],
    ) -> None: ...

global___TaskResourceRequest = TaskResourceRequest

class ResourceProfile(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class ExecutorResourcesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___ExecutorResourceRequest: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___ExecutorResourceRequest | None = ...,
        ) -> None: ...
        def HasField(
            self, field_name: typing_extensions.Literal["value", b"value"]
        ) -> builtins.bool: ...
        def ClearField(
            self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    class TaskResourcesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___TaskResourceRequest: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___TaskResourceRequest | None = ...,
        ) -> None: ...
        def HasField(
            self, field_name: typing_extensions.Literal["value", b"value"]
        ) -> builtins.bool: ...
        def ClearField(
            self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    EXECUTOR_RESOURCES_FIELD_NUMBER: builtins.int
    TASK_RESOURCES_FIELD_NUMBER: builtins.int
    @property
    def executor_resources(
        self,
    ) -> google.protobuf.internal.containers.MessageMap[
        builtins.str, global___ExecutorResourceRequest
    ]:
        """(Optional) Resource requests for executors. Mapped from the resource name
        (e.g., cores, memory, CPU) to its specific request.
        """
    @property
    def task_resources(
        self,
    ) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___TaskResourceRequest]:
        """(Optional) Resource requests for tasks. Mapped from the resource name
        (e.g., cores, memory, CPU) to its specific request.
        """
    def __init__(
        self,
        *,
        executor_resources: collections.abc.Mapping[builtins.str, global___ExecutorResourceRequest]
        | None = ...,
        task_resources: collections.abc.Mapping[builtins.str, global___TaskResourceRequest]
        | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "executor_resources", b"executor_resources", "task_resources", b"task_resources"
        ],
    ) -> None: ...

global___ResourceProfile = ResourceProfile

class Origin(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PYTHON_ORIGIN_FIELD_NUMBER: builtins.int
    JVM_ORIGIN_FIELD_NUMBER: builtins.int
    @property
    def python_origin(self) -> global___PythonOrigin: ...
    @property
    def jvm_origin(self) -> global___JvmOrigin: ...
    def __init__(
        self,
        *,
        python_origin: global___PythonOrigin | None = ...,
        jvm_origin: global___JvmOrigin | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "function", b"function", "jvm_origin", b"jvm_origin", "python_origin", b"python_origin"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "function", b"function", "jvm_origin", b"jvm_origin", "python_origin", b"python_origin"
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["function", b"function"]
    ) -> typing_extensions.Literal["python_origin", "jvm_origin"] | None: ...

global___Origin = Origin

class PythonOrigin(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FRAGMENT_FIELD_NUMBER: builtins.int
    CALL_SITE_FIELD_NUMBER: builtins.int
    fragment: builtins.str
    """(Required) Name of the origin, for example, the name of the function"""
    call_site: builtins.str
    """(Required) Callsite to show to end users, for example, stacktrace."""
    def __init__(
        self,
        *,
        fragment: builtins.str = ...,
        call_site: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal["call_site", b"call_site", "fragment", b"fragment"],
    ) -> None: ...

global___PythonOrigin = PythonOrigin

class JvmOrigin(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LINE_FIELD_NUMBER: builtins.int
    START_POSITION_FIELD_NUMBER: builtins.int
    START_INDEX_FIELD_NUMBER: builtins.int
    STOP_INDEX_FIELD_NUMBER: builtins.int
    SQL_TEXT_FIELD_NUMBER: builtins.int
    OBJECT_TYPE_FIELD_NUMBER: builtins.int
    OBJECT_NAME_FIELD_NUMBER: builtins.int
    STACK_TRACE_FIELD_NUMBER: builtins.int
    line: builtins.int
    """(Optional) Line number in the source file."""
    start_position: builtins.int
    """(Optional) Start position in the source file."""
    start_index: builtins.int
    """(Optional) Start index in the source file."""
    stop_index: builtins.int
    """(Optional) Stop index in the source file."""
    sql_text: builtins.str
    """(Optional) SQL text."""
    object_type: builtins.str
    """(Optional) Object type."""
    object_name: builtins.str
    """(Optional) Object name."""
    @property
    def stack_trace(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___StackTraceElement
    ]:
        """(Optional) Stack trace."""
    def __init__(
        self,
        *,
        line: builtins.int | None = ...,
        start_position: builtins.int | None = ...,
        start_index: builtins.int | None = ...,
        stop_index: builtins.int | None = ...,
        sql_text: builtins.str | None = ...,
        object_type: builtins.str | None = ...,
        object_name: builtins.str | None = ...,
        stack_trace: collections.abc.Iterable[global___StackTraceElement] | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "_line",
            b"_line",
            "_object_name",
            b"_object_name",
            "_object_type",
            b"_object_type",
            "_sql_text",
            b"_sql_text",
            "_start_index",
            b"_start_index",
            "_start_position",
            b"_start_position",
            "_stop_index",
            b"_stop_index",
            "line",
            b"line",
            "object_name",
            b"object_name",
            "object_type",
            b"object_type",
            "sql_text",
            b"sql_text",
            "start_index",
            b"start_index",
            "start_position",
            b"start_position",
            "stop_index",
            b"stop_index",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "_line",
            b"_line",
            "_object_name",
            b"_object_name",
            "_object_type",
            b"_object_type",
            "_sql_text",
            b"_sql_text",
            "_start_index",
            b"_start_index",
            "_start_position",
            b"_start_position",
            "_stop_index",
            b"_stop_index",
            "line",
            b"line",
            "object_name",
            b"object_name",
            "object_type",
            b"object_type",
            "sql_text",
            b"sql_text",
            "stack_trace",
            b"stack_trace",
            "start_index",
            b"start_index",
            "start_position",
            b"start_position",
            "stop_index",
            b"stop_index",
        ],
    ) -> None: ...
    @typing.overload
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_line", b"_line"]
    ) -> typing_extensions.Literal["line"] | None: ...
    @typing.overload
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_object_name", b"_object_name"]
    ) -> typing_extensions.Literal["object_name"] | None: ...
    @typing.overload
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_object_type", b"_object_type"]
    ) -> typing_extensions.Literal["object_type"] | None: ...
    @typing.overload
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_sql_text", b"_sql_text"]
    ) -> typing_extensions.Literal["sql_text"] | None: ...
    @typing.overload
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_start_index", b"_start_index"]
    ) -> typing_extensions.Literal["start_index"] | None: ...
    @typing.overload
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_start_position", b"_start_position"]
    ) -> typing_extensions.Literal["start_position"] | None: ...
    @typing.overload
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_stop_index", b"_stop_index"]
    ) -> typing_extensions.Literal["stop_index"] | None: ...

global___JvmOrigin = JvmOrigin

class StackTraceElement(google.protobuf.message.Message):
    """A message to hold a [[java.lang.StackTraceElement]]."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLASS_LOADER_NAME_FIELD_NUMBER: builtins.int
    MODULE_NAME_FIELD_NUMBER: builtins.int
    MODULE_VERSION_FIELD_NUMBER: builtins.int
    DECLARING_CLASS_FIELD_NUMBER: builtins.int
    METHOD_NAME_FIELD_NUMBER: builtins.int
    FILE_NAME_FIELD_NUMBER: builtins.int
    LINE_NUMBER_FIELD_NUMBER: builtins.int
    class_loader_name: builtins.str
    """(Optional) Class loader name"""
    module_name: builtins.str
    """(Optional) Module name"""
    module_version: builtins.str
    """(Optional) Module version"""
    declaring_class: builtins.str
    """(Required) Declaring class"""
    method_name: builtins.str
    """(Required) Method name"""
    file_name: builtins.str
    """(Optional) File name"""
    line_number: builtins.int
    """(Required) Line number"""
    def __init__(
        self,
        *,
        class_loader_name: builtins.str | None = ...,
        module_name: builtins.str | None = ...,
        module_version: builtins.str | None = ...,
        declaring_class: builtins.str = ...,
        method_name: builtins.str = ...,
        file_name: builtins.str | None = ...,
        line_number: builtins.int = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "_class_loader_name",
            b"_class_loader_name",
            "_file_name",
            b"_file_name",
            "_module_name",
            b"_module_name",
            "_module_version",
            b"_module_version",
            "class_loader_name",
            b"class_loader_name",
            "file_name",
            b"file_name",
            "module_name",
            b"module_name",
            "module_version",
            b"module_version",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "_class_loader_name",
            b"_class_loader_name",
            "_file_name",
            b"_file_name",
            "_module_name",
            b"_module_name",
            "_module_version",
            b"_module_version",
            "class_loader_name",
            b"class_loader_name",
            "declaring_class",
            b"declaring_class",
            "file_name",
            b"file_name",
            "line_number",
            b"line_number",
            "method_name",
            b"method_name",
            "module_name",
            b"module_name",
            "module_version",
            b"module_version",
        ],
    ) -> None: ...
    @typing.overload
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_class_loader_name", b"_class_loader_name"]
    ) -> typing_extensions.Literal["class_loader_name"] | None: ...
    @typing.overload
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_file_name", b"_file_name"]
    ) -> typing_extensions.Literal["file_name"] | None: ...
    @typing.overload
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_module_name", b"_module_name"]
    ) -> typing_extensions.Literal["module_name"] | None: ...
    @typing.overload
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_module_version", b"_module_version"]
    ) -> typing_extensions.Literal["module_version"] | None: ...

global___StackTraceElement = StackTraceElement

class Bools(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUES_FIELD_NUMBER: builtins.int
    @property
    def values(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.bool]: ...
    def __init__(
        self,
        *,
        values: collections.abc.Iterable[builtins.bool] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["values", b"values"]) -> None: ...

global___Bools = Bools

class Ints(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUES_FIELD_NUMBER: builtins.int
    @property
    def values(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(
        self,
        *,
        values: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["values", b"values"]) -> None: ...

global___Ints = Ints

class Longs(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUES_FIELD_NUMBER: builtins.int
    @property
    def values(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(
        self,
        *,
        values: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["values", b"values"]) -> None: ...

global___Longs = Longs

class Floats(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUES_FIELD_NUMBER: builtins.int
    @property
    def values(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    def __init__(
        self,
        *,
        values: collections.abc.Iterable[builtins.float] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["values", b"values"]) -> None: ...

global___Floats = Floats

class Doubles(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUES_FIELD_NUMBER: builtins.int
    @property
    def values(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    def __init__(
        self,
        *,
        values: collections.abc.Iterable[builtins.float] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["values", b"values"]) -> None: ...

global___Doubles = Doubles

class Strings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUES_FIELD_NUMBER: builtins.int
    @property
    def values(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        values: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["values", b"values"]) -> None: ...

global___Strings = Strings
