/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming.ui;

import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.streaming.ui.StreamingQueryUIData;
import scala.Function0;
import scala.Function1;

public final class UIUtils$ {
    public static final UIUtils$ MODULE$ = new UIUtils$();
    private static final DateTimeFormatter progressTimestampFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZone(DateTimeUtils$.MODULE$.getZoneId("UTC"));

    public double withNumberInvalid(Function0<Object> number) {
        if (Double.isNaN(number.apply$mcD$sp()) || Double.isInfinite(number.apply$mcD$sp())) {
            return 0.0;
        }
        return number.apply$mcD$sp();
    }

    public <T> T withNoProgress(StreamingQueryUIData query, Function0<T> body2, T t) {
        if (query.lastProgress() != null) {
            return (T)body2.apply();
        }
        return t;
    }

    public String getQueryName(StreamingQueryUIData uiData) {
        if (uiData.summary().name() == null || uiData.summary().name().isEmpty()) {
            return "<no name>";
        }
        return uiData.summary().name();
    }

    public String getQueryStatus(StreamingQueryUIData uiData) {
        if (uiData.summary().isActive()) {
            return "RUNNING";
        }
        return (String)uiData.summary().exception().map((Function1 & Serializable)x$1 -> "FAILED").getOrElse((Function0 & Serializable)() -> "FINISHED");
    }

    private DateTimeFormatter progressTimestampFormat() {
        return progressTimestampFormat;
    }

    public long parseProgressTimestamp(String timestamp) {
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(timestamp, this.progressTimestampFormat());
        return zonedDateTime.toInstant().toEpochMilli();
    }

    private UIUtils$() {
    }
}

