/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.xml;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.security.AccessControlException;
import org.apache.spark.input.PortableDataStream;
import org.apache.spark.input.StreamInputFormat;
import org.apache.spark.rdd.BinaryFileRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.xml.StaxXmlParser;
import org.apache.spark.sql.catalyst.xml.StaxXmlParser$;
import org.apache.spark.sql.catalyst.xml.XmlInferSchema;
import org.apache.spark.sql.catalyst.xml.XmlOptions;
import org.apache.spark.sql.classic.ClassicConversions$;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.xml.XmlDataSource;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.control.NonFatal$;

public final class MultiLineXmlDataSource$
extends XmlDataSource {
    public static final MultiLineXmlDataSource$ MODULE$ = new MultiLineXmlDataSource$();
    private static final boolean isSplitable = false;

    @Override
    public boolean isSplitable() {
        return isSplitable;
    }

    @Override
    public Iterator<InternalRow> readFile(Configuration conf, PartitionedFile file, StaxXmlParser parser, StructType requiredSchema) {
        return parser.parseStream(CodecStreams$.MODULE$.createInputStreamWithCloseResource(conf, file.toPath()), requiredSchema);
    }

    @Override
    public StructType infer(SparkSession sparkSession, Seq<FileStatus> inputPaths, XmlOptions parsedOptions) {
        RDD<PortableDataStream> xml = this.createBaseRdd(sparkSession, inputPaths, parsedOptions);
        RDD tokenRDD = xml.flatMap((Function1 & Serializable)portableDataStream -> {
            Iterator iterator;
            try {
                iterator = StaxXmlParser$.MODULE$.tokenizeStream(CodecStreams$.MODULE$.createInputStreamWithCloseResource(portableDataStream.getConfiguration(), new Path(portableDataStream.getPath())), parsedOptions);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable throwable3 = throwable;
                if (throwable3 instanceof FileNotFoundException) {
                    FileNotFoundException fileNotFoundException = (FileNotFoundException)throwable3;
                    if (parsedOptions.ignoreMissingFiles()) {
                        MODULE$.logWarning((Function0<String>)(Function0 & Serializable)() -> "Skipped missing file", (Throwable)fileNotFoundException);
                        iterator = package$.MODULE$.Iterator().empty();
                    }
                }
                if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                    Throwable throwable4 = ExceptionUtils.getRootCause((Throwable)throwable2);
                    if (throwable4 instanceof AccessControlException ? true : throwable4 instanceof BlockMissingException) {
                        throw throwable4;
                    }
                    if ((throwable4 instanceof RuntimeException ? true : throwable4 instanceof IOException) && parsedOptions.ignoreCorruptFiles()) {
                        MODULE$.logWarning((Function0<String>)(Function0 & Serializable)() -> "Skipped the rest of the content in the corrupted file", throwable2);
                        iterator = package$.MODULE$.Iterator().empty();
                    }
                    throw throwable4;
                }
                throw throwable;
            }
            return iterator;
        }, ClassTag$.MODULE$.apply(String.class));
        return (StructType)SQLExecution$.MODULE$.withSQLConfPropagated(ClassicConversions$.MODULE$.castToImpl(sparkSession), (Function0 & Serializable)() -> {
            StructType schema = new XmlInferSchema(parsedOptions, sparkSession.sessionState().conf().caseSensitiveAnalysis()).infer(tokenRDD);
            return schema;
        });
    }

    private RDD<PortableDataStream> createBaseRdd(SparkSession sparkSession, Seq<FileStatus> inputPaths, XmlOptions options) {
        Seq paths = (Seq)inputPaths.map((Function1 & Serializable)x$4 -> x$4.getPath());
        String name = paths.mkString(",");
        Job job = Job.getInstance((Configuration)sparkSession.sessionState().newHadoopConfWithOptions((Map<String, String>)options.parameters()));
        FileInputFormat.setInputPaths((Job)job, (Path[])((Path[])paths.toArray(ClassTag$.MODULE$.apply(Path.class))));
        Configuration conf = job.getConfiguration();
        BinaryFileRDD rdd = new BinaryFileRDD(sparkSession.sparkContext(), StreamInputFormat.class, String.class, PortableDataStream.class, conf, sparkSession.sparkContext().defaultMinPartitions());
        return RDD$.MODULE$.rddToPairRDDFunctions(rdd.setName("XMLFile: " + name), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(PortableDataStream.class), (Ordering)Ordering.String$.MODULE$).values();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(MultiLineXmlDataSource$.class);
    }

    private MultiLineXmlDataSource$() {
    }
}

