/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.state;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.UUID;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.metric.CustomMetric;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.streaming.ContinuousStream;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.execution.datasources.v2.state.FromSnapshotOptions;
import org.apache.spark.sql.execution.datasources.v2.state.ReadChangeFeedOptions;
import org.apache.spark.sql.execution.datasources.v2.state.StateDataSourceErrors$;
import org.apache.spark.sql.execution.datasources.v2.state.StatePartitionReaderFactory;
import org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions;
import org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions$JoinSideValues$;
import org.apache.spark.sql.execution.datasources.v2.state.StateStoreInputPartition;
import org.apache.spark.sql.execution.datasources.v2.state.StreamStreamJoinStateHelper$;
import org.apache.spark.sql.execution.datasources.v2.state.StreamStreamJoinStatePartitionReaderFactory;
import org.apache.spark.sql.execution.streaming.StreamingSymmetricHashJoinHelper$LeftSide$;
import org.apache.spark.sql.execution.streaming.StreamingSymmetricHashJoinHelper$RightSide$;
import org.apache.spark.sql.execution.streaming.TransformWithStateVariableInfo;
import org.apache.spark.sql.execution.streaming.state.KeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.StateSchemaProvider;
import org.apache.spark.sql.execution.streaming.state.StateStoreColFamilySchema;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.SerializableConfiguration$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005ec\u0001\u0002\n\u0014\u0001\u0011B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t{\u0001\u0011\t\u0011)A\u0005}!AA\t\u0001B\u0001B\u0003%Q\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003K\u0011!\t\u0006A!A!\u0002\u0013\u0011\u0006\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011\u0002,\t\u0011\u0001\u0004!\u0011!Q\u0001\n\u0005D\u0001\"\u001a\u0001\u0003\u0002\u0003\u0006IA\u001a\u0005\u0006U\u0002!\ta\u001b\u0005\bk\u0002\u0011\r\u0011\"\u0003w\u0011\u001d\t9\u0001\u0001Q\u0001\n]Dq!!\u0003\u0001\t\u0003\nY\u0001C\u0004\u0002\u000e\u0001!\t%a\u0004\t\u000f\u0005u\u0001\u0001\"\u0011\u0002 !9\u0011q\u0005\u0001\u0005B\u0005%\u0002bBA\u0016\u0001\u0011\u0005\u0013Q\u0006\u0005\b\u0003\u000b\u0002A\u0011BA$\u0005%\u0019F/\u0019;f'\u000e\fgN\u0003\u0002\u0015+\u0005)1\u000f^1uK*\u0011acF\u0001\u0003mJR!\u0001G\r\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u00035m\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005qi\u0012aA:rY*\u0011adH\u0001\u0006gB\f'o\u001b\u0006\u0003A\u0005\na!\u00199bG\",'\"\u0001\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001)S&\u000e\t\u0003M-j\u0011a\n\u0006\u0003Q%\nA\u0001\\1oO*\t!&\u0001\u0003kCZ\f\u0017B\u0001\u0017(\u0005\u0019y%M[3diB\u0011afM\u0007\u0002_)\u0011\u0001'M\u0001\u0005e\u0016\fGM\u0003\u000237\u0005I1m\u001c8oK\u000e$xN]\u0005\u0003i=\u0012AaU2b]B\u0011aFN\u0005\u0003o=\u0012QAQ1uG\"\fqa]3tg&|g\u000e\u0005\u0002;w5\t1$\u0003\u0002=7\ta1\u000b]1sWN+7o]5p]\u000611o\u00195f[\u0006\u0004\"a\u0010\"\u000e\u0003\u0001S!!Q\u000e\u0002\u000bQL\b/Z:\n\u0005\r\u0003%AC*ueV\u001cG\u000fV=qK\u0006i1o\\;sG\u0016|\u0005\u000f^5p]N\u0004\"AR$\u000e\u0003MI!\u0001S\n\u0003%M#\u0018\r^3T_V\u00148-Z(qi&|gn]\u0001\u000fgR\fG/Z*u_J,7i\u001c8g!\tYu*D\u0001M\u0015\t!RJ\u0003\u0002O3\u0005I1\u000f\u001e:fC6LgnZ\u0005\u0003!2\u0013ab\u0015;bi\u0016\u001cFo\u001c:f\u0007>tg-A\nlKf\u001cF/\u0019;f\u000b:\u001cw\u000eZ3s'B,7\r\u0005\u0002L'&\u0011A\u000b\u0014\u0002\u0014\u0017\u0016L8\u000b^1uK\u0016s7m\u001c3feN\u0003XmY\u0001\u0015gR\fG/\u001a,be&\f'\r\\3J]\u001a|w\n\u001d;\u0011\u0007]SF,D\u0001Y\u0015\u0005I\u0016!B:dC2\f\u0017BA.Y\u0005\u0019y\u0005\u000f^5p]B\u0011QLX\u0007\u0002\u001b&\u0011q,\u0014\u0002\u001f)J\fgn\u001d4pe6<\u0016\u000e\u001e5Ti\u0006$XMV1sS\u0006\u0014G.Z%oM>\fAd\u001d;bi\u0016\u001cFo\u001c:f\u0007>dg)Y7jYf\u001c6\r[3nC>\u0003H\u000fE\u0002X5\n\u0004\"aS2\n\u0005\u0011d%!G*uCR,7\u000b^8sK\u000e{GNR1nS2L8k\u00195f[\u0006\fac\u001d;bi\u0016\u001c6\r[3nCB\u0013xN^5eKJ|\u0005\u000f\u001e\t\u0004/j;\u0007CA&i\u0013\tIGJA\nTi\u0006$XmU2iK6\f\u0007K]8wS\u0012,'/\u0001\u0004=S:LGO\u0010\u000b\nY6tw\u000e]9sgR\u0004\"A\u0012\u0001\t\u000baJ\u0001\u0019A\u001d\t\u000buJ\u0001\u0019\u0001 \t\u000b\u0011K\u0001\u0019A#\t\u000b%K\u0001\u0019\u0001&\t\u000bEK\u0001\u0019\u0001*\t\u000bUK\u0001\u0019\u0001,\t\u000b\u0001L\u0001\u0019A1\t\u000b\u0015L\u0001\u0019\u00014\u0002'!\fGm\\8q\u0007>tgM\u0011:pC\u0012\u001c\u0017m\u001d;\u0016\u0003]\u00042\u0001_>~\u001b\u0005I(B\u0001>\u001e\u0003%\u0011'o\\1eG\u0006\u001cH/\u0003\u0002}s\nI!I]8bI\u000e\f7\u000f\u001e\t\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005Q$\u0001\u0003vi&d\u0017bAA\u0003\u007f\nI2+\u001a:jC2L'0\u00192mK\u000e{gNZ5hkJ\fG/[8o\u0003QA\u0017\rZ8pa\u000e{gN\u001a\"s_\u0006$7-Y:uA\u0005Q!/Z1e'\u000eDW-\\1\u0015\u0003y\n1\u0003\u001d7b]&s\u0007/\u001e;QCJ$\u0018\u000e^5p]N$\"!!\u0005\u0011\u000b]\u000b\u0019\"a\u0006\n\u0007\u0005U\u0001LA\u0003BeJ\f\u0017\u0010E\u0002/\u00033I1!a\u00070\u00059Ie\u000e];u!\u0006\u0014H/\u001b;j_:\f1c\u0019:fCR,'+Z1eKJ4\u0015m\u0019;pef$\"!!\t\u0011\u00079\n\u0019#C\u0002\u0002&=\u0012a\u0003U1si&$\u0018n\u001c8SK\u0006$WM\u001d$bGR|'/_\u0001\bi>\u0014\u0015\r^2i)\u0005)\u0014a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:$\"!a\f\u0011\t\u0005E\u0012q\b\b\u0005\u0003g\tY\u0004E\u0002\u00026ak!!a\u000e\u000b\u0007\u0005e2%\u0001\u0004=e>|GOP\u0005\u0004\u0003{A\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002B\u0005\r#AB*ue&twMC\u0002\u0002>a\u000b\u0011e\u001d;bi\u0016\u001c\u0005.Z2la>Lg\u000e\u001e)beRLG/[8og2{7-\u0019;j_:,\"!!\u0013\u0011\t\u0005-\u0013QK\u0007\u0003\u0003\u001bRA!a\u0014\u0002R\u0005\u0011am\u001d\u0006\u0004\u0003'z\u0012A\u00025bI>|\u0007/\u0003\u0003\u0002X\u00055#\u0001\u0002)bi\"\u0004")
public class StateScan
implements Scan,
Batch {
    private final SparkSession session;
    private final StructType schema;
    private final StateSourceOptions sourceOptions;
    private final StateStoreConf stateStoreConf;
    private final KeyStateEncoderSpec keyStateEncoderSpec;
    private final Option<TransformWithStateVariableInfo> stateVariableInfoOpt;
    private final Option<StateStoreColFamilySchema> stateStoreColFamilySchemaOpt;
    private final Option<StateSchemaProvider> stateSchemaProviderOpt;
    private final Broadcast<SerializableConfiguration> hadoopConfBroadcast;

    public MicroBatchStream toMicroBatchStream(String x$1) {
        return super.toMicroBatchStream(x$1);
    }

    public ContinuousStream toContinuousStream(String x$1) {
        return super.toContinuousStream(x$1);
    }

    public CustomMetric[] supportedCustomMetrics() {
        return super.supportedCustomMetrics();
    }

    public CustomTaskMetric[] reportDriverMetrics() {
        return super.reportDriverMetrics();
    }

    public Scan.ColumnarSupportMode columnarSupportMode() {
        return super.columnarSupportMode();
    }

    private Broadcast<SerializableConfiguration> hadoopConfBroadcast() {
        return this.hadoopConfBroadcast;
    }

    public StructType readSchema() {
        return this.schema;
    }

    public InputPartition[] planInputPartitions() {
        FileSystem fs2 = this.stateCheckpointPartitionsLocation().getFileSystem(((SerializableConfiguration)this.hadoopConfBroadcast().value()).value());
        FileStatus[] partitions = fs2.listStatus(this.stateCheckpointPartitionsLocation(), new PathFilter(null, fs2){
            private final FileSystem fs$1;

            public boolean accept(Path path) {
                return this.fs$1.getFileStatus(path).isDirectory() && Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(path.getName()))).isSuccess() && StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(path.getName())) >= 0;
            }
            {
                this.fs$1 = fs$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$accept$1(org.apache.hadoop.fs.Path )}, serializedLambda);
            }
        });
        if (ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])partitions)).isEmpty()) {
            throw StateDataSourceErrors$.MODULE$.noPartitionDiscoveredInStateStore(this.sourceOptions);
        }
        UUID queryId = UUID.randomUUID();
        FileStatus[] partitionsSorted = (FileStatus[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])partitions), (Function1 & Serializable)fs -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(fs.getPath().getName()))), (Ordering)Ordering.Int$.MODULE$);
        int[] partitionNums = (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])partitionsSorted), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$1.getPath().getName()))), (ClassTag)ClassTag$.MODULE$.Int());
        int head = BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.intArrayOps(partitionNums)));
        int tail = partitionNums[partitionNums.length - 1];
        Predef$.MODULE$.assert(head == 0, (Function0 & Serializable)() -> "Partition should start with 0");
        Predef$.MODULE$.assert(tail - head + 1 == partitionNums.length, (Function0 & Serializable)() -> "No continuous partitions in state: " + Predef$.MODULE$.wrapIntArray(partitionNums).mkString("Array(", ", ", ")"));
        Option<FromSnapshotOptions> option = this.sourceOptions.fromSnapshotOptions();
        if (None$.MODULE$.equals(option)) {
            return (InputPartition[])ArrayOps$.MODULE$.toArray$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(partitionNums), (Function1 & Serializable)pn -> StateScan.$anonfun$planInputPartitions$5(this, queryId, BoxesRunTime.unboxToInt((Object)pn)), ClassTag$.MODULE$.apply(StateStoreInputPartition.class))), ClassTag$.MODULE$.apply(InputPartition.class));
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            FromSnapshotOptions fromSnapshotOptions = (FromSnapshotOptions)some.value();
            if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.intArrayOps(partitionNums), (Object)BoxesRunTime.boxToInteger((int)fromSnapshotOptions.snapshotPartitionId()))) {
                return (InputPartition[])((Object[])new InputPartition[]{new StateStoreInputPartition(fromSnapshotOptions.snapshotPartitionId(), queryId, this.sourceOptions)});
            }
            throw StateStoreErrors$.MODULE$.stateStoreSnapshotPartitionNotFound(fromSnapshotOptions.snapshotPartitionId(), this.sourceOptions.operatorId(), this.sourceOptions.stateCheckpointLocation().toString());
        }
        throw new MatchError(option);
    }

    public PartitionReaderFactory createReaderFactory() {
        Enumeration.Value value = this.sourceOptions.joinSide();
        Enumeration.Value value2 = StateSourceOptions$JoinSideValues$.MODULE$.left();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            StructType userFacingSchema = this.schema;
            StructType stateSchema = StreamStreamJoinStateHelper$.MODULE$.readSchema(this.session, this.sourceOptions.stateCheckpointLocation().toString(), this.sourceOptions.operatorId(), StreamingSymmetricHashJoinHelper$LeftSide$.MODULE$, false);
            return new StreamStreamJoinStatePartitionReaderFactory(this.stateStoreConf, (SerializableConfiguration)this.hadoopConfBroadcast().value(), userFacingSchema, stateSchema);
        }
        Enumeration.Value value4 = StateSourceOptions$JoinSideValues$.MODULE$.right();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            StructType userFacingSchema = this.schema;
            StructType stateSchema = StreamStreamJoinStateHelper$.MODULE$.readSchema(this.session, this.sourceOptions.stateCheckpointLocation().toString(), this.sourceOptions.operatorId(), StreamingSymmetricHashJoinHelper$RightSide$.MODULE$, false);
            return new StreamStreamJoinStatePartitionReaderFactory(this.stateStoreConf, (SerializableConfiguration)this.hadoopConfBroadcast().value(), userFacingSchema, stateSchema);
        }
        Enumeration.Value value6 = StateSourceOptions$JoinSideValues$.MODULE$.none();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return new StatePartitionReaderFactory(this.stateStoreConf, (SerializableConfiguration)this.hadoopConfBroadcast().value(), this.schema, this.keyStateEncoderSpec, this.stateVariableInfoOpt, this.stateStoreColFamilySchemaOpt, this.stateSchemaProviderOpt);
        }
        throw new MatchError((Object)value);
    }

    public Batch toBatch() {
        return this;
    }

    public String description() {
        String desc;
        block2: {
            Option<FromSnapshotOptions> option;
            desc = "StateScan [stateCkptLocation=" + this.sourceOptions.stateCheckpointLocation() + "][batchId=" + this.sourceOptions.batchId() + "][operatorId=" + this.sourceOptions.operatorId() + "][storeName=" + this.sourceOptions.storeName() + "]";
            Enumeration.Value value = this.sourceOptions.joinSide();
            Enumeration.Value value2 = StateSourceOptions$JoinSideValues$.MODULE$.none();
            if (value == null ? value2 != null : !value.equals(value2)) {
                desc = desc + "[joinSide=" + this.sourceOptions.joinSide() + "]";
            }
            if ((option = this.sourceOptions.fromSnapshotOptions()) instanceof Some) {
                Some some = (Some)option;
                FromSnapshotOptions fromSnapshotOptions = (FromSnapshotOptions)some.value();
                desc = desc + "[snapshotStartBatchId=" + fromSnapshotOptions.snapshotStartBatchId() + "]";
                desc = desc + "[snapshotPartitionId=" + fromSnapshotOptions.snapshotPartitionId() + "]";
            }
            Option<ReadChangeFeedOptions> option2 = this.sourceOptions.readChangeFeedOptions();
            if (!(option2 instanceof Some)) break block2;
            Some some = (Some)option2;
            ReadChangeFeedOptions fromSnapshotOptions = (ReadChangeFeedOptions)some.value();
            desc = desc + "[changeStartBatchId=" + fromSnapshotOptions.changeStartBatchId();
            desc = desc + "[changeEndBatchId=" + fromSnapshotOptions.changeEndBatchId();
        }
        return desc;
    }

    private Path stateCheckpointPartitionsLocation() {
        return new Path(this.sourceOptions.stateCheckpointLocation(), Integer.toString(this.sourceOptions.operatorId()));
    }

    public static final /* synthetic */ StateStoreInputPartition $anonfun$planInputPartitions$5(StateScan $this, UUID queryId$1, int pn) {
        return new StateStoreInputPartition(pn, queryId$1, $this.sourceOptions);
    }

    public StateScan(SparkSession session, StructType schema, StateSourceOptions sourceOptions, StateStoreConf stateStoreConf, KeyStateEncoderSpec keyStateEncoderSpec, Option<TransformWithStateVariableInfo> stateVariableInfoOpt, Option<StateStoreColFamilySchema> stateStoreColFamilySchemaOpt, Option<StateSchemaProvider> stateSchemaProviderOpt) {
        this.session = session;
        this.schema = schema;
        this.sourceOptions = sourceOptions;
        this.stateStoreConf = stateStoreConf;
        this.keyStateEncoderSpec = keyStateEncoderSpec;
        this.stateVariableInfoOpt = stateVariableInfoOpt;
        this.stateStoreColFamilySchemaOpt = stateStoreColFamilySchemaOpt;
        this.stateSchemaProviderOpt = stateSchemaProviderOpt;
        this.hadoopConfBroadcast = SerializableConfiguration$.MODULE$.broadcast(session.sparkContext(), session.sessionState().newHadoopConf());
    }
}

