/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.expressions.ToStringBase$;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.FractionTimeFormatter;
import org.apache.spark.sql.catalyst.util.IntervalStringStyles$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.TimeFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.execution.CommandResultExec;
import org.apache.spark.sql.execution.HiveResult;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.command.DescribeCommandBase;
import org.apache.spark.sql.execution.command.ExecutedCommandExec;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.command.ShowTablesCommand;
import org.apache.spark.sql.execution.command.ShowViewsCommand;
import org.apache.spark.sql.execution.datasources.v2.DescribeTableExec;
import org.apache.spark.sql.execution.datasources.v2.ShowTablesExec;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimeType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.VariantType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.unsafe.types.VariantVal;
import org.apache.spark.util.ArrayImplicits$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;

public final class HiveResult$
implements SQLConfHelper {
    public static final HiveResult$ MODULE$ = new HiveResult$();

    static {
        SQLConfHelper.$init$((SQLConfHelper)MODULE$);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(scala.collection.immutable.Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    public HiveResult.TimeFormatters getTimeFormatters() {
        DateFormatter dateFormatter = DateFormatter$.MODULE$.apply();
        FractionTimeFormatter timeFormatter = new FractionTimeFormatter();
        TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.getFractionFormatter(DateTimeUtils$.MODULE$.getZoneId(SQLConf$.MODULE$.get().sessionLocalTimeZone()));
        return new HiveResult.TimeFormatters(dateFormatter, (TimeFormatter)timeFormatter, timestampFormatter);
    }

    public Function1<byte[], String> getBinaryFormatter() {
        block0: {
            if (!this.conf().getConf(SQLConf$.MODULE$.BINARY_OUTPUT_STYLE()).isEmpty()) break block0;
            this.conf().setConf((ConfigEntry)SQLConf$.MODULE$.BINARY_OUTPUT_STYLE(), (Object)new Some((Object)SQLConf.BinaryOutputStyle$.MODULE$.UTF8()));
        }
        return (Function1 & Serializable)x$1 -> ((UTF8String)ToStringBase$.MODULE$.getBinaryFormatter().apply(x$1)).toString();
    }

    private SparkPlan stripRootCommandResult(SparkPlan executedPlan) {
        SparkPlan sparkPlan = executedPlan;
        if (sparkPlan instanceof CommandResultExec) {
            CommandResultExec commandResultExec = (CommandResultExec)sparkPlan;
            SparkPlan plan = commandResultExec.commandPhysicalPlan();
            return plan;
        }
        return sparkPlan;
    }

    public scala.collection.immutable.Seq<String> hiveResultString(SparkPlan executedPlan) {
        ShowTablesCommand showTablesCommand;
        RunnableCommand s;
        boolean bl = false;
        ExecutedCommandExec executedCommandExec = null;
        SparkPlan sparkPlan = this.stripRootCommandResult(executedPlan);
        if (sparkPlan instanceof ExecutedCommandExec) {
            bl = true;
            executedCommandExec = (ExecutedCommandExec)sparkPlan;
            if (executedCommandExec.cmd() instanceof DescribeCommandBase) {
                return this.formatDescribeTableOutput(executedPlan.executeCollectPublic());
            }
        }
        if (sparkPlan instanceof DescribeTableExec) {
            return this.formatDescribeTableOutput(executedPlan.executeCollectPublic());
        }
        if (bl && (s = executedCommandExec.cmd()) instanceof ShowTablesCommand && !(showTablesCommand = (ShowTablesCommand)s).isExtended()) {
            return ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])executedPlan.executeCollect()), (Function1 & Serializable)x$2 -> x$2.getString(1), ClassTag$.MODULE$.apply(String.class))).toImmutableArraySeq();
        }
        if (sparkPlan instanceof ShowTablesExec) {
            return ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])executedPlan.executeCollect()), (Function1 & Serializable)x$3 -> x$3.getString(1), ClassTag$.MODULE$.apply(String.class))).toImmutableArraySeq();
        }
        if (bl && executedCommandExec.cmd() instanceof ShowViewsCommand) {
            return ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])executedPlan.executeCollect()), (Function1 & Serializable)x$4 -> x$4.getString(1), ClassTag$.MODULE$.apply(String.class))).toImmutableArraySeq();
        }
        HiveResult.TimeFormatters timeFormatters = this.getTimeFormatters();
        Function1<byte[], String> binaryFormatter = this.getBinaryFormatter();
        ArraySeq result = ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])sparkPlan.executeCollectPublic()), (Function1 & Serializable)x$5 -> x$5.toSeq(), ClassTag$.MODULE$.apply(scala.collection.immutable.Seq.class))).toImmutableArraySeq();
        scala.collection.immutable.Seq types = (scala.collection.immutable.Seq)executedPlan.output().map((Function1 & Serializable)x$6 -> x$6.dataType());
        return (scala.collection.immutable.Seq)((IterableOps)result.map((Function1 & Serializable)x$7 -> (scala.collection.immutable.Seq)((IterableOps)x$7.zip((IterableOnce)types)).map((Function1 & Serializable)e -> MODULE$.toHiveString((Tuple2<Object, DataType>)e, false, timeFormatters, binaryFormatter)))).map((Function1 & Serializable)x$8 -> x$8.mkString("\t"));
    }

    private scala.collection.immutable.Seq<String> formatDescribeTableOutput(Row[] rows) {
        return ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])rows), (Function1 & Serializable)x0$1 -> {
            Some some;
            Row row = x0$1;
            if (row != null && !(some = Row$.MODULE$.unapplySeq(row)).isEmpty() && some.get() != null && ((SeqOps)some.get()).lengthCompare(3) == 0) {
                Object name = ((SeqOps)some.get()).apply(0);
                Object dataType = ((SeqOps)some.get()).apply(1);
                Object comment = ((SeqOps)some.get()).apply(2);
                if (name instanceof String) {
                    String string = (String)name;
                    if (dataType instanceof String) {
                        String string2 = (String)dataType;
                        return ((IterableOnceOps)new .colon.colon((Object)string, (List)new .colon.colon((Object)string2, (List)new .colon.colon((Object)((String)Option$.MODULE$.apply((Object)((String)comment)).getOrElse((Function0 & Serializable)() -> "")), (List)Nil$.MODULE$))).map((Function1 & Serializable)s -> String.format("%-20s", s))).mkString("\t");
                    }
                }
            }
            throw new MatchError((Object)row);
        }, ClassTag$.MODULE$.apply(String.class))).toImmutableArraySeq();
    }

    public String toHiveString(Tuple2<Object, DataType> a, boolean nested, HiveResult.TimeFormatters formatters, Function1<byte[], String> binaryFormatter) {
        Object s;
        Object lt;
        Object object;
        Tuple2<Object, DataType> tuple2 = a;
        if (tuple2 != null && (object = tuple2._1()) == null) {
            if (nested) {
                return "null";
            }
            return "NULL";
        }
        if (tuple2 != null) {
            Object b = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (BooleanType$.MODULE$.equals(dataType)) {
                return b.toString();
            }
        }
        if (tuple2 != null) {
            Object d = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (d instanceof Date) {
                Date date = (Date)d;
                if (DateType$.MODULE$.equals(dataType)) {
                    return formatters.date().format((java.util.Date)date);
                }
            }
        }
        if (tuple2 != null) {
            Object ld = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (ld instanceof LocalDate) {
                LocalDate localDate = (LocalDate)ld;
                if (DateType$.MODULE$.equals(dataType)) {
                    return formatters.date().format(localDate);
                }
            }
        }
        if (tuple2 != null && (lt = tuple2._1()) instanceof LocalTime) {
            LocalTime localTime = (LocalTime)lt;
            if (tuple2._2() instanceof TimeType) {
                return formatters.time().format(localTime);
            }
        }
        if (tuple2 != null) {
            Object t = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (t instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)t;
                if (TimestampType$.MODULE$.equals(dataType)) {
                    return formatters.timestamp().format(timestamp);
                }
            }
        }
        if (tuple2 != null) {
            Object i = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (i instanceof Instant) {
                Instant instant = (Instant)i;
                if (TimestampType$.MODULE$.equals(dataType)) {
                    return formatters.timestamp().format(instant);
                }
            }
        }
        if (tuple2 != null) {
            Object l = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (l instanceof LocalDateTime) {
                LocalDateTime localDateTime = (LocalDateTime)l;
                if (TimestampNTZType$.MODULE$.equals(dataType)) {
                    return formatters.timestamp().format(localDateTime);
                }
            }
        }
        if (tuple2 != null) {
            Object bin = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (bin instanceof byte[]) {
                byte[] byArray = (byte[])bin;
                if (BinaryType$.MODULE$.equals(dataType)) {
                    return (String)binaryFormatter.apply((Object)byArray);
                }
            }
        }
        if (tuple2 != null) {
            Object decimal = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (decimal instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)decimal;
                if (dataType != null && DecimalType$.MODULE$.unapply(dataType)) {
                    return bigDecimal.toPlainString();
                }
            }
        }
        if (tuple2 != null) {
            Object n = tuple2._1();
            if (tuple2._2() instanceof NumericType) {
                return n.toString();
            }
        }
        if (tuple2 != null && (s = tuple2._1()) instanceof String) {
            String string = (String)s;
            if (tuple2._2() instanceof StringType) {
                if (nested) {
                    return "\"" + string + "\"";
                }
                return string;
            }
        }
        if (tuple2 != null) {
            Object interval = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (interval instanceof CalendarInterval) {
                CalendarInterval calendarInterval = (CalendarInterval)interval;
                if (CalendarIntervalType$.MODULE$.equals(dataType)) {
                    return calendarInterval.toString();
                }
            }
        }
        if (tuple2 != null) {
            Object seq = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (seq instanceof Seq) {
                Seq seq2 = (Seq)seq;
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType typ = arrayType.elementType();
                    return ((IterableOnceOps)((IterableOps)seq2.map((Function1 & Serializable)v -> new Tuple2(v, (Object)typ))).map((Function1 & Serializable)e -> MODULE$.toHiveString((Tuple2<Object, DataType>)e, true, formatters, binaryFormatter))).mkString("[", ",", "]");
                }
            }
        }
        if (tuple2 != null) {
            Object m = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (m instanceof Map) {
                Map map = (Map)m;
                if (dataType instanceof MapType) {
                    MapType mapType = (MapType)dataType;
                    DataType kType = mapType.keyType();
                    DataType vType = mapType.valueType();
                    return ((IterableOnceOps)((IterableOnceOps)map.map((Function1 & Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 != null) {
                            Object key = tuple2._1();
                            Object value = tuple2._2();
                            return MODULE$.toHiveString((Tuple2<Object, DataType>)new Tuple2(key, (Object)kType), true, formatters, binaryFormatter) + ":" + MODULE$.toHiveString((Tuple2<Object, DataType>)new Tuple2(value, (Object)vType), true, formatters, binaryFormatter);
                        }
                        throw new MatchError((Object)tuple2);
                    })).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString("{", ",", "}");
                }
            }
        }
        if (tuple2 != null) {
            Object struct = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (struct instanceof Row) {
                Row row = (Row)struct;
                if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    StructField[] fields = structType.fields();
                    return ((IterableOnceOps)((IterableOps)row.toSeq().zip((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])fields))).map((Function1 & Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 != null) {
                            Object v = tuple2._1();
                            StructField t = (StructField)tuple2._2();
                            return "\"" + t.name() + "\":" + MODULE$.toHiveString((Tuple2<Object, DataType>)new Tuple2(v, (Object)t.dataType()), true, formatters, binaryFormatter);
                        }
                        throw new MatchError((Object)tuple2);
                    })).mkString("{", ",", "}");
                }
            }
        }
        if (tuple2 != null) {
            Object period = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (period instanceof Period) {
                Period period2 = (Period)period;
                if (dataType instanceof YearMonthIntervalType) {
                    YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType;
                    byte startField = yearMonthIntervalType.startField();
                    byte endField = yearMonthIntervalType.endField();
                    return IntervalUtils$.MODULE$.toYearMonthIntervalString(IntervalUtils$.MODULE$.periodToMonths(period2, endField), IntervalStringStyles$.MODULE$.HIVE_STYLE(), startField, endField);
                }
            }
        }
        if (tuple2 != null) {
            Object duration = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (duration instanceof Duration) {
                Duration duration2 = (Duration)duration;
                if (dataType instanceof DayTimeIntervalType) {
                    DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType;
                    byte startField = dayTimeIntervalType.startField();
                    byte endField = dayTimeIntervalType.endField();
                    return IntervalUtils$.MODULE$.toDayTimeIntervalString(IntervalUtils$.MODULE$.durationToMicros(duration2, endField), IntervalStringStyles$.MODULE$.HIVE_STYLE(), startField, endField);
                }
            }
        }
        if (tuple2 != null) {
            Object v2 = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (v2 instanceof VariantVal) {
                VariantVal variantVal = (VariantVal)v2;
                if (VariantType$.MODULE$.equals(dataType)) {
                    return variantVal.toString();
                }
            }
        }
        if (tuple2 != null) {
            Object other = tuple2._1();
            DataType u = (DataType)tuple2._2();
            if (u instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)u;
                return userDefinedType.stringifyValue(other);
            }
        }
        throw new MatchError(tuple2);
    }

    private HiveResult$() {
    }
}

