/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.Nameable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.ExecutorFailureTracker;
import org.apache.spark.deploy.ExecutorFailureTracker$;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.scheduler.ExecutorExited;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodState;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.FinalPodState;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.apache.spark.scheduler.cluster.k8s.PodDeleted;
import org.apache.spark.scheduler.cluster.k8s.PodFailed;
import org.apache.spark.scheduler.cluster.k8s.PodSucceeded;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SparkExitCode$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import org.sparkproject.guava.cache.Cache;
import org.sparkproject.guava.cache.CacheBuilder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.MapOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0005\t}d!B\u0017/\u0001QR\u0004\u0002C$\u0001\u0005\u000b\u0007I\u0011A%\t\u00119\u0003!\u0011!Q\u0001\n)C\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\t9\u0002\u0011\t\u0011)A\u0005;\"A\u0011\r\u0001B\u0001B\u0003%!\rC\u0003i\u0001\u0011\u0005\u0011\u000e\u0003\u0005p\u0001!\u0015\r\u0011\"\u0003q\u0011!!\b\u0001#b\u0001\n\u0013)\b\u0002C=\u0001\u0011\u000b\u0007I\u0011\u0002>\t\u0011\u0005u\u0001\u00011A\u0005\nUD\u0011\"a\b\u0001\u0001\u0004%I!!\t\t\u000f\u00055\u0002\u0001)Q\u0005m\"I\u0011q\u0006\u0001C\u0002\u0013%\u0011\u0011\u0007\u0005\t\u0003\u0007\u0002\u0001\u0015!\u0003\u00024!I\u0011Q\t\u0001C\u0002\u0013%\u0011q\t\u0005\t\u0003?\u0002\u0001\u0015!\u0003\u0002J!I\u0011\u0011\r\u0001C\u0002\u0013%\u0011q\t\u0005\t\u0003G\u0002\u0001\u0015!\u0003\u0002J!I\u0011Q\r\u0001C\u0002\u0013E\u0011q\r\u0005\t\u0003_\u0002\u0001\u0015!\u0003\u0002j!I\u0011\u0011\u000f\u0001A\u0002\u0013%\u00111\u000f\u0005\n\u0003\u0003\u0003\u0001\u0019!C\u0005\u0003\u0007C\u0001\"a\"\u0001A\u0003&\u0011Q\u000f\u0005\n\u0003#\u0003!\u0019!C\t\u0003'C\u0001\"!)\u0001A\u0003%\u0011Q\u0013\u0005\t\u0003G\u0003A\u0011\u0003\u001b\u0002h!9\u0011Q\u0015\u0001\u0005\u0002\u0005\u001d\u0006\u0002CAZ\u0001\u0011\u0005a&!.\t\u000f\u0005m\u0006\u0001\"\u0003\u0002>\"9\u0011Q\u001c\u0001\u0005\n\u0005}\u0007bBA{\u0001\u0011%\u0011q\u001f\u0005\b\u0005\u001f\u0001A\u0011\u0002B\t\u0011\u001d\u0011I\u0002\u0001C\u0005\u00057AqA!\u000b\u0001\t\u0013\u0011Y\u0003C\u0004\u00034\u0001!IA!\u000e\t\u000f\te\u0002\u0001\"\u0003\u0003<\u001d9!\u0011\t\u0018\t\n\t\rcAB\u0017/\u0011\u0013\u0011)\u0005\u0003\u0004iM\u0011\u0005!q\t\u0005\n\u0005\u00132#\u0019!C\u0001\u0003OB\u0001Ba\u0013'A\u0003%\u0011\u0011\u000e\u0005\b\u0005\u001b2C\u0011\u0001B(\u0011\u001d\u0011)F\nC\u0001\u0005/B\u0011Ba\u001a'#\u0003%\tA!\u001b\u00039\u0015CXmY;u_J\u0004v\u000eZ:MS\u001a,7-_2mK6\u000bg.Y4fe*\u0011q\u0006M\u0001\u0004Wb\u001a(BA\u00193\u0003\u001d\u0019G.^:uKJT!a\r\u001b\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(BA\u001b7\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0004(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002s\u0005\u0019qN]4\u0014\u0007\u0001Y\u0014\t\u0005\u0002=\u007f5\tQHC\u0001?\u0003\u0015\u00198-\u00197b\u0013\t\u0001UH\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\tR\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\r\u000e\u0013q\u0001T8hO&tw-\u0001\u0003d_:47\u0001A\u000b\u0002\u0015B\u00111\nT\u0007\u0002i%\u0011Q\n\u000e\u0002\n'B\f'o[\"p]\u001a\fQaY8oM\u0002\n\u0001c[;cKJtW\r^3t\u00072LWM\u001c;\u0011\u0005ESV\"\u0001*\u000b\u0005M#\u0016AB2mS\u0016tGO\u0003\u0002V-\u0006Q1.\u001e2fe:,G/Z:\u000b\u0005]C\u0016a\u00024bEJL7\r\u000f\u0006\u00023\u0006\u0011\u0011n\\\u0005\u00037J\u0013\u0001cS;cKJtW\r^3t\u00072LWM\u001c;\u0002\u001dMt\u0017\r]:i_R\u001c8\u000b^8sKB\u0011alX\u0007\u0002]%\u0011\u0001M\f\u0002\u001b\u000bb,7-\u001e;peB{Gm]*oCB\u001c\bn\u001c;t'R|'/Z\u0001\u0006G2|7m\u001b\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003KR\nA!\u001e;jY&\u0011q\r\u001a\u0002\u0006\u00072|7m[\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b)\\G.\u001c8\u0011\u0005y\u0003\u0001\"B$\u0007\u0001\u0004Q\u0005\"B(\u0007\u0001\u0004\u0001\u0006\"\u0002/\u0007\u0001\u0004i\u0006bB1\u0007!\u0003\u0005\rAY\u0001\u0016g\"|W\u000f\u001c3EK2,G/Z#yK\u000e,Ho\u001c:t+\u0005\t\bC\u0001\u001fs\u0013\t\u0019XHA\u0004C_>dW-\u00198\u0002+5L7o]5oOB{G\rR3uK\u000e$H)\u001a7uCV\ta\u000f\u0005\u0002=o&\u0011\u00010\u0010\u0002\u0005\u0019>tw-A\u000bsK6|g/\u001a3Fq\u0016\u001cW\u000f^8sg\u000e\u000b7\r[3\u0016\u0003m\u0004r\u0001`A\u0006\u0003\u001f\ty!D\u0001~\u0015\tqx0A\u0003dC\u000eDWM\u0003\u0003\u0002\u0002\u0005\r\u0011AB2p[6|gN\u0003\u0003\u0002\u0006\u0005\u001d\u0011AB4p_\u001edWM\u0003\u0002\u0002\n\u0005\u00191m\\7\n\u0007\u00055QPA\u0003DC\u000eDW\r\u0005\u0003\u0002\u0012\u0005mQBAA\n\u0015\u0011\t)\"a\u0006\u0002\t1\fgn\u001a\u0006\u0003\u00033\tAA[1wC&\u0019\u00010a\u0005\u0002%1\f7\u000f\u001e$vY2\u001cf.\u00199tQ>$Hk]\u0001\u0017Y\u0006\u001cHOR;mYNs\u0017\r]:i_R$6o\u0018\u0013fcR!\u00111EA\u0015!\ra\u0014QE\u0005\u0004\u0003Oi$\u0001B+oSRD\u0001\"a\u000b\f\u0003\u0003\u0005\rA^\u0001\u0004q\u0012\n\u0014a\u00057bgR4U\u000f\u001c7T]\u0006\u00048\u000f[8u)N\u0004\u0013aD5oC\u000e$\u0018N^1uK\u0012\u0004v\u000eZ:\u0016\u0005\u0005M\u0002#BA\u001b\u0003\u007f1XBAA\u001c\u0015\u0011\tI$a\u000f\u0002\u000f5,H/\u00192mK*\u0019\u0011QH\u001f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002B\u0005]\"a\u0002%bg\"\u001cV\r^\u0001\u0011S:\f7\r^5wCR,G\rU8eg\u0002\n\u0011B\\1nKN\u0004\u0018mY3\u0016\u0005\u0005%\u0003\u0003BA&\u00033rA!!\u0014\u0002VA\u0019\u0011qJ\u001f\u000e\u0005\u0005E#bAA*\u0011\u00061AH]8pizJ1!a\u0016>\u0003\u0019\u0001&/\u001a3fM&!\u00111LA/\u0005\u0019\u0019FO]5oO*\u0019\u0011qK\u001f\u0002\u00159\fW.Z:qC\u000e,\u0007%\u0001\nta\u0006\u00148nQ8oi\u0006Lg.\u001a:OC6,\u0017aE:qCJ\\7i\u001c8uC&tWM\u001d(b[\u0016\u0004\u0013AF7bq:+X.\u0012=fGV$xN\u001d$bS2,(/Z:\u0016\u0005\u0005%\u0004c\u0001\u001f\u0002l%\u0019\u0011QN\u001f\u0003\u0007%sG/A\fnCbtU/\\#yK\u000e,Ho\u001c:GC&dWO]3tA\u0005\tb-Y5mK\u0012,\u00050Z2vi>\u0014\u0018\nZ:\u0016\u0005\u0005U\u0004#BA<\u0003{2XBAA=\u0015\u0011\tY(a\u000f\u0002\u0013%lW.\u001e;bE2,\u0017\u0002BA@\u0003s\u00121aU3u\u0003U1\u0017-\u001b7fI\u0016CXmY;u_JLEm]0%KF$B!a\t\u0002\u0006\"I\u00111\u0006\f\u0002\u0002\u0003\u0007\u0011QO\u0001\u0013M\u0006LG.\u001a3Fq\u0016\u001cW\u000f^8s\u0013\u0012\u001c\b\u0005K\u0002\u0018\u0003\u0017\u00032\u0001PAG\u0013\r\ty)\u0010\u0002\tm>d\u0017\r^5mK\u0006qa-Y5mkJ,GK]1dW\u0016\u0014XCAAK!\u0011\t9*!(\u000e\u0005\u0005e%bAANi\u00051A-\u001a9m_fLA!a(\u0002\u001a\n1R\t_3dkR|'OR1jYV\u0014X\r\u0016:bG.,'/A\bgC&dWO]3Ue\u0006\u001c7.\u001a:!\u0003U9W\r\u001e(v[\u0016CXmY;u_J\u001ch)Y5mK\u0012\fQa\u001d;beR$B!a\t\u0002*\"9\u00111V\u000eA\u0002\u00055\u0016\u0001E:dQ\u0016$W\u000f\\3s\u0005\u0006\u001c7.\u001a8e!\rq\u0016qV\u0005\u0004\u0003cs#!I&vE\u0016\u0014h.\u001a;fg\u000ecWo\u001d;feN\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$\u0017aD:u_B\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8\u0015\t\u0005\r\u0012q\u0017\u0005\b\u0003sc\u0002\u0019AA5\u0003!)\u00070\u001b;D_\u0012,\u0017AD8o\u001d\u0016<8K\\1qg\"|Go\u001d\u000b\u0007\u0003G\ty,!1\t\u000f\u0005-V\u00041\u0001\u0002.\"9\u00111Y\u000fA\u0002\u0005\u0015\u0017!C:oCB\u001c\bn\u001c;t!\u0019\t9-!5\u0002X:!\u0011\u0011ZAg\u001d\u0011\ty%a3\n\u0003yJ1!a4>\u0003\u001d\u0001\u0018mY6bO\u0016LA!a5\u0002V\n\u00191+Z9\u000b\u0007\u0005=W\bE\u0002_\u00033L1!a7/\u0005Q)\u00050Z2vi>\u0014\bk\u001c3t':\f\u0007o\u001d5pi\u00061rN\u001c$j]\u0006dgj\u001c8EK2,G/\u001a3Ti\u0006$X\rF\u0005r\u0003C\fY/a<\u0002r\"9\u00111\u001d\u0010A\u0002\u0005\u0015\u0018\u0001\u00039pIN#\u0018\r^3\u0011\u0007y\u000b9/C\u0002\u0002j:\u0012QBR5oC2\u0004v\u000eZ*uCR,\u0007BBAw=\u0001\u0007a/\u0001\u0004fq\u0016\u001c\u0017\n\u001a\u0005\b\u0003Ws\u0002\u0019AAW\u0011\u0019\t\u0019P\ba\u0001c\u0006iA-\u001a7fi\u00164%o\\7LqM\fQC]3n_Z,W\t_3dkR|'O\u0012:p[.C4\u000f\u0006\u0004\u0002$\u0005e\u00181 \u0005\u0007\u0003[|\u0002\u0019\u0001<\t\u000f\u0005ux\u00041\u0001\u0002\u0000\u0006QQ\u000f\u001d3bi\u0016$\u0007k\u001c3\u0011\t\t\u0005!1B\u0007\u0003\u0005\u0007QAA!\u0002\u0003\b\u0005)Qn\u001c3fY*\u0019!\u0011\u0002+\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0003\u000e\t\r!a\u0001)pI\u00069\"/Z7pm\u0016,\u00050Z2vi>\u0014hI]8n'B\f'o\u001b\u000b\bc\nM!Q\u0003B\f\u0011\u001d\tY\u000b\ta\u0001\u0003[Cq!a9!\u0001\u0004\t)\u000f\u0003\u0004\u0002n\u0002\u0002\rA^\u0001\u000fM&tG-\u0012=jiJ+\u0017m]8o)\u0019\u0011iB!\n\u0003(A!!q\u0004B\u0011\u001b\u0005\u0011\u0014b\u0001B\u0012e\tqQ\t_3dkR|'/\u0012=ji\u0016$\u0007bBArC\u0001\u0007\u0011Q\u001d\u0005\u0007\u0003[\f\u0003\u0019\u0001<\u0002#\u0015D\u0018\u000e\u001e*fCN|g.T3tg\u0006<W\r\u0006\u0005\u0002J\t5\"q\u0006B\u0019\u0011\u001d\t\u0019O\ta\u0001\u0003KDa!!<#\u0001\u00041\bbBA]E\u0001\u0007\u0011\u0011N\u0001\rM&tG-\u0012=ji\u000e{G-\u001a\u000b\u0005\u0003S\u00129\u0004C\u0004\u0002d\u000e\u0002\r!!:\u0002\u001b%\u001c\bk\u001c3J]\u0006\u001cG/\u001b<f)\r\t(Q\b\u0005\b\u0005\u007f!\u0003\u0019AA\u0000\u0003\r\u0001x\u000eZ\u0001\u001d\u000bb,7-\u001e;peB{Gm\u001d'jM\u0016\u001c\u0017p\u00197f\u001b\u0006t\u0017mZ3s!\tqfe\u0005\u0002'wQ\u0011!1I\u0001\u0012+:[ejT,O?\u0016C\u0016\nV0D\u001f\u0012+\u0015AE+O\u0017:{uKT0F1&#vlQ(E\u000b\u0002\n\u0001\u0003Z3tGJL'-Z#ySR\u001cu\u000eZ3\u0015\t\u0005%#\u0011\u000b\u0005\b\u0005'R\u0003\u0019AA5\u0003\u0011\u0019w\u000eZ3\u0002-\u0015DXmY;u_JLe.Y2uSZ\fG/[8o\r:,\"A!\u0017\u0011\r\tm#1MA\u0000\u001b\t\u0011iF\u0003\u0003\u0003`\t\u0005\u0014\u0001\u00034v]\u000e$\u0018n\u001c8\u000b\u0007\u0015\f9\"\u0003\u0003\u0003f\tu#!D+oCJLx\n]3sCR|'/A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005WR3A\u0019B7W\t\u0011y\u0007\u0005\u0003\u0003r\tmTB\u0001B:\u0015\u0011\u0011)Ha\u001e\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B={\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tu$1\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class ExecutorPodsLifecycleManager
implements Logging {
    private boolean shouldDeleteExecutors;
    private long missingPodDetectDelta;
    private Cache<Long, Long> removedExecutorsCache;
    private final SparkConf conf;
    private final KubernetesClient kubernetesClient;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private long lastFullSnapshotTs;
    private final HashSet<Object> inactivatedPods;
    private final String namespace;
    private final String sparkContainerName;
    private final int maxNumExecutorFailures;
    private volatile Set<Object> failedExecutorIds;
    private final ExecutorFailureTracker failureTracker;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static Clock $lessinit$greater$default$4() {
        return ExecutorPodsLifecycleManager$.MODULE$.$lessinit$greater$default$4();
    }

    public static UnaryOperator<Pod> executorInactivationFn() {
        return ExecutorPodsLifecycleManager$.MODULE$.executorInactivationFn();
    }

    public static String describeExitCode(int code) {
        return ExecutorPodsLifecycleManager$.MODULE$.describeExitCode(code);
    }

    public static int UNKNOWN_EXIT_CODE() {
        return ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkConf conf() {
        return this.conf;
    }

    private boolean shouldDeleteExecutors$lzycompute() {
        ExecutorPodsLifecycleManager executorPodsLifecycleManager = this;
        synchronized (executorPodsLifecycleManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.shouldDeleteExecutors = BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DELETE_EXECUTORS()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.shouldDeleteExecutors;
    }

    private boolean shouldDeleteExecutors() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.shouldDeleteExecutors$lzycompute();
        }
        return this.shouldDeleteExecutors;
    }

    private long missingPodDetectDelta$lzycompute() {
        ExecutorPodsLifecycleManager executorPodsLifecycleManager = this;
        synchronized (executorPodsLifecycleManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.missingPodDetectDelta = BoxesRunTime.unboxToLong((Object)this.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_MISSING_POD_DETECT_DELTA()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.missingPodDetectDelta;
    }

    private long missingPodDetectDelta() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.missingPodDetectDelta$lzycompute();
        }
        return this.missingPodDetectDelta;
    }

    private Cache<Long, Long> removedExecutorsCache$lzycompute() {
        ExecutorPodsLifecycleManager executorPodsLifecycleManager = this;
        synchronized (executorPodsLifecycleManager) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.removedExecutorsCache = CacheBuilder.newBuilder().expireAfterWrite(3L, TimeUnit.MINUTES).build();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.removedExecutorsCache;
    }

    private Cache<Long, Long> removedExecutorsCache() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.removedExecutorsCache$lzycompute();
        }
        return this.removedExecutorsCache;
    }

    private long lastFullSnapshotTs() {
        return this.lastFullSnapshotTs;
    }

    private void lastFullSnapshotTs_$eq(long x$1) {
        this.lastFullSnapshotTs = x$1;
    }

    private HashSet<Object> inactivatedPods() {
        return this.inactivatedPods;
    }

    private String namespace() {
        return this.namespace;
    }

    private String sparkContainerName() {
        return this.sparkContainerName;
    }

    public int maxNumExecutorFailures() {
        return this.maxNumExecutorFailures;
    }

    private Set<Object> failedExecutorIds() {
        return this.failedExecutorIds;
    }

    private void failedExecutorIds_$eq(Set<Object> x$1) {
        this.failedExecutorIds = x$1;
    }

    public ExecutorFailureTracker failureTracker() {
        return this.failureTracker;
    }

    public int getNumExecutorsFailed() {
        return this.failureTracker().numFailedExecutors();
    }

    public void start(KubernetesClusterSchedulerBackend schedulerBackend) {
        long eventProcessingInterval = BoxesRunTime.unboxToLong((Object)this.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_EVENT_PROCESSING_INTERVAL()));
        this.snapshotsStore.addSubscriber(eventProcessingInterval, (Function1<Seq<ExecutorPodsSnapshot>, BoxedUnit>)(Function1 & Serializable)executorPodsSnapshot -> {
            ExecutorPodsLifecycleManager.$anonfun$start$1(this, schedulerBackend, executorPodsSnapshot);
            return BoxedUnit.UNIT;
        });
    }

    public void stopApplication(int exitCode) {
        throw package$.MODULE$.exit(exitCode);
    }

    private void onNewSnapshots(KubernetesClusterSchedulerBackend schedulerBackend, Seq<ExecutorPodsSnapshot> snapshots) {
        HashSet execIdsRemovedInThisRound = HashSet$.MODULE$.empty();
        snapshots.foreach((Function1 & Serializable)snapshot -> {
            ExecutorPodsLifecycleManager.$anonfun$onNewSnapshots$1(this, schedulerBackend, execIdsRemovedInThisRound, snapshot);
            return BoxedUnit.UNIT;
        });
        Object object = this.inactivatedPods().nonEmpty() && snapshots.nonEmpty() ? this.inactivatedPods().filterInPlace((Function1)(JFunction1.mcZJ.sp & Serializable)x$2 -> ((ExecutorPodsSnapshot)snapshots.last()).executorPods().contains((Object)BoxesRunTime.boxToLong((long)x$2))) : BoxedUnit.UNIT;
        if (snapshots.nonEmpty() && this.lastFullSnapshotTs() != ((ExecutorPodsSnapshot)snapshots.last()).fullSnapshotTs()) {
            this.lastFullSnapshotTs_$eq(((ExecutorPodsSnapshot)snapshots.last()).fullSnapshotTs());
            scala.collection.immutable.Map lostExecutorsWithRegistrationTs = (scala.collection.immutable.Map)((MapOps)schedulerBackend.getExecutorsWithRegistrationTs().map((Function1 & Serializable)t -> new Tuple2.mcJJ.sp(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString((String)t._1())), t._2$mcJ$sp()))).$minus$minus((IterableOnce)((ExecutorPodsSnapshot)snapshots.last()).executorPods().keySet()).$minus$minus((IterableOnce)execIdsRemovedInThisRound);
            lostExecutorsWithRegistrationTs.foreach((Function1 & Serializable)x0$3 -> {
                ExecutorPodsLifecycleManager.$anonfun$onNewSnapshots$12(this, schedulerBackend, x0$3);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private boolean onFinalNonDeletedState(FinalPodState podState, long execId, KubernetesClusterSchedulerBackend schedulerBackend, boolean deleteFromK8s) {
        boolean deleted;
        block0: {
            deleted = this.removeExecutorFromSpark(schedulerBackend, podState, execId);
            if (!deleteFromK8s) break block0;
            this.removeExecutorFromK8s(execId, podState.pod());
        }
        return deleted;
    }

    private void removeExecutorFromK8s(long execId, Pod updatedPod) {
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            if (this.shouldDeleteExecutors()) {
                PodResource podToDelete = (PodResource)((Nameable)$this.kubernetesClient.pods().inNamespace(this.namespace())).withName(updatedPod.getMetadata().getName());
                if (podToDelete.get() != null) {
                    podToDelete.delete();
                    return;
                }
                return;
            }
            if (!this.inactivatedPods().contains((Object)BoxesRunTime.boxToLong((long)execId)) && !this.isPodInactive(updatedPod)) {
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Marking executor " + updatedPod.getMetadata().getName() + " as inactive since deletion is disabled.");
                ((EditReplacePatchable)((Nameable)$this.kubernetesClient.pods().inNamespace(this.namespace())).withName(updatedPod.getMetadata().getName())).edit(ExecutorPodsLifecycleManager$.MODULE$.executorInactivationFn());
                this.inactivatedPods().$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                return;
            }
        });
    }

    private boolean removeExecutorFromSpark(KubernetesClusterSchedulerBackend schedulerBackend, FinalPodState podState, long execId) {
        if (this.removedExecutorsCache().getIfPresent((Object)BoxesRunTime.boxToLong((long)execId)) == null) {
            this.removedExecutorsCache().put((Object)Predef$.MODULE$.long2Long(execId), (Object)Predef$.MODULE$.long2Long(execId));
            ExecutorExited exitReason = this.findExitReason(podState, execId);
            schedulerBackend.doRemoveExecutor(Long.toString(execId), (ExecutorLossReason)exitReason);
            return true;
        }
        return false;
    }

    private ExecutorExited findExitReason(FinalPodState podState, long execId) {
        Tuple2 tuple2;
        int exitCode = this.findExitCode(podState);
        FinalPodState finalPodState = podState;
        if (finalPodState instanceof PodDeleted) {
            v0 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)("The executor with id " + execId + " was deleted by a user or the framework."));
        } else {
            String msg = this.exitReasonMessage(podState, execId, exitCode);
            v0 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)msg);
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        boolean exitCausedByApp = tuple2._1$mcZ$sp();
        String exitMessage = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)exitCausedByApp), (Object)exitMessage);
        boolean exitCausedByApp2 = tuple22._1$mcZ$sp();
        String exitMessage2 = (String)tuple22._2();
        return new ExecutorExited(exitCode, exitCausedByApp2, exitMessage2);
    }

    private String exitReasonMessage(FinalPodState podState, long execId, int exitCode) {
        Pod pod = podState.pod();
        Option reason = Option$.MODULE$.apply((Object)pod.getStatus().getReason());
        Option message = Option$.MODULE$.apply((Object)pod.getStatus().getMessage());
        String explained = ExecutorPodsLifecycleManager$.MODULE$.describeExitCode(exitCode);
        String exitMsg = "The executor with id " + execId + " exited with exit code " + explained + ".";
        Option reasonStr = reason.map((Function1 & Serializable)r -> "The API gave the following brief reason: " + r);
        Option msgStr = message.map((Function1 & Serializable)m -> "The API gave the following message: " + m);
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |" + exitMsg + "\n       |" + reasonStr.getOrElse((Function0 & Serializable)() -> "") + "\n       |" + msgStr.getOrElse((Function0 & Serializable)() -> "") + "\n       |\n       |The API gave the following container statuses:\n       |\n       |" + KubernetesUtils$.MODULE$.containersDescription(pod, KubernetesUtils$.MODULE$.containersDescription$default$2()) + "\n      "));
    }

    private int findExitCode(FinalPodState podState) {
        return BoxesRunTime.unboxToInt((Object)CollectionConverters$.MODULE$.ListHasAsScala(podState.pod().getStatus().getContainerStatuses()).asScala().find((Function1 & Serializable)containerStatus -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsLifecycleManager.$anonfun$findExitCode$1(this, containerStatus))).map((Function1 & Serializable)terminatedContainer -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(terminatedContainer.getState().getTerminated().getExitCode()))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE()));
    }

    private boolean isPodInactive(Pod pod) {
        Object v = pod.getMetadata().getLabels().get(Constants$.MODULE$.SPARK_EXECUTOR_INACTIVE_LABEL());
        String string = "true";
        return !(v != null ? !v.equals(string) : string != null);
    }

    public static final /* synthetic */ void $anonfun$start$1(ExecutorPodsLifecycleManager $this, KubernetesClusterSchedulerBackend schedulerBackend$1, Seq executorPodsSnapshot) {
        $this.onNewSnapshots(schedulerBackend$1, (Seq<ExecutorPodsSnapshot>)executorPodsSnapshot);
        if ($this.failureTracker().numFailedExecutors() > $this.maxNumExecutorFailures()) {
            $this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Max number of executor failures "}))).log((Seq)Nil$.MODULE$).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(", ") reached"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.MAX_EXECUTOR_FAILURES$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)$this.maxNumExecutorFailures()))})))));
            $this.stopApplication(SparkExitCode$.MODULE$.EXCEED_MAX_EXECUTOR_FAILURES());
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$2(Tuple2 x0$1) {
        ExecutorPodState executorPodState;
        Tuple2 tuple2 = x0$1;
        return tuple2 != null && (executorPodState = (ExecutorPodState)tuple2._2()) instanceof PodFailed;
    }

    public static final /* synthetic */ void $anonfun$onNewSnapshots$1(ExecutorPodsLifecycleManager $this, KubernetesClusterSchedulerBackend schedulerBackend$2, HashSet execIdsRemovedInThisRound$1, ExecutorPodsSnapshot snapshot) {
        Set currentFailedExecutorIds = ((MapOps)snapshot.executorPods().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsLifecycleManager.$anonfun$onNewSnapshots$2(x0$1)))).keySet();
        Set newFailedExecutorIds = (Set)currentFailedExecutorIds.$minus$minus($this.failedExecutorIds());
        if (newFailedExecutorIds.nonEmpty()) {
            $this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " new failed executors."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.COUNT$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)newFailedExecutorIds.size()))}))));
            newFailedExecutorIds.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)x$1 -> $this.failureTracker().registerExecutorFailure());
        }
        $this.failedExecutorIds_$eq((Set<Object>)((Set)$this.failedExecutorIds().$plus$plus((IterableOnce)currentFailedExecutorIds)));
        snapshot.executorPods().foreach((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                long execId = tuple2._1$mcJ$sp();
                ExecutorPodState state = (ExecutorPodState)tuple2._2();
                ExecutorPodState executorPodState = state;
                if ($this.isPodInactive(executorPodState.pod())) {
                    return $this.inactivatedPods().$minus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                }
                if (executorPodState instanceof PodDeleted) {
                    PodDeleted podDeleted = (PodDeleted)executorPodState;
                    if ($this.removeExecutorFromSpark(schedulerBackend$2, podDeleted, execId)) {
                        execIdsRemovedInThisRound$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                        $this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Snapshot reported deleted executor with id " + execId + ", pod name " + state.pod().getMetadata().getName());
                    }
                    return $this.inactivatedPods().$minus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                }
                if (executorPodState instanceof PodFailed) {
                    boolean deleteFromK8s;
                    PodFailed podFailed = (PodFailed)executorPodState;
                    boolean bl = deleteFromK8s = !execIdsRemovedInThisRound$1.contains((Object)BoxesRunTime.boxToLong((long)execId));
                    if ($this.onFinalNonDeletedState(podFailed, execId, schedulerBackend$2, deleteFromK8s)) {
                        execIdsRemovedInThisRound$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                        $this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Snapshot reported failed executor with id " + execId + ", pod name " + state.pod().getMetadata().getName());
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (executorPodState instanceof PodSucceeded) {
                    boolean deleteFromK8s;
                    PodSucceeded podSucceeded = (PodSucceeded)executorPodState;
                    boolean bl = deleteFromK8s = !execIdsRemovedInThisRound$1.contains((Object)BoxesRunTime.boxToLong((long)execId));
                    if ($this.onFinalNonDeletedState(podSucceeded, execId, schedulerBackend$2, deleteFromK8s)) {
                        execIdsRemovedInThisRound$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                        if (schedulerBackend$2.isExecutorActive(Long.toString(execId))) {
                            $this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Snapshot reported succeeded executor with id "}))).log((Seq)Nil$.MODULE$).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ", even though the application has not "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXECUTOR_ID$.MODULE$, (Object)BoxesRunTime.boxToLong((long)execId))}))).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"requested for it to be removed."}))).log((Seq)Nil$.MODULE$))));
                            return BoxedUnit.UNIT;
                        }
                        $this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Snapshot reported succeeded executor with id " + execId + ", pod name " + state.pod().getMetadata().getName() + ".");
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static final /* synthetic */ void $anonfun$onNewSnapshots$12(ExecutorPodsLifecycleManager $this, KubernetesClusterSchedulerBackend schedulerBackend$2, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            long lostExecId = tuple2._1$mcJ$sp();
            long lostExecRegistrationTs = tuple2._2$mcJ$sp();
            if ($this.removedExecutorsCache().getIfPresent((Object)BoxesRunTime.boxToLong((long)lostExecId)) == null && $this.lastFullSnapshotTs() - lostExecRegistrationTs > $this.missingPodDetectDelta()) {
                String exitReasonMessage = "The executor with ID " + lostExecId + " (registered at " + lostExecRegistrationTs + " ms) was not found in the cluster at the polling time (" + $this.lastFullSnapshotTs() + " ms) which is after the accepted detect delta time (" + $this.missingPodDetectDelta() + " ms) configured by `" + Config$.MODULE$.KUBERNETES_EXECUTOR_MISSING_POD_DETECT_DELTA().key() + "`. The executor may have been deleted but the driver missed the deletion event. Marking this executor as failed.";
                $this.logDebug((Function0<String>)(Function0 & Serializable)() -> exitReasonMessage);
                ExecutorExited exitReason = new ExecutorExited(ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE(), false, exitReasonMessage);
                schedulerBackend$2.doRemoveExecutor(Long.toString(lostExecId), (ExecutorLossReason)exitReason);
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$findExitCode$1(ExecutorPodsLifecycleManager $this, ContainerStatus containerStatus) {
        String string = containerStatus.getName();
        String string2 = $this.sparkContainerName();
        return !(string != null ? !string.equals(string2) : string2 != null) && containerStatus.getState().getTerminated() != null;
    }

    public ExecutorPodsLifecycleManager(SparkConf conf, KubernetesClient kubernetesClient, ExecutorPodsSnapshotsStore snapshotsStore, Clock clock) {
        this.conf = conf;
        this.kubernetesClient = kubernetesClient;
        this.snapshotsStore = snapshotsStore;
        Logging.$init$((Logging)this);
        this.lastFullSnapshotTs = 0L;
        this.inactivatedPods = HashSet$.MODULE$.empty();
        this.namespace = (String)conf.get(Config$.MODULE$.KUBERNETES_NAMESPACE());
        this.sparkContainerName = (String)((Option)conf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_PODTEMPLATE_CONTAINER_NAME())).getOrElse((Function0 & Serializable)() -> Constants$.MODULE$.DEFAULT_EXECUTOR_CONTAINER_NAME());
        this.maxNumExecutorFailures = ExecutorFailureTracker$.MODULE$.maxNumExecutorFailures(conf);
        this.failedExecutorIds = Predef$.MODULE$.Set().empty();
        this.failureTracker = new ExecutorFailureTracker(conf, clock);
    }
}

