/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.source.libsvm;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.source.libsvm.LibSVMFileFormat$;
import org.apache.spark.ml.source.libsvm.LibSVMOptions;
import org.apache.spark.ml.source.libsvm.LibSVMOptions$;
import org.apache.spark.ml.source.libsvm.LibSVMOutputWriter;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.HadoopFileLinesReader;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.TextBasedFileFormat;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.SerializableConfiguration$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t-a!\u0002\r\u001a\u0001f)\u0003\"B(\u0001\t\u0003\u0001\u0006\"B*\u0001\t\u0003\"\u0006\"B/\u0001\t\u0003\"\u0006\"\u00020\u0001\t\u0013y\u0006\"\u00029\u0001\t\u0003\n\bbBA\u000e\u0001\u0011\u0005\u0013Q\u0004\u0005\b\u0003w\u0001A\u0011IA\u001f\u0011!\t9\tAA\u0001\n\u0003\u0001\u0006\"CAE\u0001\u0005\u0005I\u0011IAF\u0011%\tY\nAA\u0001\n\u0003\ti\nC\u0005\u0002&\u0002\t\t\u0011\"\u0001\u0002(\"I\u00111\u0017\u0001\u0002\u0002\u0013\u0005\u0013Q\u0017\u0005\n\u0003\u0003\u0004\u0011\u0011!C\u0001\u0003\u0007D\u0011\"a2\u0001\u0003\u0003%\t%!3\t\u0013\u00055\u0007!!A\u0005B\u0005=\u0007\"CAi\u0001\u0005\u0005I\u0011IAj\u000f)\t9.GA\u0001\u0012\u0003I\u0012\u0011\u001c\u0004\n1e\t\t\u0011#\u0001\u001a\u00037Daa\u0014\n\u0005\u0002\u0005M\b\u0002C/\u0013\u0003\u0003%)%!>\t\u0011\u0005](#!A\u0005\u0002BC\u0011\"!?\u0013\u0003\u0003%\t)a?\t\u0013\t\u0005!#!A\u0005\n\t\r!\u0001\u0005'jEN3VJR5mK\u001a{'/\\1u\u0015\tQ2$\u0001\u0004mS\n\u001ch/\u001c\u0006\u00039u\taa]8ve\u000e,'B\u0001\u0010 \u0003\tiGN\u0003\u0002!C\u0005)1\u000f]1sW*\u0011!eI\u0001\u0007CB\f7\r[3\u000b\u0003\u0011\n1a\u001c:h'\u0019\u0001a\u0005\r\u001c=\u0005B\u0011qEL\u0007\u0002Q)\u0011\u0011FK\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002,Y\u0005IQ\r_3dkRLwN\u001c\u0006\u0003[}\t1a]9m\u0013\ty\u0003FA\nUKb$()Y:fI\u001aKG.\u001a$pe6\fG\u000f\u0005\u00022i5\t!G\u0003\u00024Y\u000591o\\;sG\u0016\u001c\u0018BA\u001b3\u0005I!\u0015\r^1T_V\u00148-\u001a*fO&\u001cH/\u001a:\u0011\u0005]RT\"\u0001\u001d\u000b\u0005ez\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005mB$a\u0002'pO\u001eLgn\u001a\t\u0003{\u0001k\u0011A\u0010\u0006\u0002\u007f\u0005)1oY1mC&\u0011\u0011I\u0010\u0002\b!J|G-^2u!\t\u0019EJ\u0004\u0002E\u0015:\u0011Q)S\u0007\u0002\r*\u0011q\tS\u0001\u0007yI|w\u000e\u001e \u0004\u0001%\tq(\u0003\u0002L}\u00059\u0001/Y2lC\u001e,\u0017BA'O\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tYe(\u0001\u0004=S:LGO\u0010\u000b\u0002#B\u0011!\u000bA\u0007\u00023\u0005I1\u000f[8si:\u000bW.\u001a\u000b\u0002+B\u0011aK\u0017\b\u0003/b\u0003\"!\u0012 \n\u0005es\u0014A\u0002)sK\u0012,g-\u0003\u0002\\9\n11\u000b\u001e:j]\u001eT!!\u0017 \u0002\u0011Q|7\u000b\u001e:j]\u001e\fAB^3sS\u001aL8k\u00195f[\u0006$2\u0001Y2l!\ti\u0014-\u0003\u0002c}\t!QK\\5u\u0011\u0015!G\u00011\u0001f\u0003)!\u0017\r^1TG\",W.\u0019\t\u0003M&l\u0011a\u001a\u0006\u0003Q2\nQ\u0001^=qKNL!A[4\u0003\u0015M#(/^2u)f\u0004X\rC\u0003m\t\u0001\u0007Q.\u0001\u0006g_J<&/\u001b;j]\u001e\u0004\"!\u00108\n\u0005=t$a\u0002\"p_2,\u0017M\\\u0001\fS:4WM]*dQ\u0016l\u0017\rF\u0003skn\f\t\u0001E\u0002>g\u0016L!\u0001\u001e \u0003\r=\u0003H/[8o\u0011\u00151X\u00011\u0001x\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\tA\u00180D\u0001-\u0013\tQHF\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u0003}\u000b\u0001\u0007Q0A\u0004paRLwN\\:\u0011\tYsX+V\u0005\u0003\u007fr\u00131!T1q\u0011\u001d\t\u0019!\u0002a\u0001\u0003\u000b\tQAZ5mKN\u0004RaQA\u0004\u0003\u0017I1!!\u0003O\u0005\r\u0019V-\u001d\t\u0005\u0003\u001b\t9\"\u0004\u0002\u0002\u0010)!\u0011\u0011CA\n\u0003\t17OC\u0002\u0002\u0016\u0005\na\u0001[1e_>\u0004\u0018\u0002BA\r\u0003\u001f\u0011!BR5mKN#\u0018\r^;t\u00031\u0001(/\u001a9be\u0016<&/\u001b;f))\ty\"!\n\u0002(\u0005]\u0012\u0011\b\t\u0004O\u0005\u0005\u0012bAA\u0012Q\t\u0019r*\u001e;qkR<&/\u001b;fe\u001a\u000b7\r^8ss\")aO\u0002a\u0001o\"9\u0011\u0011\u0006\u0004A\u0002\u0005-\u0012a\u00016pEB!\u0011QFA\u001a\u001b\t\tyC\u0003\u0003\u00022\u0005M\u0011!C7baJ,G-^2f\u0013\u0011\t)$a\f\u0003\u0007){'\rC\u0003}\r\u0001\u0007Q\u0010C\u0003e\r\u0001\u0007Q-A\u0006ck&dGMU3bI\u0016\u0014H\u0003EA \u0003;\ny&!\u0019\u0002f\u0005%\u0014QOA<!\u001di\u0014\u0011IA#\u0003\u0017J1!a\u0011?\u0005%1UO\\2uS>t\u0017\u0007E\u0002(\u0003\u000fJ1!!\u0013)\u0005=\u0001\u0016M\u001d;ji&|g.\u001a3GS2,\u0007#B\"\u0002N\u0005E\u0013bAA(\u001d\nA\u0011\n^3sCR|'\u000f\u0005\u0003\u0002T\u0005eSBAA+\u0015\r\t9\u0006L\u0001\tG\u0006$\u0018\r\\=ti&!\u00111LA+\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u000bY<\u0001\u0019A<\t\u000b\u0011<\u0001\u0019A3\t\r\u0005\rt\u00011\u0001f\u0003=\u0001\u0018M\u001d;ji&|gnU2iK6\f\u0007BBA4\u000f\u0001\u0007Q-\u0001\bsKF,\u0018N]3e'\u000eDW-\\1\t\u000f\u0005-t\u00011\u0001\u0002n\u00059a-\u001b7uKJ\u001c\b#B\"\u0002\b\u0005=\u0004cA\u0019\u0002r%\u0019\u00111\u000f\u001a\u0003\r\u0019KG\u000e^3s\u0011\u0015ax\u00011\u0001~\u0011\u001d\tIh\u0002a\u0001\u0003w\n!\u0002[1e_>\u00048i\u001c8g!\u0011\ti(a!\u000e\u0005\u0005}$\u0002BAA\u0003'\tAaY8oM&!\u0011QQA@\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006!1m\u001c9z\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0012\t\u0005\u0003\u001f\u000bI*\u0004\u0002\u0002\u0012*!\u00111SAK\u0003\u0011a\u0017M\\4\u000b\u0005\u0005]\u0015\u0001\u00026bm\u0006L1aWAI\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ty\nE\u0002>\u0003CK1!a)?\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tI+a,\u0011\u0007u\nY+C\u0002\u0002.z\u00121!\u00118z\u0011%\t\tlCA\u0001\u0002\u0004\ty*A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003o\u0003b!!/\u0002@\u0006%VBAA^\u0015\r\tiLP\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA(\u0003w\u000b\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004[\u0006\u0015\u0007\"CAY\u001b\u0005\u0005\t\u0019AAU\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u00055\u00151\u001a\u0005\n\u0003cs\u0011\u0011!a\u0001\u0003?\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003?\u000ba!Z9vC2\u001cHcA7\u0002V\"I\u0011\u0011\u0017\t\u0002\u0002\u0003\u0007\u0011\u0011V\u0001\u0011\u0019&\u00147KV'GS2,gi\u001c:nCR\u0004\"A\u0015\n\u0014\u000bI\ti.!;\u0011\u000b\u0005}\u0017Q])\u000e\u0005\u0005\u0005(bAAr}\u00059!/\u001e8uS6,\u0017\u0002BAt\u0003C\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c81!\u0011\tY/!=\u000e\u0005\u00055(\u0002BAx\u0003+\u000b!![8\n\u00075\u000bi\u000f\u0006\u0002\u0002ZR\u0011\u0011QR\u0001\u0006CB\u0004H._\u0001\bk:\f\u0007\u000f\u001d7z)\ri\u0017Q \u0005\t\u0003\u007f4\u0012\u0011!a\u0001#\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t\u0015\u0001\u0003BAH\u0005\u000fIAA!\u0003\u0002\u0012\n1qJ\u00196fGR\u0004")
public class LibSVMFileFormat
extends TextBasedFileFormat
implements DataSourceRegister,
Logging,
Product,
Serializable {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static boolean unapply(LibSVMFileFormat x$0) {
        return LibSVMFileFormat$.MODULE$.unapply(x$0);
    }

    public static LibSVMFileFormat apply() {
        return LibSVMFileFormat$.MODULE$.apply();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String shortName() {
        return "libsvm";
    }

    public String toString() {
        return "LibSVM";
    }

    private void verifySchema(StructType dataSchema, boolean forWriting) {
        if (dataSchema.size() != 2 || !DataTypeUtils$.MODULE$.sameType(dataSchema.apply(0).dataType(), DataTypes.DoubleType) || !DataTypeUtils$.MODULE$.sameType(dataSchema.apply(1).dataType(), (DataType)new VectorUDT()) || !forWriting && (int)dataSchema.apply(1).metadata().getLong(LibSVMOptions$.MODULE$.NUM_FEATURES()) <= 0) {
            throw new IOException("Illegal schema for libsvm data, schema=" + dataSchema);
        }
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, scala.collection.immutable.Map<String, String> options, Seq<FileStatus> files) {
        LibSVMOptions libSVMOptions = new LibSVMOptions(options);
        int numFeatures = BoxesRunTime.unboxToInt((Object)libSVMOptions.numFeatures().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> {
            Predef$.MODULE$.require(files.nonEmpty(), (Function0 & Serializable)() -> "No input path specified for libsvm data");
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "'numFeatures' option not specified, determining the number of features by going though the input. If you know the number in advance, please specify it via 'numFeatures' option to avoid the extra scan.");
            Seq paths = (Seq)files.map((Function1 & Serializable)x$1 -> x$1.getPath().toString());
            RDD<Tuple3<Object, int[], double[]>> parsed = MLUtils$.MODULE$.parseLibSVMFile(sparkSession, (Seq<String>)paths, options);
            return MLUtils$.MODULE$.computeNumFeatures(parsed);
        }));
        StructField labelField = new StructField("label", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        Metadata extraMetadata = new MetadataBuilder().putLong(LibSVMOptions$.MODULE$.NUM_FEATURES(), (long)numFeatures).build();
        AttributeGroup attrGroup = new AttributeGroup("features", numFeatures);
        StructField featuresField = attrGroup.toStructField(extraMetadata);
        return new Some((Object)new StructType((StructField[])((Object[])new StructField[]{labelField, featuresField})));
    }

    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, scala.collection.immutable.Map<String, String> options, StructType dataSchema) {
        this.verifySchema(dataSchema, true);
        return new OutputWriterFactory(null){

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new LibSVMOutputWriter(path, dataSchema, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return ".libsvm" + CodecStreams$.MODULE$.getCompressionExtension((JobContext)context);
            }
        };
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, scala.collection.immutable.Map<String, String> options, Configuration hadoopConf) {
        this.verifySchema(dataSchema, false);
        int numFeatures = (int)dataSchema.apply("features").metadata().getLong(LibSVMOptions$.MODULE$.NUM_FEATURES());
        Predef$.MODULE$.assert(numFeatures > 0);
        LibSVMOptions libSVMOptions = new LibSVMOptions(options);
        boolean isSparse = libSVMOptions.isSparse();
        Broadcast broadcastedHadoopConf = SerializableConfiguration$.MODULE$.broadcast(sparkSession.sparkContext(), hadoopConf);
        return (Function1 & Serializable)file -> {
            HadoopFileLinesReader linesReader = (HadoopFileLinesReader)Utils$.MODULE$.createResourceUninterruptiblyIfInTaskThread((Function0 & Serializable)() -> new HadoopFileLinesReader(file, ((SerializableConfiguration)broadcastedHadoopConf.value()).value()));
            Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable)x$2 -> x$2.addTaskCompletionListener((Function1 & Serializable)x$3 -> {
                linesReader.close();
                return BoxedUnit.UNIT;
            }));
            Iterator points = linesReader.map((Function1 & Serializable)x$4 -> x$4.toString().trim()).filterNot((Function1 & Serializable)line -> BoxesRunTime.boxToBoolean((boolean)LibSVMFileFormat.$anonfun$buildReader$6(line))).map((Function1 & Serializable)line -> {
                Tuple3<Object, int[], double[]> tuple3 = MLUtils$.MODULE$.parseLibSVMRecord((String)line);
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                double label = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                int[] indices = (int[])tuple3._2();
                double[] values = (double[])tuple3._3();
                Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)label), (Object)indices, (Object)values);
                double label2 = BoxesRunTime.unboxToDouble((Object)tuple32._1());
                int[] indices2 = (int[])tuple32._2();
                double[] values2 = (double[])tuple32._3();
                return new LabeledPoint(label2, Vectors$.MODULE$.sparse(numFeatures, indices2, values2));
            });
            ExpressionEncoder.Serializer toRow = ExpressionEncoder$.MODULE$.apply(dataSchema).createSerializer();
            Seq fullOutput = (Seq)dataSchema.map((Function1 & Serializable)f -> {
                String x$1 = f.name();
                DataType x$2 = f.dataType();
                boolean x$3 = f.nullable();
                Metadata x$4 = f.metadata();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
                Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
                return new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
            });
            Seq requiredOutput = (Seq)fullOutput.filter((Function1 & Serializable)a -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fieldNames()), (Object)a.name())));
            UnsafeProjection requiredColumns = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)requiredOutput, fullOutput);
            return points.map((Function1 & Serializable)pt -> {
                SparseVector features = isSparse ? pt.features().toSparse() : pt.features().toDense();
                return requiredColumns.apply(toRow.apply((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)pt.label()), features}))));
            });
        };
    }

    public LibSVMFileFormat copy() {
        return new LibSVMFileFormat();
    }

    public String productPrefix() {
        return "LibSVMFileFormat";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof LibSVMFileFormat;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof LibSVMFileFormat && ((LibSVMFileFormat)x$1).canEqual(this);
    }

    public static final /* synthetic */ boolean $anonfun$buildReader$6(String line) {
        return line.isEmpty() || line.startsWith("#");
    }

    public LibSVMFileFormat() {
        Logging.$init$((Logging)this);
        Product.$init$((Product)this);
    }
}

